/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.net.URI;
import org.apache.karaf.admin.management.AdminServiceMBean;
import org.fusesource.fabric.api.Agent;
import org.fusesource.fabric.api.AgentProvider;
import org.fusesource.fabric.api.CreateAgentArguments;
import org.fusesource.fabric.service.AgentTemplate;
import org.fusesource.fabric.service.FabricServiceImpl;

public class ChildAgentProvider
implements AgentProvider {
    final FabricServiceImpl service;

    public ChildAgentProvider(FabricServiceImpl service) {
        this.service = service;
    }

    @Override
    public void create(URI proxyUri, URI agentUri, final String name, final String zooKeeperUrl, final boolean isClusterServer, final boolean debugAgent, final int number) {
        String[] uip;
        String parentName = FabricServiceImpl.getParentFromURI(agentUri);
        Agent parent = this.service.getAgent(parentName);
        AgentTemplate agentTemplate = this.service.getAgentTemplate(parent);
        String ui = agentUri.getUserInfo();
        String[] stringArray = uip = ui != null ? ui.split(":") : null;
        if (uip != null) {
            agentTemplate.setLogin(uip[0]);
            agentTemplate.setPassword(uip[1]);
        }
        agentTemplate.execute(new AgentTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                String javaOpts;
                String string = javaOpts = zooKeeperUrl != null ? "-Dzookeeper.url=\"" + zooKeeperUrl + "\" -Xmx512M -server" : "";
                if (debugAgent) {
                    javaOpts = javaOpts + " -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5005";
                }
                if (isClusterServer) {
                    javaOpts = javaOpts + " -Densemble.auto.start=true";
                }
                String features = "fabric-agent";
                String featuresUrls = "mvn:org.fusesource.fabric/fuse-fabric/1.1/xml/features";
                for (int i = 1; i <= number; ++i) {
                    String agentName = name;
                    if (number > 1) {
                        agentName = agentName + i;
                    }
                    adminService.createInstance(agentName, 0, 0, 0, null, javaOpts, features, featuresUrls);
                    adminService.startInstance(agentName, null);
                }
                return null;
            }
        });
    }

    @Override
    public void create(URI proxyUri, URI agentUri, String name, String zooKeeperUrl, boolean isClusterServer, boolean debugAgent) {
        this.create(proxyUri, agentUri, name, zooKeeperUrl, isClusterServer, debugAgent, 1);
    }

    @Override
    public void create(URI proxyUri, URI agentUri, String name, String zooKeeperUrl) {
        this.create(proxyUri, agentUri, name, zooKeeperUrl, false, false);
    }

    @Override
    public boolean create(CreateAgentArguments args, String name, String zooKeeperUrl) throws Exception {
        return false;
    }
}

