/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.karaf.admin.management.AdminServiceMBean;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.fusesource.fabric.api.Agent;
import org.fusesource.fabric.api.AgentProvider;
import org.fusesource.fabric.api.CreateAgentArguments;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.FabricService;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.internal.AgentImpl;
import org.fusesource.fabric.internal.ProfileImpl;
import org.fusesource.fabric.internal.VersionImpl;
import org.fusesource.fabric.internal.ZooKeeperUtils;
import org.fusesource.fabric.service.AgentTemplate;
import org.fusesource.fabric.service.ChildAgentProvider;
import org.fusesource.fabric.service.FabricServiceImplMBean;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.IZKClient;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FabricServiceImpl
implements FabricService,
FabricServiceImplMBean {
    private transient Logger logger = LoggerFactory.getLogger(FabricServiceImpl.class);
    public static final String DEFAULT_VERSION = "base";
    private static final String DEFAULT_PROFILE = "default";
    private IZKClient zooKeeper;
    private Map<String, AgentProvider> providers = new ConcurrentHashMap<String, AgentProvider>();
    private ConfigurationAdmin configurationAdmin;
    private String profile = "default";
    private ObjectName mbeanName;
    private String userName = "admin";
    private String password = "admin";

    public FabricServiceImpl() {
        this.providers.put("child", new ChildAgentProvider(this));
    }

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public Agent getCurrentAgent() {
        String name = this.getCurrentAgentName();
        return this.getAgent(name);
    }

    @Override
    public String getCurrentAgentName() {
        return System.getProperty("karaf.name");
    }

    public ObjectName getMbeanName() throws MalformedObjectNameException {
        if (this.mbeanName == null) {
            this.mbeanName = new ObjectName("org.fusesource.fabric:type=FabricService");
        }
        return this.mbeanName;
    }

    public void setMbeanName(ObjectName mbeanName) {
        this.mbeanName = mbeanName;
    }

    public ConfigurationAdmin getConfigurationAdmin() {
        return this.configurationAdmin;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    @Override
    public Agent[] getAgents() {
        try {
            HashMap<String, Agent> agents = new HashMap<String, Agent>();
            List configs = this.zooKeeper.getChildren(ZkPath.CONFIGS_AGENTS.getPath(new String[0]));
            for (String name : configs) {
                String parentId = this.getParentOf(name);
                if (parentId.isEmpty()) {
                    if (agents.containsKey(name)) continue;
                    AgentImpl agent = new AgentImpl(null, name, this);
                    agents.put(name, agent);
                    continue;
                }
                Agent parent = (Agent)agents.get(parentId);
                if (parent == null) {
                    parent = new AgentImpl(null, parentId, this);
                    agents.put(parentId, parent);
                }
                AgentImpl agent = new AgentImpl(parent, name, this);
                agents.put(name, agent);
            }
            return agents.values().toArray(new Agent[agents.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    private String getParentOf(String name) throws InterruptedException, KeeperException {
        if (this.zooKeeper != null) {
            try {
                return this.zooKeeper.getStringData(ZkPath.AGENT_PARENT.getPath(new String[]{name})).trim();
            }
            catch (KeeperException.NoNodeException e) {
            }
            catch (Throwable e) {
                this.logger.warn("Failed to find parent " + name + ". Reason: " + e);
            }
        }
        return "";
    }

    @Override
    public Agent getAgent(String name) {
        if (name == null) {
            return null;
        }
        try {
            Agent parent = null;
            String parentId = this.getParentOf(name);
            if (parentId != null && !parentId.isEmpty()) {
                parent = this.getAgent(parentId);
            }
            return new AgentImpl(parent, name, this);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public void startAgent(final Agent agent) {
        if (agent.isRoot()) {
            throw new IllegalArgumentException("Can not stop root agents");
        }
        this.getAgentTemplate(agent.getParent()).execute(new AgentTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.startInstance(agent.getId(), null);
                return null;
            }
        });
    }

    public void stopAgent(final Agent agent) {
        if (agent.isRoot()) {
            throw new IllegalArgumentException("Can not stop root agents");
        }
        this.getAgentTemplate(agent.getParent()).execute(new AgentTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.stopInstance(agent.getId());
                return null;
            }
        });
    }

    @Override
    public Agent createAgent(String name) {
        try {
            String zooKeeperUrl = this.getZooKeeperUrl();
            this.createAgentConfig("", name);
            return new AgentImpl(null, name, this);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Agent createAgent(String url, String name, boolean isClusterServer, boolean debugAgent) {
        return this.createAgents(url, name, isClusterServer, debugAgent, 1)[0];
    }

    @Override
    public Agent[] createAgents(String url, String name, boolean isClusterServer, boolean debugAgent, int number) {
        Agent[] agents = new Agent[number];
        try {
            URI uri = URI.create(url);
            AgentProvider provider = this.getProvider(uri.getScheme());
            if (provider == null) {
                throw new FabricException("Unable to find an agent provider supporting uri '" + url + "'");
            }
            if (!isClusterServer) {
                String zooKeeperUrl = this.getZooKeeperUrl();
                for (int i = 0; i < number; ++i) {
                    String agentName = name;
                    if (number > 1) {
                        agentName = agentName + (i + 1);
                    }
                    String parent = "";
                    if (provider instanceof ChildAgentProvider) {
                        parent = FabricServiceImpl.getParentFromURI(uri);
                    }
                    this.createAgentConfig(parent, agentName);
                    agents[i] = new AgentImpl(null, agentName, this);
                }
                provider.create(this.getMavenRepoURI(), uri, name, zooKeeperUrl, isClusterServer, debugAgent, number);
            } else {
                provider.create(this.getMavenRepoURI(), uri, name, null, isClusterServer, debugAgent, number);
            }
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
        return agents;
    }

    public static String getParentFromURI(URI uri) {
        String parent = uri.getHost();
        if (parent == null) {
            parent = uri.getSchemeSpecificPart();
        }
        return parent;
    }

    @Override
    public Agent[] createAgents(CreateAgentArguments args, String name, int number) {
        Agent[] agents = new Agent[number];
        try {
            for (int i = 0; i < number; ++i) {
                String agentName = name;
                if (number > 1) {
                    agentName = agentName + (i + 1);
                }
                agents[i] = this.createAgent(args, agentName);
            }
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
        return agents;
    }

    @Override
    public Agent createAgent(CreateAgentArguments args, String name) {
        try {
            String zooKeeperUrl = this.getZooKeeperUrl();
            this.createAgentConfig("", name);
            Agent agent = this.doCreateAgentFromArguments(args, name, zooKeeperUrl);
            if (agent == null) {
                throw new IllegalArgumentException("Unknown CreateAgentArguments " + args + " when creating agent " + name);
            }
            return agent;
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public boolean createRemoteAgent(CreateAgentArguments args, String name) {
        try {
            String zooKeeperUrl = this.getZooKeeperUrl();
            Agent agent = this.doCreateAgentFromArguments(args, name, zooKeeperUrl);
            return agent != null;
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    protected Agent doCreateAgentFromArguments(CreateAgentArguments args, String name, String zooKeeperUrl) throws Exception {
        for (AgentProvider provider : this.providers.values()) {
            if (!provider.create(args, name, zooKeeperUrl)) continue;
            return new AgentImpl(null, name, this);
        }
        return null;
    }

    @Override
    public Agent createAgent(Agent parent, final CreateAgentArguments args, final String name) {
        this.createAgentConfig(parent.getId(), name);
        AgentTemplate agentTemplate = this.getAgentTemplate(parent);
        if (agentTemplate.execute(new AgentTemplate.FabricServiceCallback<Boolean>(){

            @Override
            public Boolean doWithFabricService(FabricServiceImplMBean fabricService) throws Exception {
                return fabricService.createRemoteAgent(args, name);
            }
        }).booleanValue()) {
            return new AgentImpl(null, name, this);
        }
        return null;
    }

    @Override
    public Agent createAgent(String url, String name) {
        return this.createAgent(url, name, false, false);
    }

    public AgentProvider getProvider(String scheme) {
        return this.providers.get(scheme);
    }

    public Map<String, AgentProvider> getProviders() {
        return Collections.unmodifiableMap(this.providers);
    }

    @Override
    public URI getMavenRepoURI() {
        URI uri = null;
        try {
            uri = new URI("http://repo.fusesource.com/nexus/content/groups/public-snapshots/");
            if (this.zooKeeper.exists(ZkPath.CONFIGS_MAVEN_REPO.getPath(new String[0])) != null) {
                String mavenRepo = this.zooKeeper.getStringData(ZkPath.CONFIGS_MAVEN_REPO.getPath(new String[0]));
                if (mavenRepo != null && !mavenRepo.endsWith("/")) {
                    mavenRepo = mavenRepo + "/";
                }
                uri = new URI(mavenRepo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uri;
    }

    public void registerProvider(String scheme, AgentProvider provider) {
        this.providers.put(scheme, provider);
    }

    public void registerProvider(AgentProvider provider, Map<String, Object> properties) {
        String scheme = (String)properties.get("fabric.agent.protocol");
        this.registerProvider(scheme, provider);
    }

    public void unregisterProvider(String scheme) {
        if (this.providers != null && scheme != null) {
            this.providers.remove(scheme);
        }
    }

    public void unregisterProvider(AgentProvider provider, Map<String, Object> properties) {
        String scheme = (String)properties.get("fabric.agent.protocol");
        this.unregisterProvider(scheme);
    }

    public void registerMBeanServer(MBeanServer mbeanServer) {
        try {
            ObjectName name = this.getMbeanName();
            ObjectInstance objectInstance = mbeanServer.registerMBean(this, name);
        }
        catch (Exception e) {
            this.logger.warn("An error occured during mbean server registration: " + e, (Throwable)e);
        }
    }

    public void unregisterMBeanServer(MBeanServer mbeanServer) {
        if (mbeanServer != null) {
            try {
                mbeanServer.unregisterMBean(this.getMbeanName());
            }
            catch (Exception e) {
                this.logger.warn("An error occured during mbean server registration: " + e, (Throwable)e);
            }
        }
    }

    @Override
    public Agent createAgent(final Agent parent, final String name, final boolean debugAgent) {
        final String zooKeeperUrl = this.getZooKeeperUrl();
        this.createAgentConfig(parent.getId(), name);
        return this.getAgentTemplate(parent).execute(new AgentTemplate.AdminServiceCallback<Agent>(){

            @Override
            public Agent doWithAdminService(AdminServiceMBean adminService) throws Exception {
                String javaOpts;
                String string = javaOpts = zooKeeperUrl != null ? "-Dzookeeper.url=\"" + zooKeeperUrl + "\" -Xmx512M -server" : "";
                if (debugAgent) {
                    javaOpts = javaOpts + " -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=5005";
                }
                String features = "fabric-agent";
                String featuresUrls = "mvn:org.fusesource.fabric/fuse-fabric/1.1/xml/features";
                adminService.createInstance(name, 0, 0, 0, null, javaOpts, features, featuresUrls);
                adminService.startInstance(name, null);
                return new AgentImpl(parent, name, FabricServiceImpl.this);
            }
        });
    }

    @Override
    public Agent createAgent(Agent parent, String name) {
        return this.createAgent(parent, name, false);
    }

    public void destroy(Agent agent) {
        if (agent.getParent() == null) {
            throw new UnsupportedOperationException();
        }
        this.destroyChild(agent.getParent(), agent.getId());
    }

    private void destroyChild(Agent parent, final String name) {
        this.getAgentTemplate(parent).execute(new AgentTemplate.AdminServiceCallback<Object>(){

            @Override
            public Object doWithAdminService(AdminServiceMBean adminService) throws Exception {
                adminService.stopInstance(name);
                adminService.destroyInstance(name);
                FabricServiceImpl.this.zooKeeper.deleteWithChildren(ZkPath.CONFIG_AGENT.getPath(new String[]{name}));
                return null;
            }
        });
    }

    private String getZooKeeperUrl() {
        String zooKeeperUrl = null;
        try {
            Configuration config = this.configurationAdmin.getConfiguration("org.fusesource.fabric.zookeeper", null);
            zooKeeperUrl = (String)config.getProperties().get("zookeeper.url");
            if (zooKeeperUrl == null) {
                throw new IllegalStateException("Unable to find the zookeeper url");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return zooKeeperUrl;
    }

    private void createAgentConfig(String parent, String name) {
        try {
            String configVersion = this.getDefaultVersion().getName();
            ZooKeeperUtils.createDefault(this.zooKeeper, ZkPath.CONFIG_AGENT.getPath(new String[]{name}), configVersion);
            ZooKeeperUtils.createDefault(this.zooKeeper, ZkPath.CONFIG_VERSIONS_AGENT.getPath(new String[]{configVersion, name}), this.profile);
            this.zooKeeper.createOrSetWithParents(ZkPath.AGENT_PARENT.getPath(new String[]{name}), parent, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version getDefaultVersion() {
        try {
            String version = null;
            if (this.zooKeeper.exists(ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0])) != null) {
                version = this.zooKeeper.getStringData(ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]));
            }
            if (version == null || version.isEmpty()) {
                version = DEFAULT_VERSION;
                ZooKeeperUtils.createDefault(this.zooKeeper, ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), version);
                ZooKeeperUtils.createDefault(this.zooKeeper, ZkPath.CONFIG_VERSION.getPath(new String[]{version}), null);
            }
            return new VersionImpl(version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setDefaultVersion(Version version) {
        try {
            ZooKeeperUtils.set(this.zooKeeper, ZkPath.CONFIG_DEFAULT_VERSION.getPath(new String[0]), version.getName());
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version createVersion(String version) {
        try {
            this.zooKeeper.createWithParents(ZkPath.CONFIG_VERSION.getPath(new String[]{version}), null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.zooKeeper.createWithParents(ZkPath.CONFIG_VERSIONS_PROFILES.getPath(new String[]{version}), null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            return new VersionImpl(version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version createVersion(Version parent, String toVersion) {
        try {
            ZooKeeperUtils.copy(this.zooKeeper, ZkPath.CONFIG_VERSION.getPath(new String[]{parent.getName()}), ZkPath.CONFIG_VERSION.getPath(new String[]{toVersion}));
            return new VersionImpl(toVersion, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public void deleteVersion(String version) {
        try {
            this.zooKeeper.deleteWithChildren(ZkPath.CONFIG_VERSION.getPath(new String[]{version}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version[] getVersions() {
        try {
            ArrayList<VersionImpl> versions = new ArrayList<VersionImpl>();
            List children = this.zooKeeper.getChildren(ZkPath.CONFIG_VERSIONS.getPath(new String[0]));
            for (String child : children) {
                versions.add(new VersionImpl(child, this));
            }
            return versions.toArray(new Version[versions.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Version getVersion(String name) {
        try {
            if (this.zooKeeper != null && this.zooKeeper.isConnected() && this.zooKeeper.exists(ZkPath.CONFIG_VERSION.getPath(new String[]{name})) == null) {
                throw new FabricException("Version '" + name + "' does not exist!");
            }
            return new VersionImpl(name, this);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Profile[] getProfiles(String version) {
        try {
            List names = this.zooKeeper.getChildren(ZkPath.CONFIG_VERSIONS_PROFILES.getPath(new String[]{version}));
            ArrayList<ProfileImpl> profiles = new ArrayList<ProfileImpl>();
            for (String name : names) {
                profiles.add(new ProfileImpl(name, version, this));
            }
            return profiles.toArray(new Profile[profiles.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Profile getProfile(String version, String name) {
        try {
            String path = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{version, name});
            if (this.zooKeeper.exists(path) == null) {
                return null;
            }
            return new ProfileImpl(name, version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Profile createProfile(String version, String name) {
        try {
            ZooKeeperUtils.create(this.zooKeeper, ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{version, name}));
            return new ProfileImpl(name, version, this);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void deleteProfile(Profile profile) {
        try {
            this.zooKeeper.deleteWithChildren(ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{profile.getVersion(), profile.getId()}));
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    protected AgentTemplate getAgentTemplate(Agent agent) {
        boolean cacheJmx = false;
        return new AgentTemplate(agent, cacheJmx, this.userName, this.password);
    }
}

