/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.service;

import java.io.IOException;
import javax.management.remote.JMXConnector;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.service.JmxTemplateSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxTemplate
extends JmxTemplateSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxTemplate.class);
    private JMXConnector connector;

    public JmxTemplate() {
    }

    public JmxTemplate(JMXConnector connector) {
        this.connector = connector;
    }

    @Override
    public <T> T execute(JmxTemplateSupport.JmxConnectorCallback<T> callback) {
        JMXConnector connector = this.getConnector();
        if (connector == null) {
            LOGGER.warn("No JMX Connector yet " + this);
            return null;
        }
        try {
            return callback.doWithJmxConnector(connector);
        }
        catch (FabricException e) {
            throw e;
        }
        catch (Exception e) {
            try {
                this.close();
            }
            catch (Exception e2) {
                LOGGER.debug("Exception when attempting to close connection " + e2 + " after getting exception: " + e, (Throwable)e2);
            }
            throw new FabricException(e);
        }
    }

    public synchronized void close() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                throw new FabricException("Failed to close connection: " + this.connector + " on " + this + ". " + e, e);
            }
            finally {
                this.connector = null;
            }
        }
    }

    protected synchronized JMXConnector getConnector() {
        if (this.connector == null) {
            this.connector = this.createConnector();
        }
        return this.connector;
    }

    protected JMXConnector createConnector() {
        throw new UnsupportedOperationException("No JMX connector has been configured!");
    }
}

