/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.fusesource.fabric.utils.HostUtils;
import org.fusesource.fabric.zookeeper.ZkDefs;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.linkedin.zookeeper.client.IZKClient;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KarafContainerRegistration
implements LifecycleListener,
NotificationListener {
    private transient Logger logger = LoggerFactory.getLogger(KarafContainerRegistration.class);
    private ConfigurationAdmin configurationAdmin;
    private IZKClient zooKeeper;
    private BundleContext bundleContext;
    private final Set<String> domains = new CopyOnWriteArraySet<String>();
    private String name = System.getProperty("karaf.name");
    private volatile MBeanServer mbeanServer;
    private ReentrantLock lock = new ReentrantLock();

    public IZKClient getZooKeeper() {
        return this.zooKeeper;
    }

    public void setZooKeeper(IZKClient zooKeeper) {
        this.zooKeeper = zooKeeper;
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConnected() {
        this.logger.trace("onConnected");
        try {
            String sshUrl;
            String jmxUrl;
            String domainsNode;
            this.lock.tryLock(10L, TimeUnit.SECONDS);
            String nodeAlive = ZkPath.CONTAINER_ALIVE.getPath(this.name);
            Stat stat = this.zooKeeper.exists(nodeAlive);
            if (stat != null) {
                if (stat.getEphemeralOwner() != this.zooKeeper.getSessionId()) {
                    this.zooKeeper.delete(nodeAlive);
                    this.zooKeeper.createWithParents(nodeAlive, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                }
            } else {
                this.zooKeeper.createWithParents(nodeAlive, null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            }
            if ((stat = this.zooKeeper.exists(domainsNode = ZkPath.CONTAINER_DOMAINS.getPath(this.name))) != null) {
                this.zooKeeper.deleteWithChildren(domainsNode);
            }
            if ((jmxUrl = this.getJmxUrl()) != null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_JMX.getPath(this.name), this.getJmxUrl(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if ((sshUrl = this.getSshUrl()) != null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_SSH.getPath(this.name), this.getSshUrl(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            if (this.zooKeeper.exists(ZkPath.CONTAINER_RESOLVER.getPath(this.name)) == null) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_RESOLVER.getPath(this.name), KarafContainerRegistration.getGlobalResolutionPolicy(this.zooKeeper), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(this.name), HostUtils.getLocalHostName(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_LOCAL_IP.getPath(this.name), HostUtils.getLocalIp(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_IP.getPath(this.name), KarafContainerRegistration.getContainerPointer(this.zooKeeper, this.name), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            for (String resolver : ZkDefs.VALID_RESOLVERS) {
                String address = System.getProperty(resolver);
                if (address == null || address.isEmpty() || this.zooKeeper.exists(ZkPath.CONTAINER_ADDRESS.getPath(this.name, resolver)) != null) continue;
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_ADDRESS.getPath(this.name, resolver), address, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            String version = System.getProperty("fabric.version", "1.0");
            String profiles = System.getProperty("fabric.profiles");
            if (profiles != null) {
                String versionNode = ZkPath.CONFIG_CONTAINER.getPath(this.name);
                String profileNode = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(version, this.name);
                if (this.zooKeeper.exists(versionNode) == null) {
                    this.zooKeeper.createOrSetWithParents(versionNode, version, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                if (this.zooKeeper.exists(profileNode) == null) {
                    this.zooKeeper.createOrSetWithParents(profileNode, profiles, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
            }
            this.registerDomains();
        }
        catch (Exception e) {
            this.logger.warn("Error updating Fabric Container information. This exception will be ignored.", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private String getJmxUrl() throws IOException {
        Configuration config = this.configurationAdmin.getConfiguration("org.apache.karaf.management");
        if (config.getProperties() != null) {
            String jmx = (String)config.getProperties().get("serviceUrl");
            jmx = jmx.replace("service:jmx:rmi://localhost:", "service:jmx:rmi://${zk:" + this.name + "/ip}:");
            jmx = jmx.replace("jndi/rmi://localhost", "jndi/rmi://${zk:" + this.name + "/ip}");
            return jmx;
        }
        return null;
    }

    private String getSshUrl() throws IOException {
        Configuration config = this.configurationAdmin.getConfiguration("org.apache.karaf.shell");
        if (config != null && config.getProperties() != null) {
            String port = (String)config.getProperties().get("sshPort");
            return "${zk:" + this.name + "/ip}:" + port;
        }
        return null;
    }

    private static String getGlobalResolutionPolicy(IZKClient zookeeper) throws InterruptedException, KeeperException {
        String policy = "localhostname";
        List<String> validResoverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (zookeeper.exists(ZkPath.POLICIES.getPath("resolver")) != null) {
            policy = zookeeper.getStringData(ZkPath.POLICIES.getPath("resolver"));
        } else if (System.getProperty("global.resolver") != null && validResoverList.contains(System.getProperty("global.resolver"))) {
            policy = System.getProperty("global.resolver");
            zookeeper.createOrSetWithParents(ZkPath.POLICIES.getPath("resolver"), policy, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        return policy;
    }

    private static String getContainerResolutionPolicy(IZKClient zookeeper, String container) throws InterruptedException, KeeperException {
        String policy = "localhostname";
        List<String> validResoverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (zookeeper.exists(ZkPath.POLICIES.getPath("resolver")) != null) {
            policy = zookeeper.getStringData(ZkPath.CONTAINER_RESOLVER.getPath(container));
        } else if (System.getProperty("local.resolver") != null && validResoverList.contains(System.getProperty("local.resolver"))) {
            policy = System.getProperty("local.resolver");
        }
        if (policy == null || !validResoverList.contains(policy)) {
            policy = KarafContainerRegistration.getGlobalResolutionPolicy(zookeeper);
        }
        if (policy != null && zookeeper.exists(ZkPath.CONTAINER_RESOLVER.getPath(container)) == null) {
            zookeeper.createOrSetWithParents(ZkPath.CONTAINER_RESOLVER.getPath(container), policy, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        }
        return policy;
    }

    private static String getContainerPointer(IZKClient zookeeper, String container) throws InterruptedException, KeeperException {
        String pointer = "${zk:%s/%s}";
        String policy = KarafContainerRegistration.getContainerResolutionPolicy(zookeeper, container);
        return String.format(pointer, container, policy);
    }

    private static String getExternalAddresses(String host, String port) throws UnknownHostException, SocketException {
        InetAddress ip = InetAddress.getByName(host);
        if (ip.isAnyLocalAddress()) {
            return HostUtils.getLocalHostName() + ":" + port;
        }
        if (!ip.isLoopbackAddress()) {
            return ip.getHostName() + ":" + port;
        }
        return null;
    }

    public void destroy() {
        this.logger.trace("destroy");
        try {
            this.unregisterDomains();
        }
        catch (ServiceException e) {
            this.logger.trace("ZooKeeper is no longer available", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.warn("An error occurred during disconnecting to zookeeper. This exception will be ignored.", (Throwable)e);
        }
    }

    public void onDisconnected() {
        this.logger.trace("onDisconnected");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMBeanServer(ServiceReference ref) {
        try {
            this.lock.lock();
            String name = System.getProperty("karaf.name");
            this.mbeanServer = (MBeanServer)this.bundleContext.getService(ref);
            if (this.mbeanServer != null) {
                this.mbeanServer.addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, (Object)name);
                this.registerDomains();
            }
        }
        catch (Exception e) {
            this.logger.warn("An error occurred during mbean server registration. This exception will be ignored.", (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBeanServer(ServiceReference ref) {
        if (this.mbeanServer != null) {
            try {
                this.lock.lock();
                this.mbeanServer.removeNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this);
                this.unregisterDomains();
            }
            catch (Exception e) {
                this.logger.warn("An error occurred during mbean server unregistration. This exception will be ignored.", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
        this.mbeanServer = null;
        this.bundleContext.ungetService(ref);
    }

    protected void registerDomains() throws InterruptedException, KeeperException {
        if (this.isConnected() && this.mbeanServer != null) {
            String name = System.getProperty("karaf.name");
            this.domains.addAll(Arrays.asList(this.mbeanServer.getDomains()));
            for (String domain : this.mbeanServer.getDomains()) {
                this.zooKeeper.createOrSetWithParents(ZkPath.CONTAINER_DOMAIN.getPath(name, domain), null, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
        }
    }

    protected void unregisterDomains() throws InterruptedException, KeeperException {
        if (this.isConnected()) {
            String name = System.getProperty("karaf.name");
            String domainsPath = ZkPath.CONTAINER_DOMAINS.getPath(name);
            if (this.zooKeeper.exists(domainsPath) != null) {
                for (String child : this.zooKeeper.getChildren(domainsPath)) {
                    this.zooKeeper.delete(domainsPath + "/" + child);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notif, Object o) {
        this.logger.trace("handleNotification[{}]", (Object)notif);
        if (this.isConnected() && this.mbeanServer != null && notif instanceof MBeanServerNotification) {
            MBeanServerNotification notification = (MBeanServerNotification)notif;
            String domain = notification.getMBeanName().getDomain();
            String path = ZkPath.CONTAINER_DOMAIN.getPath((String)o, domain);
            try {
                this.lock.lock();
                if ("JMX.mbean.registered".equals(notification.getType())) {
                    if (this.domains.add(domain) && this.zooKeeper.exists(path) == null) {
                        this.zooKeeper.createOrSetWithParents(path, "", (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    }
                } else if ("JMX.mbean.unregistered".equals(notification.getType())) {
                    this.domains.clear();
                    this.domains.addAll(Arrays.asList(this.mbeanServer.getDomains()));
                    if (!this.domains.contains(domain)) {
                        this.zooKeeper.delete(path);
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("Exception while jmx domain synchronization from event: " + notif + ". This exception will be ignored.", (Throwable)e);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean isConnected() {
        return this.zooKeeper != null && this.zooKeeper.isConnected();
    }
}

