/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.util;

import java.util.Arrays;
import java.util.List;
import org.fusesource.fabric.fab.util.CompositeFilter;
import org.fusesource.fabric.fab.util.Filter;

public class Filters {
    public static <T> Filter<T> trueFilter() {
        return new Filter<T>(){

            @Override
            public boolean matches(T t) {
                return true;
            }

            public String toString() {
                return "TrueFilter";
            }
        };
    }

    public static <T> Filter<T> falseFilter() {
        return new Filter<T>(){

            @Override
            public boolean matches(T t) {
                return false;
            }

            public String toString() {
                return "FalseFilter";
            }
        };
    }

    public static <T> Filter<T> compositeFilter(List<Filter<T>> filters) {
        if (filters.size() == 0) {
            return Filters.falseFilter();
        }
        if (filters.size() == 1) {
            return filters.get(0);
        }
        return new CompositeFilter<T>(filters);
    }

    public static <T> Filter<T> or(final Filter<T> ... filters) {
        return new Filter<T>(){

            @Override
            public boolean matches(T t) {
                for (Filter filter : filters) {
                    if (filter == null || !filter.matches(t)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "OrFilter" + Arrays.asList(filters);
            }
        };
    }

    public static <T> Filter<T> not(final Filter<T> filter) {
        return new Filter<T>(){

            @Override
            public boolean matches(T t) {
                return !filter.matches(t);
            }

            public String toString() {
                return "Not(" + filter + ")";
            }
        };
    }

    public static <T> boolean isEmpty(Filter<T> filter) {
        boolean empty = false;
        if (filter instanceof CompositeFilter) {
            CompositeFilter compositeFilter = (CompositeFilter)filter;
            empty = compositeFilter.isEmpty();
        }
        return empty;
    }
}

