/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.felix.framework.BundleWiringImpl;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.capabilityset.CapabilitySet;
import org.apache.felix.framework.resolver.Candidates;
import org.apache.felix.framework.resolver.HostBundleRevision;
import org.apache.felix.framework.resolver.HostedCapability;
import org.apache.felix.framework.resolver.HostedRequirement;
import org.apache.felix.framework.resolver.ResolveException;
import org.apache.felix.framework.resolver.Resolver;
import org.apache.felix.framework.resolver.ResolverWire;
import org.apache.felix.framework.resolver.ResolverWireImpl;
import org.apache.felix.framework.util.Util;
import org.apache.felix.framework.wiring.BundleCapabilityImpl;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverImpl
implements Resolver {
    private final Logger m_logger;
    private final List<Candidates> m_usesPermutations = new ArrayList<Candidates>();
    private final List<Candidates> m_importPermutations = new ArrayList<Candidates>();
    private Map<BundleCapability, List<BundleCapability>> m_packageSourcesCache = new HashMap<BundleCapability, List<BundleCapability>>();

    public ResolverImpl(Logger logger) {
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BundleRevision, List<ResolverWire>> resolve(Resolver.ResolverState state, Set<BundleRevision> mandatoryRevisions, Set<BundleRevision> optionalRevisions, Set<BundleRevision> ondemandFragments) {
        boolean retry;
        Map<BundleRevision, List<ResolverWire>> wireMap = new HashMap<BundleRevision, List<ResolverWire>>();
        HashMap<BundleRevision, Packages> revisionPkgMap = new HashMap<BundleRevision, Packages>();
        do {
            retry = false;
            try {
                List hostReq;
                BundleRevision target;
                Iterator i$;
                BundleRevision br4;
                boolean isFragment;
                Candidates allCandidates = new Candidates();
                Iterator<BundleRevision> it = mandatoryRevisions.iterator();
                while (it.hasNext()) {
                    BundleRevision br2 = it.next();
                    if (Util.isFragment(br2) || br2.getWiring() == null) {
                        allCandidates.populate(state, br2, 0);
                        continue;
                    }
                    it.remove();
                }
                for (BundleRevision br2 : optionalRevisions) {
                    isFragment = Util.isFragment(br2);
                    if (!isFragment && br2.getWiring() != null) continue;
                    allCandidates.populate(state, br2, 1);
                }
                for (BundleRevision br2 : ondemandFragments) {
                    isFragment = Util.isFragment(br2);
                    if (!isFragment) continue;
                    allCandidates.populate(state, br2, 2);
                }
                allCandidates.prepare();
                HashSet<BundleRevision> allRevisions = new HashSet<BundleRevision>(mandatoryRevisions);
                for (BundleRevision br3 : optionalRevisions) {
                    if (!allCandidates.isPopulated(br3)) continue;
                    allRevisions.add(br3);
                }
                this.m_usesPermutations.add(allCandidates);
                ResolveException rethrow = null;
                HashMap<BundleRevision, List<BundleRequirement>> hostReqs = new HashMap<BundleRevision, List<BundleRequirement>>();
                for (BundleRevision br4 : allRevisions) {
                    if (!Util.isFragment(br4)) continue;
                    hostReqs.put(br4, br4.getDeclaredRequirements("osgi.wiring.host"));
                }
                do {
                    rethrow = null;
                    revisionPkgMap.clear();
                    this.m_packageSourcesCache.clear();
                    allCandidates = this.m_usesPermutations.size() > 0 ? this.m_usesPermutations.remove(0) : this.m_importPermutations.remove(0);
                    i$ = allRevisions.iterator();
                    while (i$.hasNext()) {
                        target = br4 = (BundleRevision)i$.next();
                        hostReq = (List)hostReqs.get(br4);
                        if (hostReq != null) {
                            target = ((BundleCapability)allCandidates.getCandidates((BundleRequirement)hostReq.get(0)).iterator().next()).getRevision();
                        }
                        this.calculatePackageSpaces(allCandidates.getWrappedHost(target), allCandidates, revisionPkgMap, new HashMap<BundleCapability, List<BundleRevision>>(), new HashSet<BundleRevision>());
                        try {
                            this.checkPackageSpaceConsistency(false, allCandidates.getWrappedHost(target), allCandidates, revisionPkgMap, new HashMap<BundleRevision, Object>());
                        }
                        catch (ResolveException ex) {
                            rethrow = ex;
                        }
                    }
                } while (rethrow != null && (this.m_usesPermutations.size() > 0 || this.m_importPermutations.size() > 0));
                if (rethrow != null) {
                    BundleRevision faultyRevision = ResolverImpl.getActualBundleRevision(rethrow.getRevision());
                    if (rethrow.getRequirement() instanceof HostedRequirement) {
                        faultyRevision = ((HostedRequirement)rethrow.getRequirement()).getOriginalRequirement().getRevision();
                    }
                    if (optionalRevisions.remove(faultyRevision)) {
                        retry = true;
                        continue;
                    }
                    if (ondemandFragments.remove(faultyRevision)) {
                        retry = true;
                        continue;
                    }
                    throw rethrow;
                }
                i$ = allRevisions.iterator();
                while (i$.hasNext()) {
                    target = br4 = (BundleRevision)i$.next();
                    hostReq = (List)hostReqs.get(br4);
                    if (hostReq != null) {
                        target = ((BundleCapability)allCandidates.getCandidates((BundleRequirement)hostReq.get(0)).iterator().next()).getRevision();
                    }
                    if (!allCandidates.isPopulated(target)) continue;
                    wireMap = ResolverImpl.populateWireMap(allCandidates.getWrappedHost(target), revisionPkgMap, wireMap, allCandidates);
                }
            }
            finally {
                this.m_usesPermutations.clear();
                this.m_importPermutations.clear();
            }
        } while (retry);
        return wireMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<BundleRevision, List<ResolverWire>> resolve(Resolver.ResolverState state, BundleRevision revision, String pkgName, Set<BundleRevision> ondemandFragments) {
        Candidates allCandidates = ResolverImpl.getDynamicImportCandidates(state, revision, pkgName);
        if (allCandidates != null) {
            boolean retry;
            Map<BundleRevision, List<ResolverWire>> wireMap = new HashMap<BundleRevision, List<ResolverWire>>();
            HashMap<BundleRevision, Packages> revisionPkgMap = new HashMap<BundleRevision, Packages>();
            do {
                retry = false;
                try {
                    for (BundleRevision br : ondemandFragments) {
                        if (!Util.isFragment(br)) continue;
                        allCandidates.populate(state, br, 2);
                    }
                    allCandidates.prepare();
                    this.m_usesPermutations.add(allCandidates);
                    ResolveException rethrow = null;
                    do {
                        rethrow = null;
                        revisionPkgMap.clear();
                        this.m_packageSourcesCache.clear();
                        allCandidates = this.m_usesPermutations.size() > 0 ? this.m_usesPermutations.remove(0) : this.m_importPermutations.remove(0);
                        this.calculatePackageSpaces(allCandidates.getWrappedHost(revision), allCandidates, revisionPkgMap, new HashMap<BundleCapability, List<BundleRevision>>(), new HashSet<BundleRevision>());
                        try {
                            this.checkPackageSpaceConsistency(false, allCandidates.getWrappedHost(revision), allCandidates, revisionPkgMap, new HashMap<BundleRevision, Object>());
                        }
                        catch (ResolveException ex) {
                            rethrow = ex;
                        }
                    } while (rethrow != null && (this.m_usesPermutations.size() > 0 || this.m_importPermutations.size() > 0));
                    if (rethrow != null) {
                        BundleRevision faultyRevision = ResolverImpl.getActualBundleRevision(rethrow.getRevision());
                        if (rethrow.getRequirement() instanceof HostedRequirement) {
                            faultyRevision = ((HostedRequirement)rethrow.getRequirement()).getOriginalRequirement().getRevision();
                        }
                        if (ondemandFragments.remove(faultyRevision)) {
                            retry = true;
                            continue;
                        }
                        throw rethrow;
                    }
                    Map<BundleRevision, List<ResolverWire>> map = wireMap = ResolverImpl.populateDynamicWireMap(revision, pkgName, revisionPkgMap, wireMap, allCandidates);
                    return map;
                }
                finally {
                    this.m_usesPermutations.clear();
                    this.m_importPermutations.clear();
                }
            } while (retry);
        }
        return null;
    }

    private static Candidates getDynamicImportCandidates(Resolver.ResolverState state, BundleRevision revision, String pkgName) {
        if (revision.getWiring() == null || pkgName.length() == 0) {
            return null;
        }
        List<BundleRequirement> dynamics = Util.getDynamicRequirements(revision.getWiring().getRequirements(null));
        if (dynamics == null || dynamics.isEmpty()) {
            return null;
        }
        for (BundleCapability cap : revision.getWiring().getCapabilities(null)) {
            if (!cap.getNamespace().equals("osgi.wiring.package") || !cap.getAttributes().get("osgi.wiring.package").equals(pkgName)) continue;
            return null;
        }
        if (((BundleWiringImpl)revision.getWiring()).hasPackageSource(pkgName)) {
            return null;
        }
        Map<String, Object> attrs = Collections.singletonMap("osgi.wiring.package", pkgName);
        BundleRequirementImpl req = new BundleRequirementImpl(revision, "osgi.wiring.package", Collections.EMPTY_MAP, attrs);
        SortedSet<BundleCapability> candidates = state.getCandidates(req, false);
        BundleRequirementImpl dynReq = null;
        for (int dynIdx = 0; candidates.size() > 0 && dynReq == null && dynIdx < dynamics.size(); ++dynIdx) {
            Iterator itCand = candidates.iterator();
            while (dynReq == null && itCand.hasNext()) {
                BundleCapability cap = (BundleCapability)itCand.next();
                if (!CapabilitySet.matches((BundleCapabilityImpl)cap, ((BundleRequirementImpl)dynamics.get(dynIdx)).getFilter())) continue;
                dynReq = (BundleRequirementImpl)dynamics.get(dynIdx);
            }
        }
        if (dynReq != null) {
            Iterator itCand = candidates.iterator();
            while (itCand.hasNext()) {
                BundleCapability cap = (BundleCapability)itCand.next();
                if (CapabilitySet.matches((BundleCapabilityImpl)cap, dynReq.getFilter())) continue;
                itCand.remove();
            }
        } else {
            candidates.clear();
        }
        Candidates allCandidates = null;
        if (candidates.size() > 0) {
            allCandidates = new Candidates();
            allCandidates.populateDynamic(state, revision, dynReq, candidates);
        }
        return allCandidates;
    }

    private void calculatePackageSpaces(BundleRevision revision, Candidates allCandidates, Map<BundleRevision, Packages> revisionPkgMap, Map<BundleCapability, List<BundleRevision>> usesCycleMap, Set<BundleRevision> cycle) {
        BundleRequirement req;
        int i;
        BundleCapability cap;
        if (cycle.contains(revision)) {
            return;
        }
        cycle.add(revision);
        ArrayList<BundleRequirement> reqs = new ArrayList<BundleRequirement>();
        ArrayList<BundleCapability> caps = new ArrayList<BundleCapability>();
        boolean isDynamicImporting = false;
        if (revision.getWiring() != null) {
            for (BundleWire wire : revision.getWiring().getRequiredWires(null)) {
                BundleCapability c;
                BundleRequirement r = wire.getRequirement();
                if (!r.getRevision().equals(wire.getRequirerWiring().getRevision()) || r.getDirectives().get("resolution") != null && r.getDirectives().get("resolution").equals("dynamic")) {
                    r = new HostedRequirement(wire.getRequirerWiring().getRevision(), (BundleRequirementImpl)r);
                }
                if (!(c = wire.getCapability()).getRevision().equals(wire.getProviderWiring().getRevision())) {
                    c = new HostedCapability(wire.getProviderWiring().getRevision(), (BundleCapabilityImpl)c);
                }
                reqs.add(r);
                caps.add(c);
            }
            for (BundleRequirement req2 : Util.getDynamicRequirements(revision.getWiring().getRequirements(null))) {
                SortedSet<BundleCapability> candCaps = allCandidates.getCandidates((BundleRequirementImpl)req2);
                if (candCaps == null) continue;
                cap = (BundleCapability)candCaps.iterator().next();
                reqs.add(req2);
                caps.add(cap);
                isDynamicImporting = true;
                break;
            }
        } else {
            for (BundleRequirement req2 : revision.getDeclaredRequirements(null)) {
                SortedSet<BundleCapability> candCaps;
                String resolution = req2.getDirectives().get("resolution");
                if (resolution != null && resolution.equals("dynamic") || (candCaps = allCandidates.getCandidates((BundleRequirementImpl)req2)) == null) continue;
                BundleCapability cap2 = (BundleCapability)candCaps.iterator().next();
                reqs.add(req2);
                caps.add(cap2);
            }
        }
        ResolverImpl.calculateExportedPackages(revision, allCandidates, revisionPkgMap);
        Packages revisionPkgs = revisionPkgMap.get(revision);
        for (i = 0; i < reqs.size(); ++i) {
            req = (BundleRequirement)reqs.get(i);
            cap = (BundleCapability)caps.get(i);
            ResolverImpl.calculateExportedPackages(cap.getRevision(), allCandidates, revisionPkgMap);
            this.mergeCandidatePackages(revision, req, cap, revisionPkgMap, allCandidates, new HashMap<BundleRevision, List<BundleCapability>>());
        }
        for (i = 0; i < caps.size(); ++i) {
            this.calculatePackageSpaces(((BundleCapability)caps.get(i)).getRevision(), allCandidates, revisionPkgMap, usesCycleMap, cycle);
        }
        if (revision.getWiring() == null || isDynamicImporting) {
            ArrayList<BundleRequirement> blameReqs;
            for (i = 0; i < reqs.size(); ++i) {
                req = (BundleRequirement)reqs.get(i);
                cap = (BundleCapability)caps.get(i);
                if (req.getNamespace().equals("osgi.wiring.bundle") || req.getNamespace().equals("osgi.wiring.package")) continue;
                ArrayList<BundleRequirement> blameReqs2 = new ArrayList<BundleRequirement>();
                blameReqs2.add(req);
                this.mergeUses(revision, revisionPkgs, cap, blameReqs2, revisionPkgMap, allCandidates, usesCycleMap);
            }
            for (Map.Entry<String, List<Blame>> entry : revisionPkgs.m_importedPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    if (blame.m_cap.getRevision().equals(revision)) continue;
                    blameReqs = new ArrayList<BundleRequirement>();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(revision, revisionPkgs, blame.m_cap, blameReqs, revisionPkgMap, allCandidates, usesCycleMap);
                }
            }
            for (Map.Entry<String, List<Blame>> entry : revisionPkgs.m_requiredPkgs.entrySet()) {
                for (Blame blame : entry.getValue()) {
                    blameReqs = new ArrayList();
                    blameReqs.add(blame.m_reqs.get(0));
                    this.mergeUses(revision, revisionPkgs, blame.m_cap, blameReqs, revisionPkgMap, allCandidates, usesCycleMap);
                }
            }
        }
    }

    private void mergeCandidatePackages(BundleRevision current, BundleRequirement currentReq, BundleCapability candCap, Map<BundleRevision, Packages> revisionPkgMap, Candidates allCandidates, Map<BundleRevision, List<BundleCapability>> cycles) {
        List<BundleCapability> cycleCaps = cycles.get(current);
        if (cycleCaps == null) {
            cycleCaps = new ArrayList<BundleCapability>();
            cycles.put(current, cycleCaps);
        }
        if (cycleCaps.contains(candCap)) {
            return;
        }
        cycleCaps.add(candCap);
        if (candCap.getNamespace().equals("osgi.wiring.package")) {
            this.mergeCandidatePackage(current, false, currentReq, candCap, revisionPkgMap);
        } else if (candCap.getNamespace().equals("osgi.wiring.bundle")) {
            ResolverImpl.calculateExportedPackages(candCap.getRevision(), allCandidates, revisionPkgMap);
            Packages candPkgs = revisionPkgMap.get(candCap.getRevision());
            for (Map.Entry<String, Blame> entry : candPkgs.m_exportedPkgs.entrySet()) {
                this.mergeCandidatePackage(current, true, currentReq, entry.getValue().m_cap, revisionPkgMap);
            }
            if (candCap.getRevision().getWiring() != null) {
                for (BundleWire bw : candCap.getRevision().getWiring().getRequiredWires(null)) {
                    String value;
                    if (!bw.getRequirement().getNamespace().equals("osgi.wiring.bundle") || (value = bw.getRequirement().getDirectives().get("visibility")) == null || !value.equals("reexport")) continue;
                    this.mergeCandidatePackages(current, currentReq, bw.getCapability(), revisionPkgMap, allCandidates, cycles);
                }
            } else {
                for (BundleRequirement req : candCap.getRevision().getDeclaredRequirements(null)) {
                    String value;
                    if (!req.getNamespace().equals("osgi.wiring.bundle") || (value = req.getDirectives().get("visibility")) == null || !value.equals("reexport") || allCandidates.getCandidates(req) == null) continue;
                    this.mergeCandidatePackages(current, currentReq, (BundleCapability)allCandidates.getCandidates(req).iterator().next(), revisionPkgMap, allCandidates, cycles);
                }
            }
        }
        cycles.remove(current);
    }

    private void mergeCandidatePackage(BundleRevision current, boolean requires, BundleRequirement currentReq, BundleCapability candCap, Map<BundleRevision, Packages> revisionPkgMap) {
        if (candCap.getNamespace().equals("osgi.wiring.package")) {
            String pkgName = (String)candCap.getAttributes().get("osgi.wiring.package");
            ArrayList<BundleRequirement> blameReqs = new ArrayList<BundleRequirement>();
            blameReqs.add(currentReq);
            Packages currentPkgs = revisionPkgMap.get(current);
            Map<String, List<Blame>> packages = requires ? currentPkgs.m_requiredPkgs : currentPkgs.m_importedPkgs;
            List<Blame> blames = packages.get(pkgName);
            if (blames == null) {
                blames = new ArrayList<Blame>();
                packages.put(pkgName, blames);
            }
            blames.add(new Blame(candCap, blameReqs));
        }
    }

    private void mergeUses(BundleRevision current, Packages currentPkgs, BundleCapability mergeCap, List<BundleRequirement> blameReqs, Map<BundleRevision, Packages> revisionPkgMap, Candidates allCandidates, Map<BundleCapability, List<BundleRevision>> cycleMap) {
        if (current.equals(mergeCap.getRevision())) {
            return;
        }
        ArrayList<BundleRevision> list = cycleMap.get(mergeCap);
        if (list != null && list.contains(current)) {
            return;
        }
        list = list == null ? new ArrayList<BundleRevision>() : list;
        list.add(current);
        cycleMap.put(mergeCap, list);
        for (BundleCapability candSourceCap : this.getPackageSources(mergeCap, revisionPkgMap)) {
            for (String usedPkgName : ((BundleCapabilityImpl)candSourceCap).getUses()) {
                Packages candSourcePkgs = revisionPkgMap.get(candSourceCap.getRevision());
                List<Object> candSourceBlames = null;
                Blame candExportedBlame = candSourcePkgs.m_exportedPkgs.get(usedPkgName);
                if (candExportedBlame != null) {
                    candSourceBlames = new ArrayList<Blame>(1);
                    candSourceBlames.add(candExportedBlame);
                } else {
                    candSourceBlames = candSourcePkgs.m_requiredPkgs.get(usedPkgName);
                    List<Object> list2 = candSourceBlames = candSourceBlames != null ? candSourceBlames : candSourcePkgs.m_importedPkgs.get(usedPkgName);
                }
                if (candSourceBlames == null) continue;
                List<Blame> usedCaps = currentPkgs.m_usedPkgs.get(usedPkgName);
                if (usedCaps == null) {
                    usedCaps = new ArrayList<Blame>();
                    currentPkgs.m_usedPkgs.put(usedPkgName, usedCaps);
                }
                for (Blame blame : candSourceBlames) {
                    if (blame.m_reqs != null) {
                        ArrayList<BundleRequirement> blameReqs2 = new ArrayList<BundleRequirement>(blameReqs);
                        blameReqs2.add(blame.m_reqs.get(blame.m_reqs.size() - 1));
                        usedCaps.add(new Blame(blame.m_cap, blameReqs2));
                        this.mergeUses(current, currentPkgs, blame.m_cap, blameReqs2, revisionPkgMap, allCandidates, cycleMap);
                        continue;
                    }
                    usedCaps.add(new Blame(blame.m_cap, blameReqs));
                    this.mergeUses(current, currentPkgs, blame.m_cap, blameReqs, revisionPkgMap, allCandidates, cycleMap);
                }
            }
        }
    }

    private void checkPackageSpaceConsistency(boolean isDynamicImporting, BundleRevision revision, Candidates allCandidates, Map<BundleRevision, Packages> revisionPkgMap, Map<BundleRevision, Object> resultCache) {
        if (revision.getWiring() != null && !isDynamicImporting) {
            return;
        }
        if (resultCache.containsKey(revision)) {
            return;
        }
        Packages pkgs = revisionPkgMap.get(revision);
        ResolveException rethrow = null;
        Candidates permutation = null;
        Set mutated = null;
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            Blame sourceBlame = null;
            for (Blame blame : entry.getValue()) {
                if (sourceBlame == null) {
                    sourceBlame = blame;
                    continue;
                }
                if (sourceBlame.m_cap.getRevision().equals(blame.m_cap.getRevision())) continue;
                ResolverImpl.permutate(allCandidates, blame.m_reqs.get(0), this.m_importPermutations);
                ResolverImpl.permutate(allCandidates, sourceBlame.m_reqs.get(0), this.m_importPermutations);
                ResolveException ex = new ResolveException("Uses constraint violation. Unable to resolve bundle revision " + revision.getSymbolicName() + " [" + revision + "] because it is exposed to package '" + entry.getKey() + "' from bundle revisions " + sourceBlame.m_cap.getRevision().getSymbolicName() + " [" + sourceBlame.m_cap.getRevision() + "] and " + blame.m_cap.getRevision().getSymbolicName() + " [" + blame.m_cap.getRevision() + "] via two dependency chains.\n\nChain 1:\n" + ResolverImpl.toStringBlame(sourceBlame) + "\n\nChain 2:\n" + ResolverImpl.toStringBlame(blame), revision, blame.m_reqs.get(0));
                this.m_logger.log(4, "Candidate permutation failed due to a conflict with a fragment import; will try another if possible.", ex);
                throw ex;
            }
        }
        for (Map.Entry<String, Object> entry : pkgs.m_exportedPkgs.entrySet()) {
            String pkgName = entry.getKey();
            Blame exportBlame = (Blame)entry.getValue();
            if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
            block5: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                BundleRequirement req;
                if (this.isCompatible(exportBlame.m_cap, usedBlame.m_cap, revisionPkgMap)) continue;
                permutation = permutation != null ? permutation : allCandidates.copy();
                rethrow = rethrow != null ? rethrow : new ResolveException("Uses constraint violation. Unable to resolve bundle revision " + revision.getSymbolicName() + " [" + revision + "] because it exports package '" + pkgName + "' and is also exposed to it from bundle revision " + usedBlame.m_cap.getRevision().getSymbolicName() + " [" + usedBlame.m_cap.getRevision() + "] via the following dependency chain:\n\n" + ResolverImpl.toStringBlame(usedBlame), null, null);
                mutated = mutated != null ? mutated : new HashSet();
                for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                    SortedSet<BundleCapability> candidates = permutation.getCandidates(req);
                    if (candidates == null || candidates.size() <= 1) continue;
                    mutated.add(req);
                    Iterator it = candidates.iterator();
                    it.next();
                    it.remove();
                    continue block5;
                }
            }
            if (rethrow == null) continue;
            if (mutated.size() > 0) {
                this.m_usesPermutations.add(permutation);
            }
            this.m_logger.log(4, "Candidate permutation failed due to a conflict between an export and import; will try another if possible.", rethrow);
            throw rethrow;
        }
        for (Map.Entry<String, Object> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame importBlame : (List)entry.getValue()) {
                BundleRequirement req;
                String pkgName = entry.getKey();
                if (!pkgs.m_usedPkgs.containsKey(pkgName)) continue;
                block9: for (Blame usedBlame : pkgs.m_usedPkgs.get(pkgName)) {
                    BundleRequirement req2;
                    if (this.isCompatible(importBlame.m_cap, usedBlame.m_cap, revisionPkgMap)) continue;
                    permutation = permutation != null ? permutation : allCandidates.copy();
                    rethrow = rethrow != null ? rethrow : new ResolveException("Uses constraint violation. Unable to resolve bundle revision " + revision.getSymbolicName() + " [" + revision + "] because it is exposed to package '" + pkgName + "' from bundle revisions " + importBlame.m_cap.getRevision().getSymbolicName() + " [" + importBlame.m_cap.getRevision() + "] and " + usedBlame.m_cap.getRevision().getSymbolicName() + " [" + usedBlame.m_cap.getRevision() + "] via two dependency chains.\n\nChain 1:\n" + ResolverImpl.toStringBlame(importBlame) + "\n\nChain 2:\n" + ResolverImpl.toStringBlame(usedBlame), null, null);
                    mutated = mutated != null ? mutated : new HashSet();
                    for (int reqIdx = usedBlame.m_reqs.size() - 1; reqIdx >= 0 && !mutated.contains(req2 = usedBlame.m_reqs.get(reqIdx)); --reqIdx) {
                        SortedSet<BundleCapability> candidates = permutation.getCandidates(req2);
                        if (candidates == null || candidates.size() <= 1) continue;
                        mutated.add(req2);
                        Iterator it = candidates.iterator();
                        it.next();
                        it.remove();
                        continue block9;
                    }
                }
                if (rethrow == null) continue;
                if (mutated.size() > 0) {
                    this.m_usesPermutations.add(permutation);
                }
                if (!mutated.contains(req = importBlame.m_reqs.get(0))) {
                    ResolverImpl.permutateIfNeeded(allCandidates, req, this.m_importPermutations);
                }
                this.m_logger.log(4, "Candidate permutation failed due to a conflict between imports; will try another if possible.", rethrow);
                throw rethrow;
            }
        }
        resultCache.put(revision, Boolean.TRUE);
        int permCount = this.m_usesPermutations.size() + this.m_importPermutations.size();
        for (Map.Entry<String, List<Blame>> entry : pkgs.m_importedPkgs.entrySet()) {
            for (Blame importBlame : entry.getValue()) {
                if (revision.equals(importBlame.m_cap.getRevision())) continue;
                try {
                    this.checkPackageSpaceConsistency(false, importBlame.m_cap.getRevision(), allCandidates, revisionPkgMap, resultCache);
                }
                catch (ResolveException ex) {
                    if (permCount == this.m_usesPermutations.size() + this.m_importPermutations.size()) {
                        BundleRequirement req = importBlame.m_reqs.get(0);
                        ResolverImpl.permutate(allCandidates, req, this.m_importPermutations);
                    }
                    throw ex;
                }
            }
        }
    }

    private static void permutate(Candidates allCandidates, BundleRequirement req, List<Candidates> permutations) {
        SortedSet<BundleCapability> candidates = allCandidates.getCandidates(req);
        if (candidates.size() > 1) {
            Candidates perm = allCandidates.copy();
            candidates = perm.getCandidates(req);
            Iterator it = candidates.iterator();
            it.next();
            it.remove();
            permutations.add(perm);
        }
    }

    private static void permutateIfNeeded(Candidates allCandidates, BundleRequirement req, List<Candidates> permutations) {
        SortedSet<BundleCapability> candidates = allCandidates.getCandidates(req);
        if (candidates.size() > 1) {
            boolean permutated = false;
            for (Candidates existingPerm : permutations) {
                SortedSet<BundleCapability> existingPermCands = existingPerm.getCandidates(req);
                if (((BundleCapability)existingPermCands.iterator().next()).equals(candidates.iterator().next())) continue;
                permutated = true;
            }
            if (!permutated) {
                ResolverImpl.permutate(allCandidates, req, permutations);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void calculateExportedPackages(BundleRevision revision, Candidates allCandidates, Map<BundleRevision, Packages> revisionPkgMap) {
        Packages packages = revisionPkgMap.get(revision);
        if (packages != null) {
            return;
        }
        packages = new Packages(revision);
        List<BundleCapability> caps = revision.getWiring() != null ? revision.getWiring().getCapabilities(null) : revision.getDeclaredCapabilities(null);
        HashMap<String, void> exports = new HashMap<String, void>(caps.size());
        for (BundleCapability bundleCapability : caps) {
            void var7_7;
            if (!bundleCapability.getNamespace().equals("osgi.wiring.package")) continue;
            if (!bundleCapability.getRevision().equals(revision)) {
                HostedCapability hostedCapability = new HostedCapability(revision, (BundleCapabilityImpl)bundleCapability);
            }
            exports.put((String)var7_7.getAttributes().get("osgi.wiring.package"), var7_7);
        }
        if (!exports.isEmpty()) {
            if (revision.getWiring() == null) {
                for (BundleRequirement bundleRequirement : revision.getDeclaredRequirements(null)) {
                    SortedSet<BundleCapability> cands;
                    if (!bundleRequirement.getNamespace().equals("osgi.wiring.package") || (cands = allCandidates.getCandidates((BundleRequirementImpl)bundleRequirement)) == null || cands.isEmpty()) continue;
                    String pkgName = (String)((BundleCapability)cands.iterator().next()).getAttributes().get("osgi.wiring.package");
                    exports.remove(pkgName);
                }
            }
            for (Map.Entry entry : exports.entrySet()) {
                packages.m_exportedPkgs.put((String)entry.getKey(), new Blame((BundleCapability)entry.getValue(), null));
            }
        }
        revisionPkgMap.put(revision, packages);
    }

    private boolean isCompatible(BundleCapability currentCap, BundleCapability candCap, Map<BundleRevision, Packages> revisionPkgMap) {
        if (currentCap != null && candCap != null) {
            List<BundleCapability> candSources;
            if (currentCap.equals(candCap)) {
                return true;
            }
            List<BundleCapability> currentSources = this.getPackageSources(currentCap, revisionPkgMap);
            return currentSources.containsAll(candSources = this.getPackageSources(candCap, revisionPkgMap)) || candSources.containsAll(currentSources);
        }
        return true;
    }

    private List<BundleCapability> getPackageSources(BundleCapability cap, Map<BundleRevision, Packages> revisionPkgMap) {
        if (cap.getNamespace().equals("osgi.wiring.package")) {
            List<BundleCapability> sources = this.m_packageSourcesCache.get(cap);
            if (sources == null) {
                sources = ResolverImpl.getPackageSourcesInternal(cap, revisionPkgMap, new ArrayList<BundleCapability>(), new HashSet<BundleCapability>());
                this.m_packageSourcesCache.put(cap, sources);
            }
            return sources;
        }
        if (!((BundleCapabilityImpl)cap).getUses().isEmpty()) {
            ArrayList<BundleCapability> caps = new ArrayList<BundleCapability>(1);
            caps.add(cap);
            return caps;
        }
        return Collections.EMPTY_LIST;
    }

    private static List<BundleCapability> getPackageSourcesInternal(BundleCapability cap, Map<BundleRevision, Packages> revisionPkgMap, List<BundleCapability> sources, Set<BundleCapability> cycleMap) {
        if (cap.getNamespace().equals("osgi.wiring.package")) {
            if (cycleMap.contains(cap)) {
                return sources;
            }
            cycleMap.add(cap);
            String pkgName = cap.getAttributes().get("osgi.wiring.package").toString();
            List<BundleCapability> caps = cap.getRevision().getWiring() != null ? cap.getRevision().getWiring().getCapabilities(null) : cap.getRevision().getDeclaredCapabilities(null);
            for (BundleCapability sourceCap : caps) {
                if (!sourceCap.getNamespace().equals("osgi.wiring.package") || !sourceCap.getAttributes().get("osgi.wiring.package").equals(pkgName)) continue;
                if (!cap.getRevision().equals(sourceCap.getRevision())) {
                    sources.add(new HostedCapability(cap.getRevision(), (BundleCapabilityImpl)sourceCap));
                    continue;
                }
                sources.add(sourceCap);
            }
            Packages pkgs = revisionPkgMap.get(cap.getRevision());
            List<Blame> required = pkgs.m_requiredPkgs.get(pkgName);
            if (required != null) {
                for (Blame blame : required) {
                    ResolverImpl.getPackageSourcesInternal(blame.m_cap, revisionPkgMap, sources, cycleMap);
                }
            }
        }
        return sources;
    }

    private static BundleRevision getActualBundleRevision(BundleRevision br) {
        if (br instanceof HostBundleRevision) {
            return ((HostBundleRevision)br).getHost();
        }
        return br;
    }

    private static BundleCapability getActualCapability(BundleCapability c) {
        if (c instanceof HostedCapability) {
            return ((HostedCapability)c).getOriginalCapability();
        }
        return c;
    }

    private static BundleRequirement getActualRequirement(BundleRequirement r) {
        if (r instanceof HostedRequirement) {
            return ((HostedRequirement)r).getOriginalRequirement();
        }
        return r;
    }

    private static Map<BundleRevision, List<ResolverWire>> populateWireMap(BundleRevision revision, Map<BundleRevision, Packages> revisionPkgMap, Map<BundleRevision, List<ResolverWire>> wireMap, Candidates allCandidates) {
        BundleRevision unwrappedRevision = ResolverImpl.getActualBundleRevision(revision);
        if (unwrappedRevision.getWiring() == null && !wireMap.containsKey(unwrappedRevision)) {
            wireMap.put(unwrappedRevision, Collections.EMPTY_LIST);
            ArrayList<ResolverWireImpl> packageWires = new ArrayList<ResolverWireImpl>();
            ArrayList<ResolverWireImpl> bundleWires = new ArrayList<ResolverWireImpl>();
            ArrayList<ResolverWireImpl> capabilityWires = new ArrayList<ResolverWireImpl>();
            for (BundleRequirement req : revision.getDeclaredRequirements(null)) {
                BundleCapability cand;
                SortedSet<BundleCapability> cands = allCandidates.getCandidates(req);
                if (cands == null || cands.size() <= 0 || revision.equals((cand = (BundleCapability)cands.iterator().next()).getRevision())) continue;
                if (cand.getRevision().getWiring() == null) {
                    ResolverImpl.populateWireMap(cand.getRevision(), revisionPkgMap, wireMap, allCandidates);
                }
                Packages candPkgs = revisionPkgMap.get(cand.getRevision());
                ResolverWireImpl wire = new ResolverWireImpl(unwrappedRevision, ResolverImpl.getActualRequirement(req), ResolverImpl.getActualBundleRevision(cand.getRevision()), ResolverImpl.getActualCapability(cand));
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    packageWires.add(wire);
                    continue;
                }
                if (req.getNamespace().equals("osgi.wiring.bundle")) {
                    bundleWires.add(wire);
                    continue;
                }
                capabilityWires.add(wire);
            }
            packageWires.addAll(bundleWires);
            packageWires.addAll(capabilityWires);
            wireMap.put(unwrappedRevision, packageWires);
            if (revision instanceof HostBundleRevision) {
                List<BundleRevision> fragments = ((HostBundleRevision)revision).getFragments();
                for (BundleRevision fragment : fragments) {
                    List<ResolverWire> hostWires = wireMap.get(fragment);
                    if (hostWires == null) {
                        hostWires = new ArrayList<ResolverWire>();
                        wireMap.put(fragment, hostWires);
                    }
                    hostWires.add(new ResolverWireImpl(ResolverImpl.getActualBundleRevision(fragment), fragment.getDeclaredRequirements("osgi.wiring.host").get(0), unwrappedRevision, unwrappedRevision.getDeclaredCapabilities("osgi.wiring.host").get(0)));
                }
            }
        }
        return wireMap;
    }

    private static Map<BundleRevision, List<ResolverWire>> populateDynamicWireMap(BundleRevision revision, String pkgName, Map<BundleRevision, Packages> revisionPkgMap, Map<BundleRevision, List<ResolverWire>> wireMap, Candidates allCandidates) {
        wireMap.put(revision, Collections.EMPTY_LIST);
        ArrayList<ResolverWireImpl> packageWires = new ArrayList<ResolverWireImpl>();
        BundleRequirement dynReq = null;
        BundleCapability dynCand = null;
        for (BundleRequirement req : Util.getDynamicRequirements(revision.getWiring().getRequirements(null))) {
            SortedSet<BundleCapability> candCaps = allCandidates.getCandidates((BundleRequirementImpl)req);
            if (candCaps == null || candCaps.isEmpty()) continue;
            dynReq = req;
            dynCand = candCaps.first();
            break;
        }
        if (dynReq != null) {
            if (dynCand.getRevision().getWiring() == null) {
                ResolverImpl.populateWireMap(dynCand.getRevision(), revisionPkgMap, wireMap, allCandidates);
            }
            HashMap<String, String> attrs = new HashMap<String, String>(1);
            attrs.put("osgi.wiring.package", pkgName);
            packageWires.add(new ResolverWireImpl(revision, dynReq, ResolverImpl.getActualBundleRevision(dynCand.getRevision()), ResolverImpl.getActualCapability(dynCand)));
        }
        wireMap.put(revision, packageWires);
        return wireMap;
    }

    private static void dumpRevisionPkgMap(Map<BundleRevision, Packages> revisionPkgMap) {
        System.out.println("+++BUNDLE REVISION PKG MAP+++");
        for (Map.Entry<BundleRevision, Packages> entry : revisionPkgMap.entrySet()) {
            ResolverImpl.dumpRevisionPkgs(entry.getKey(), entry.getValue());
        }
    }

    private static void dumpRevisionPkgs(BundleRevision revision, Packages packages) {
        System.out.println(revision + " (" + (revision.getWiring() != null ? "RESOLVED)" : "UNRESOLVED)"));
        System.out.println("  EXPORTED");
        for (Map.Entry<String, Blame> entry : packages.m_exportedPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  IMPORTED");
        for (Map.Entry<String, Object> entry : packages.m_importedPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  REQUIRED");
        for (Map.Entry<String, Object> entry : packages.m_requiredPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
        System.out.println("  USED");
        for (Map.Entry<String, Object> entry : packages.m_usedPkgs.entrySet()) {
            System.out.println("    " + entry.getKey() + " - " + entry.getValue());
        }
    }

    private static String toStringBlame(Blame blame) {
        StringBuffer sb = new StringBuffer();
        if (blame.m_reqs != null && !blame.m_reqs.isEmpty()) {
            for (int i = 0; i < blame.m_reqs.size(); ++i) {
                BundleRequirement req = blame.m_reqs.get(i);
                sb.append("  ");
                sb.append(req.getRevision().getSymbolicName());
                sb.append(" [");
                sb.append(req.getRevision().toString());
                sb.append("]\n");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("    import: ");
                } else {
                    sb.append("    require: ");
                }
                sb.append(((BundleRequirementImpl)req).getFilter().toString());
                sb.append("\n     |");
                if (req.getNamespace().equals("osgi.wiring.package")) {
                    sb.append("\n    export: ");
                } else {
                    sb.append("\n    provide: ");
                }
                if (i + 1 < blame.m_reqs.size()) {
                    BundleCapability cap = Util.getSatisfyingCapability(blame.m_reqs.get(i + 1).getRevision(), (BundleRequirementImpl)blame.m_reqs.get(i));
                    if (cap.getNamespace().equals("osgi.wiring.package")) {
                        sb.append("osgi.wiring.package");
                        sb.append("=");
                        sb.append(cap.getAttributes().get("osgi.wiring.package").toString());
                        BundleCapability usedCap = i + 2 < blame.m_reqs.size() ? Util.getSatisfyingCapability(blame.m_reqs.get(i + 2).getRevision(), (BundleRequirementImpl)blame.m_reqs.get(i + 1)) : Util.getSatisfyingCapability(blame.m_cap.getRevision(), (BundleRequirementImpl)blame.m_reqs.get(i + 1));
                        sb.append("; uses:=");
                        sb.append(usedCap.getAttributes().get("osgi.wiring.package"));
                    } else {
                        sb.append(cap);
                    }
                    sb.append("\n");
                    continue;
                }
                BundleCapability export = Util.getSatisfyingCapability(blame.m_cap.getRevision(), (BundleRequirementImpl)blame.m_reqs.get(i));
                sb.append(export.getNamespace());
                sb.append("=");
                sb.append(export.getAttributes().get(export.getNamespace()).toString());
                if (export.getNamespace().equals("osgi.wiring.package") && !export.getAttributes().get("osgi.wiring.package").equals(blame.m_cap.getAttributes().get("osgi.wiring.package"))) {
                    sb.append("; uses:=");
                    sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package"));
                    sb.append("\n    export: ");
                    sb.append("osgi.wiring.package");
                    sb.append("=");
                    sb.append(blame.m_cap.getAttributes().get("osgi.wiring.package").toString());
                }
                sb.append("\n  ");
                sb.append(blame.m_cap.getRevision().getSymbolicName());
                sb.append(" [");
                sb.append(blame.m_cap.getRevision().toString());
                sb.append("]");
            }
        } else {
            sb.append(blame.m_cap.getRevision().toString());
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Blame {
        public final BundleCapability m_cap;
        public final List<BundleRequirement> m_reqs;

        public Blame(BundleCapability cap, List<BundleRequirement> reqs) {
            this.m_cap = cap;
            this.m_reqs = reqs;
        }

        public String toString() {
            return this.m_cap.getRevision() + "." + this.m_cap.getAttributes().get("osgi.wiring.package") + (this.m_reqs == null || this.m_reqs.isEmpty() ? " NO BLAME" : " BLAMED ON " + this.m_reqs);
        }

        public boolean equals(Object o) {
            return o instanceof Blame && ((Object)this.m_reqs).equals(((Blame)o).m_reqs) && this.m_cap.equals(((Blame)o).m_cap);
        }
    }

    private static class Packages {
        private final BundleRevision m_revision;
        public final Map<String, Blame> m_exportedPkgs = new HashMap<String, Blame>();
        public final Map<String, List<Blame>> m_importedPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_requiredPkgs = new HashMap<String, List<Blame>>();
        public final Map<String, List<Blame>> m_usedPkgs = new HashMap<String, List<Blame>>();

        public Packages(BundleRevision revision) {
            this.m_revision = revision;
        }
    }
}

