/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.hawtdispatch.internal;

import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import org.fusesource.hawtdispatch.DispatchPriority;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.Metrics;
import org.fusesource.hawtdispatch.ShutdownException;
import org.fusesource.hawtdispatch.internal.ActiveMetricsCollector;
import org.fusesource.hawtdispatch.internal.HawtDispatchQueue;
import org.fusesource.hawtdispatch.internal.HawtDispatcher;
import org.fusesource.hawtdispatch.internal.InactiveMetricsCollector;
import org.fusesource.hawtdispatch.internal.MetricsCollector;
import org.fusesource.hawtdispatch.internal.SerialDispatchQueue;
import org.fusesource.hawtdispatch.internal.ThreadDispatchQueue;
import org.fusesource.hawtdispatch.internal.WorkerPool;
import org.fusesource.hawtdispatch.internal.WorkerThread;
import org.fusesource.hawtdispatch.internal.pool.SimplePool;
import org.fusesource.hawtdispatch.internal.util.IntrospectionSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlobalDispatchQueue
implements HawtDispatchQueue {
    public final HawtDispatcher dispatcher;
    volatile String label;
    private final DispatchPriority priority;
    final WorkerPool workers;
    private MetricsCollector metricsCollector = InactiveMetricsCollector.INSTANCE;

    public GlobalDispatchQueue(HawtDispatcher dispatcher, DispatchPriority priority, int threads) {
        this.dispatcher = dispatcher;
        this.priority = priority;
        this.label = priority.toString();
        this.workers = new SimplePool(this, threads, priority);
        dispatcher.track(this);
    }

    public void start() {
        this.workers.start();
    }

    public void shutdown() {
        this.workers.shutdown();
    }

    @Override
    public HawtDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public boolean isExecuting() {
        ThreadDispatchQueue tq = this.dispatcher.getCurrentThreadQueue();
        if (tq != null) {
            return tq.globalQueue == this;
        }
        return false;
    }

    @Override
    public LinkedList<Runnable> getSourceQueue() {
        ThreadDispatchQueue tq = this.dispatcher.getCurrentThreadQueue();
        if (tq != null) {
            return tq.getSourceQueue();
        }
        return null;
    }

    @Override
    public void assertExecuting() {
        assert (this.isExecuting()) : this.getDispatcher().assertMessage();
    }

    @Override
    public void execute(Runnable runnable) {
        if (this.dispatcher.shutdownState.get() > 1) {
            throw new ShutdownException();
        }
        this.workers.execute(this.metricsCollector.track(runnable));
    }

    @Override
    public void executeAfter(long delay, TimeUnit unit, Runnable runnable) {
        if (this.dispatcher.shutdownState.get() > 0) {
            throw new ShutdownException();
        }
        this.dispatcher.timerThread.addRelative(runnable, this, delay, unit);
    }

    @Override
    public ThreadDispatchQueue getTargetQueue() {
        return null;
    }

    public DispatchPriority getPriority() {
        return this.priority;
    }

    @Override
    public void resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void suspend() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isSuspended() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTargetQueue(DispatchQueue queue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public GlobalDispatchQueue isGlobalDispatchQueue() {
        return this;
    }

    @Override
    public SerialDispatchQueue isSerialDispatchQueue() {
        return null;
    }

    @Override
    public ThreadDispatchQueue isThreadDispatchQueue() {
        return null;
    }

    public String toString() {
        return IntrospectionSupport.toString(this);
    }

    @Override
    public DispatchQueue createQueue(String label) {
        SerialDispatchQueue rc = this.dispatcher.createQueue(label);
        rc.setTargetQueue(this);
        return rc;
    }

    @Override
    public DispatchQueue.QueueType getQueueType() {
        return DispatchQueue.QueueType.GLOBAL_QUEUE;
    }

    DispatchQueue[] getThreadQueues() {
        WorkerThread[] threads = this.workers.getThreads();
        DispatchQueue[] rc = new DispatchQueue[threads.length];
        for (int i = 0; i < threads.length; ++i) {
            rc[i] = threads[i].getDispatchQueue();
        }
        return rc;
    }

    @Override
    public void profile(boolean on) {
        this.metricsCollector = on ? new ActiveMetricsCollector(this) : InactiveMetricsCollector.INSTANCE;
    }

    @Override
    public Metrics metrics() {
        return this.metricsCollector.metrics();
    }
}

