/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.get.GetField;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.support.single.shard.TransportShardSingleOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.bloom.BloomFilter;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.uid.UidField;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.bloom.BloomCache;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMappers;
import org.elasticsearch.index.mapper.FieldMappersFieldSelector;
import org.elasticsearch.index.service.IndexService;
import org.elasticsearch.index.shard.service.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.TypeMissingException;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetAction
extends TransportShardSingleOperationAction<GetRequest, GetResponse> {
    private final IndicesService indicesService;
    private final ScriptService scriptService;

    @Inject
    public TransportGetAction(Settings settings, ClusterService clusterService, TransportService transportService, IndicesService indicesService, ScriptService scriptService, ThreadPool threadPool) {
        super(settings, threadPool, clusterService, transportService);
        this.indicesService = indicesService;
        this.scriptService = scriptService;
    }

    @Override
    protected String executor() {
        return "search";
    }

    @Override
    protected String transportAction() {
        return "indices/get";
    }

    @Override
    protected String transportShardAction() {
        return "indices/get/shard";
    }

    @Override
    protected void checkBlock(GetRequest request, ClusterState state) {
        state.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, request.index());
    }

    @Override
    protected GetResponse shardOperation(GetRequest request, int shardId) throws ElasticSearchException {
        IndexService indexService = this.indicesService.indexServiceSafe(request.index());
        BloomCache bloomCache = indexService.cache().bloomCache();
        IndexShard indexShard = indexService.shardSafe(shardId);
        DocumentMapper docMapper = indexService.mapperService().documentMapper(request.type());
        if (docMapper == null) {
            throw new TypeMissingException(new Index(request.index()), request.type());
        }
        if (request.refresh()) {
            indexShard.refresh(new Engine.Refresh(false));
        }
        Engine.Searcher searcher = indexShard.searcher();
        boolean exists = false;
        byte[] source = null;
        HashMap<String, GetField> fields = null;
        long version = -1L;
        try {
            UidField.DocIdAndVersion docIdAndVersion = this.loadCurrentVersionFromIndex(bloomCache, searcher, docMapper.uidMapper().term(request.type(), request.id()));
            if (docIdAndVersion != null && docIdAndVersion.docId != -1) {
                if (docIdAndVersion.version > 0L) {
                    version = docIdAndVersion.version;
                }
                exists = true;
                FieldSelector fieldSelector = this.buildFieldSelectors(docMapper, request.fields());
                if (fieldSelector != null) {
                    Document doc = docIdAndVersion.reader.document(docIdAndVersion.docId, fieldSelector);
                    source = this.extractSource(doc, docMapper);
                    Iterator<Fieldable> i$ = doc.getFields().iterator();
                    while (i$.hasNext()) {
                        GetField getField;
                        FieldMapper mapper;
                        Fieldable oField;
                        Fieldable field = oField = i$.next();
                        String name = field.name();
                        Object value = null;
                        FieldMappers fieldMappers = docMapper.mappers().indexName(field.name());
                        if (fieldMappers != null && (mapper = fieldMappers.mapper()) != null) {
                            name = mapper.names().fullName();
                            value = mapper.valueForSearch(field);
                        }
                        if (value == null) {
                            value = field.isBinary() ? field.getBinaryValue() : (Object)field.stringValue();
                        }
                        if (fields == null) {
                            fields = Maps.newHashMapWithExpectedSize(2);
                        }
                        if ((getField = (GetField)fields.get(name)) == null) {
                            getField = new GetField(name, new ArrayList<Object>(2));
                            fields.put(name, getField);
                        }
                        getField.values().add(value);
                    }
                }
                if (request.fields() != null && request.fields().length > 0) {
                    SearchLookup searchLookup = null;
                    for (String field : request.fields()) {
                        String script = null;
                        if (field.contains("_source.") || field.contains("doc[")) {
                            script = field;
                        } else {
                            FieldMappers x = docMapper.mappers().smartName(field);
                            if (x != null && !x.mapper().stored()) {
                                script = "_source." + x.mapper().names().fullName();
                            }
                        }
                        if (script == null) continue;
                        if (searchLookup == null) {
                            searchLookup = new SearchLookup(indexService.mapperService(), indexService.cache().fieldData());
                        }
                        SearchScript searchScript = this.scriptService.search(searchLookup, "mvel", script, null);
                        searchScript.setNextReader(docIdAndVersion.reader);
                        searchScript.setNextDocId(docIdAndVersion.docId);
                        try {
                            GetField getField;
                            Object value = searchScript.run();
                            if (fields == null) {
                                fields = Maps.newHashMapWithExpectedSize(2);
                            }
                            if ((getField = (GetField)fields.get(field)) == null) {
                                getField = new GetField(field, new ArrayList<Object>(2));
                                fields.put(field, getField);
                            }
                            getField.values().add(value);
                        }
                        catch (RuntimeException e) {
                            if (!this.logger.isTraceEnabled()) continue;
                            this.logger.trace("failed to execute get request script field [{}]", e, script);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new ElasticSearchException("Failed to get type [" + request.type() + "] and id [" + request.id() + "]", e);
        }
        finally {
            searcher.release();
        }
        return new GetResponse(request.index(), request.type(), request.id(), version, exists, source, fields);
    }

    private FieldSelector buildFieldSelectors(DocumentMapper docMapper, String ... fields) {
        if (fields == null) {
            return docMapper.sourceMapper().fieldSelector();
        }
        if (fields.length == 0) {
            return null;
        }
        FieldMappersFieldSelector fieldSelector = null;
        for (String fieldName : fields) {
            FieldMappers x = docMapper.mappers().smartName(fieldName);
            if (x == null || !x.mapper().stored()) continue;
            if (fieldSelector == null) {
                fieldSelector = new FieldMappersFieldSelector();
            }
            fieldSelector.add(x);
        }
        return fieldSelector;
    }

    private byte[] extractSource(Document doc, DocumentMapper documentMapper) {
        byte[] source = null;
        Fieldable sourceField = doc.getFieldable(documentMapper.sourceMapper().names().indexName());
        if (sourceField != null) {
            source = documentMapper.sourceMapper().nativeValue(sourceField);
            doc.removeField(documentMapper.sourceMapper().names().indexName());
        }
        return source;
    }

    private UidField.DocIdAndVersion loadCurrentVersionFromIndex(BloomCache bloomCache, Engine.Searcher searcher, Term uid) {
        UnicodeUtil.UTF8Result utf8 = Unicode.fromStringAsUtf8(uid.text());
        for (IndexReader reader : searcher.searcher().subReaders()) {
            UidField.DocIdAndVersion docIdAndVersion;
            BloomFilter filter = bloomCache.filter(reader, "_uid", true);
            if (!filter.isPresent(utf8.result, 0, utf8.length) || (docIdAndVersion = UidField.loadDocIdAndVersion(reader, uid)) == null) continue;
            return docIdAndVersion;
        }
        return null;
    }

    @Override
    protected GetRequest newRequest() {
        return new GetRequest();
    }

    @Override
    protected GetResponse newResponse() {
        return new GetResponse();
    }
}

