/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.percolate;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.util.UnicodeUtil;
import org.elasticsearch.ElasticSearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.action.support.single.custom.SingleCustomOperationRequest;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.Unicode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;

public class PercolateRequest
extends SingleCustomOperationRequest {
    private String index;
    private String type;
    private byte[] source;
    private int sourceOffset;
    private int sourceLength;
    private boolean sourceUnsafe;

    PercolateRequest() {
    }

    public PercolateRequest(String index, String type) {
        this.index = index;
        this.type = type;
    }

    public PercolateRequest index(String index) {
        this.index = index;
        return this;
    }

    public PercolateRequest type(String type) {
        this.type = type;
        return this;
    }

    public String index() {
        return this.index;
    }

    public String type() {
        return this.type;
    }

    @Override
    public void beforeLocalFork() {
        this.source();
    }

    public byte[] source() {
        if (this.sourceUnsafe || this.sourceOffset > 0) {
            this.source = Arrays.copyOfRange(this.source, this.sourceOffset, this.sourceOffset + this.sourceLength);
            this.sourceOffset = 0;
            this.sourceUnsafe = false;
        }
        return this.source;
    }

    public byte[] unsafeSource() {
        return this.source;
    }

    public int unsafeSourceOffset() {
        return this.sourceOffset;
    }

    public int unsafeSourceLength() {
        return this.sourceLength;
    }

    @Required
    public PercolateRequest source(Map source) throws ElasticSearchGenerationException {
        return this.source(source, XContentType.SMILE);
    }

    @Required
    public PercolateRequest source(Map source, XContentType contentType) throws ElasticSearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(contentType);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    @Required
    public PercolateRequest source(String source) {
        UnicodeUtil.UTF8Result result = Unicode.fromStringAsUtf8(source);
        this.source = result.result;
        this.sourceOffset = 0;
        this.sourceLength = result.length;
        this.sourceUnsafe = true;
        return this;
    }

    @Required
    public PercolateRequest source(XContentBuilder sourceBuilder) {
        try {
            this.source = sourceBuilder.unsafeBytes();
            this.sourceOffset = 0;
            this.sourceLength = sourceBuilder.unsafeBytesLength();
            this.sourceUnsafe = true;
        }
        catch (IOException e) {
            throw new ElasticSearchGenerationException("Failed to generate [" + sourceBuilder + "]", e);
        }
        return this;
    }

    public PercolateRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    @Required
    public PercolateRequest source(byte[] source, int offset, int length) {
        return this.source(source, offset, length, false);
    }

    @Required
    public PercolateRequest source(byte[] source, int offset, int length, boolean unsafe) {
        this.source = source;
        this.sourceOffset = offset;
        this.sourceLength = length;
        this.sourceUnsafe = unsafe;
        return this;
    }

    @Override
    public PercolateRequest preferLocal(boolean preferLocal) {
        super.preferLocal(preferLocal);
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.index == null) {
            validationException = Actions.addValidationError("index is missing", validationException);
        }
        if (this.type == null) {
            validationException = Actions.addValidationError("type is missing", validationException);
        }
        if (this.source == null) {
            validationException = Actions.addValidationError("source is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.index = in.readUTF();
        this.type = in.readUTF();
        this.sourceUnsafe = false;
        this.sourceOffset = 0;
        this.sourceLength = in.readVInt();
        this.source = new byte[this.sourceLength];
        in.readFully(this.source);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeUTF(this.index);
        out.writeUTF(this.type);
        out.writeVInt(this.sourceLength);
        out.writeBytes(this.source, this.sourceOffset, this.sourceLength);
    }
}

