/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.shard;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.Actions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class SingleShardOperationRequest
implements ActionRequest {
    protected String index;
    protected String type;
    protected String id;
    protected String routing;
    protected String preference;
    private boolean threadedListener = false;
    private boolean threadedOperation = true;

    protected SingleShardOperationRequest() {
    }

    public SingleShardOperationRequest(String index, String type, String id) {
        this.index = index;
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = Actions.addValidationError("index is missing", validationException);
        }
        if (this.type == null) {
            validationException = Actions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = Actions.addValidationError("id is missing", validationException);
        }
        return validationException;
    }

    public String index() {
        return this.index;
    }

    SingleShardOperationRequest index(String index) {
        this.index = index;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    @Override
    public boolean listenerThreaded() {
        return this.threadedListener;
    }

    @Override
    public SingleShardOperationRequest listenerThreaded(boolean threadedListener) {
        this.threadedListener = threadedListener;
        return this;
    }

    public boolean operationThreaded() {
        return this.threadedOperation;
    }

    public SingleShardOperationRequest operationThreaded(boolean threadedOperation) {
        this.threadedOperation = threadedOperation;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readUTF();
        this.type = in.readUTF();
        this.id = in.readUTF();
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
        if (in.readBoolean()) {
            this.preference = in.readUTF();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.index);
        out.writeUTF(this.type);
        out.writeUTF(this.id);
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
        if (this.preference == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.preference);
        }
    }
}

