/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.aopalliance.intercept.MethodInterceptor;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.ConstructorInjector;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.InjectorImpl;
import org.elasticsearch.common.inject.Key;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.internal.BindingImpl;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ErrorsException;
import org.elasticsearch.common.inject.internal.ImmutableSet;
import org.elasticsearch.common.inject.internal.InternalContext;
import org.elasticsearch.common.inject.internal.InternalFactory;
import org.elasticsearch.common.inject.internal.Preconditions;
import org.elasticsearch.common.inject.internal.Scoping;
import org.elasticsearch.common.inject.internal.ToStringBuilder;
import org.elasticsearch.common.inject.spi.BindingTargetVisitor;
import org.elasticsearch.common.inject.spi.ConstructorBinding;
import org.elasticsearch.common.inject.spi.Dependency;
import org.elasticsearch.common.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstructorBindingImpl<T>
extends BindingImpl<T>
implements ConstructorBinding<T> {
    private final Factory<T> factory;

    private ConstructorBindingImpl(Injector injector, Key<T> key, Object source, InternalFactory<? extends T> scopedFactory, Scoping scoping, Factory<T> factory) {
        super(injector, key, source, scopedFactory, scoping);
        this.factory = factory;
    }

    static <T> ConstructorBindingImpl<T> create(InjectorImpl injector, Key<T> key, Object source, Scoping scoping) {
        Factory factoryFactory = new Factory();
        InternalFactory<T> scopedFactory = Scopes.scope(key, injector, factoryFactory, scoping);
        return new ConstructorBindingImpl<T>(injector, key, source, scopedFactory, scoping, factoryFactory);
    }

    public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
        ((Factory)this.factory).constructorInjector = injector.constructors.get(this.getKey().getTypeLiteral(), errors);
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "not initialized");
        return visitor.visit(this);
    }

    @Override
    public InjectionPoint getConstructor() {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getConstructionProxy().getInjectionPoint();
    }

    @Override
    public Set<InjectionPoint> getInjectableMembers() {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getInjectableMembers();
    }

    @Override
    public Map<Method, List<MethodInterceptor>> getMethodInterceptors() {
        Preconditions.checkState(((Factory)this.factory).constructorInjector != null, "Binding is not ready");
        return ((Factory)this.factory).constructorInjector.getConstructionProxy().getMethodInterceptors();
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return Dependency.forInjectionPoints(new ImmutableSet.Builder<InjectionPoint>().add(this.getConstructor()).addAll(this.getInjectableMembers()).build());
    }

    @Override
    public void applyTo(Binder binder) {
        throw new UnsupportedOperationException("This element represents a synthetic binding.");
    }

    @Override
    public String toString() {
        return new ToStringBuilder(ConstructorBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", this.getScoping()).toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Factory<T>
    implements InternalFactory<T> {
        private ConstructorInjector<T> constructorInjector;

        private Factory() {
        }

        @Override
        public T get(Errors errors, InternalContext context, Dependency<?> dependency) throws ErrorsException {
            Preconditions.checkState(this.constructorInjector != null, "Constructor not ready");
            return (T)this.constructorInjector.construct(errors, context, dependency.getKey().getRawType());
        }
    }
}

