/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.mvel2.ast;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.elasticsearch.common.mvel2.CompileException;
import org.elasticsearch.common.mvel2.MVEL;
import org.elasticsearch.common.mvel2.ParserContext;
import org.elasticsearch.common.mvel2.ast.ASTNode;
import org.elasticsearch.common.mvel2.compiler.ExecutableLiteral;
import org.elasticsearch.common.mvel2.compiler.ExecutableStatement;
import org.elasticsearch.common.mvel2.integration.VariableResolverFactory;
import org.elasticsearch.common.mvel2.util.ParseTools;

public class RegExMatch
extends ASTNode {
    private ExecutableStatement stmt;
    private ExecutableStatement patternStmt;
    private int patternStart;
    private int patternOffset;
    private Pattern p;

    public RegExMatch(char[] expr, int start, int offset, int fields, int patternStart, int patternOffset, ParserContext pCtx) {
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.patternStart = patternStart;
        this.patternOffset = patternOffset;
        if ((fields & 0x10) != 0) {
            this.stmt = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset);
            this.patternStmt = (ExecutableStatement)ParseTools.subCompileExpression(expr, patternStart, patternOffset, pCtx);
            if (this.patternStmt instanceof ExecutableLiteral) {
                try {
                    this.p = Pattern.compile(String.valueOf(this.patternStmt.getValue(null, null)));
                }
                catch (PatternSyntaxException e) {
                    throw new CompileException("bad regular expression", expr, patternStart, e);
                }
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.p == null) {
            return Pattern.compile(String.valueOf(this.patternStmt.getValue(ctx, thisValue, factory))).matcher(String.valueOf(this.stmt.getValue(ctx, thisValue, factory))).matches();
        }
        return this.p.matcher(String.valueOf(this.stmt.getValue(ctx, thisValue, factory))).matches();
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        try {
            return Pattern.compile(String.valueOf(MVEL.eval(this.expr, this.patternStart, this.patternOffset, ctx, factory))).matcher(String.valueOf(MVEL.eval(this.expr, this.start, this.offset, ctx, factory))).matches();
        }
        catch (PatternSyntaxException e) {
            throw new CompileException("bad regular expression", this.expr, this.patternStart, e);
        }
    }

    public Class getEgressType() {
        return Boolean.class;
    }
}

