/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.trove.impl.hash;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.elasticsearch.common.trove.impl.HashFunctions;
import org.elasticsearch.common.trove.impl.hash.TPrimitiveHash;
import org.elasticsearch.common.trove.procedure.TByteProcedure;

public abstract class TByteShortHash
extends TPrimitiveHash {
    static final long serialVersionUID = 1L;
    public transient byte[] _set;
    protected byte no_entry_key;
    protected short no_entry_value;

    public TByteShortHash() {
        this.no_entry_key = 0;
        this.no_entry_value = 0;
    }

    public TByteShortHash(int initialCapacity) {
        super(initialCapacity);
        this.no_entry_key = 0;
        this.no_entry_value = 0;
    }

    public TByteShortHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = 0;
        this.no_entry_value = 0;
    }

    public TByteShortHash(int initialCapacity, float loadFactor, byte no_entry_key, short no_entry_value) {
        super(initialCapacity, loadFactor);
        this.no_entry_key = no_entry_key;
        this.no_entry_value = no_entry_value;
    }

    public byte getNoEntryKey() {
        return this.no_entry_key;
    }

    public short getNoEntryValue() {
        return this.no_entry_value;
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new byte[capacity];
        return capacity;
    }

    public boolean contains(byte val) {
        return this.index(val) >= 0;
    }

    public boolean forEach(TByteProcedure procedure) {
        byte[] states = this._states;
        byte[] set = this._set;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    protected void removeAt(int index) {
        this._set[index] = this.no_entry_key;
        super.removeAt(index);
    }

    protected int index(byte key) {
        byte[] states = this._states;
        byte[] set = this._set;
        int length = states.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] != 0 && (states[index] == 2 || set[index] != key)) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] != 0 && (states[index] == 2 || set[index] != key));
        }
        return states[index] == 0 ? -1 : index;
    }

    protected int insertionIndex(byte key) {
        byte[] states = this._states;
        byte[] set = this._set;
        int length = states.length;
        int hash = HashFunctions.hash(key) & Integer.MAX_VALUE;
        int index = hash % length;
        if (states[index] == 0) {
            return index;
        }
        if (states[index] == 1 && set[index] == key) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        if (states[index] != 2) {
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (states[index] == 1 && set[index] != key);
        }
        if (states[index] == 2) {
            int firstRemoved = index;
            while (states[index] != 0 && (states[index] == 2 || set[index] != key)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
            return states[index] == 1 ? -index - 1 : firstRemoved;
        }
        return states[index] == 1 ? -index - 1 : index;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(0);
        super.writeExternal(out);
        out.writeByte(this.no_entry_key);
        out.writeShort(this.no_entry_value);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.readByte();
        super.readExternal(in);
        this.no_entry_key = in.readByte();
        this.no_entry_value = in.readShort();
    }
}

