/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.LinkedList;
import java.util.Map;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.IndexQueryParser;
import org.elasticsearch.index.query.IndexQueryParserFactory;
import org.elasticsearch.index.query.IndexQueryParserService;
import org.elasticsearch.index.query.xcontent.AndFilterParser;
import org.elasticsearch.index.query.xcontent.BoolFilterParser;
import org.elasticsearch.index.query.xcontent.BoolQueryParser;
import org.elasticsearch.index.query.xcontent.BoostingQueryParser;
import org.elasticsearch.index.query.xcontent.ConstantScoreQueryParser;
import org.elasticsearch.index.query.xcontent.CustomBoostFactorQueryParser;
import org.elasticsearch.index.query.xcontent.CustomScoreQueryParser;
import org.elasticsearch.index.query.xcontent.DisMaxQueryParser;
import org.elasticsearch.index.query.xcontent.ExistsFilterParser;
import org.elasticsearch.index.query.xcontent.FQueryFilterParser;
import org.elasticsearch.index.query.xcontent.FieldQueryParser;
import org.elasticsearch.index.query.xcontent.FilteredQueryParser;
import org.elasticsearch.index.query.xcontent.FuzzyLikeThisFieldQueryParser;
import org.elasticsearch.index.query.xcontent.FuzzyLikeThisQueryParser;
import org.elasticsearch.index.query.xcontent.FuzzyQueryParser;
import org.elasticsearch.index.query.xcontent.GeoBoundingBoxFilterParser;
import org.elasticsearch.index.query.xcontent.GeoDistanceFilterParser;
import org.elasticsearch.index.query.xcontent.GeoDistanceRangeFilterParser;
import org.elasticsearch.index.query.xcontent.GeoPolygonFilterParser;
import org.elasticsearch.index.query.xcontent.HasChildFilterParser;
import org.elasticsearch.index.query.xcontent.HasChildQueryParser;
import org.elasticsearch.index.query.xcontent.IdsFilterParser;
import org.elasticsearch.index.query.xcontent.IdsQueryParser;
import org.elasticsearch.index.query.xcontent.MatchAllFilterParser;
import org.elasticsearch.index.query.xcontent.MatchAllQueryParser;
import org.elasticsearch.index.query.xcontent.MissingFilterParser;
import org.elasticsearch.index.query.xcontent.MoreLikeThisFieldQueryParser;
import org.elasticsearch.index.query.xcontent.MoreLikeThisQueryParser;
import org.elasticsearch.index.query.xcontent.NotFilterParser;
import org.elasticsearch.index.query.xcontent.NumericRangeFilterParser;
import org.elasticsearch.index.query.xcontent.OrFilterParser;
import org.elasticsearch.index.query.xcontent.PrefixFilterParser;
import org.elasticsearch.index.query.xcontent.PrefixQueryParser;
import org.elasticsearch.index.query.xcontent.QueryFilterParser;
import org.elasticsearch.index.query.xcontent.QueryStringQueryParser;
import org.elasticsearch.index.query.xcontent.RangeFilterParser;
import org.elasticsearch.index.query.xcontent.RangeQueryParser;
import org.elasticsearch.index.query.xcontent.ScriptFilterParser;
import org.elasticsearch.index.query.xcontent.SpanFirstQueryParser;
import org.elasticsearch.index.query.xcontent.SpanNearQueryParser;
import org.elasticsearch.index.query.xcontent.SpanNotQueryParser;
import org.elasticsearch.index.query.xcontent.SpanOrQueryParser;
import org.elasticsearch.index.query.xcontent.SpanTermQueryParser;
import org.elasticsearch.index.query.xcontent.TermFilterParser;
import org.elasticsearch.index.query.xcontent.TermQueryParser;
import org.elasticsearch.index.query.xcontent.TermsFilterParser;
import org.elasticsearch.index.query.xcontent.TermsQueryParser;
import org.elasticsearch.index.query.xcontent.TopChildrenQueryParser;
import org.elasticsearch.index.query.xcontent.TypeFilterParser;
import org.elasticsearch.index.query.xcontent.WildcardQueryParser;
import org.elasticsearch.index.query.xcontent.XContentFilterParser;
import org.elasticsearch.index.query.xcontent.XContentFilterParserFactory;
import org.elasticsearch.index.query.xcontent.XContentIndexQueryParser;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.query.xcontent.XContentQueryParserFactory;

public class IndexQueryParserModule
extends AbstractModule {
    private final Settings settings;
    private final LinkedList<QueryParsersProcessor> processors = Lists.newLinkedList();

    public IndexQueryParserModule(Settings settings) {
        this.settings = settings;
        this.processors.add(new DefaultQueryProcessors());
    }

    public IndexQueryParserModule addProcessor(QueryParsersProcessor processor) {
        this.processors.addFirst(processor);
        return this;
    }

    @Override
    protected void configure() {
        MapBinder<String, IndexQueryParserFactory> qbinder = MapBinder.newMapBinder(this.binder(), String.class, IndexQueryParserFactory.class);
        Map<String, Settings> queryParserGroupSettings = this.settings.getGroups("index.queryparser.types");
        for (Map.Entry<String, Settings> entry : queryParserGroupSettings.entrySet()) {
            String qName = entry.getKey();
            Settings qSettings = entry.getValue();
            qbinder.addBinding(qName).toProvider(FactoryProvider.newFactory(IndexQueryParserFactory.class, qSettings.getAsClass("type", XContentIndexQueryParser.class))).in(Scopes.SINGLETON);
        }
        if (!queryParserGroupSettings.containsKey("default")) {
            qbinder.addBinding("default").toProvider(FactoryProvider.newFactory(IndexQueryParserFactory.class, XContentIndexQueryParser.class)).in(Scopes.SINGLETON);
        }
        QueryParsersProcessor.IndexQueryParsersBindings queryParsersBindings = new QueryParsersProcessor.IndexQueryParsersBindings(qbinder, queryParserGroupSettings);
        for (QueryParsersProcessor processor : this.processors) {
            processor.processIndexQueryParsers(queryParsersBindings);
        }
        MapBinder<String, XContentQueryParserFactory> queryBinder = MapBinder.newMapBinder(this.binder(), String.class, XContentQueryParserFactory.class);
        Map<String, Settings> xContentQueryParserGroups = this.settings.getGroups("index.queryparser.query");
        for (Map.Entry<String, Settings> entry : xContentQueryParserGroups.entrySet()) {
            String qName = entry.getKey();
            Settings qSettings = entry.getValue();
            Class type = qSettings.getAsClass("type", null);
            if (type == null) {
                throw new IllegalArgumentException("Query Parser [" + qName + "] must be provided with a type");
            }
            queryBinder.addBinding(qName).toProvider(FactoryProvider.newFactory(XContentQueryParserFactory.class, qSettings.getAsClass("type", null))).in(Scopes.SINGLETON);
        }
        QueryParsersProcessor.XContentQueryParsersBindings xContentQueryParsersBindings = new QueryParsersProcessor.XContentQueryParsersBindings(queryBinder, xContentQueryParserGroups);
        for (QueryParsersProcessor processor : this.processors) {
            processor.processXContentQueryParsers(xContentQueryParsersBindings);
        }
        MapBinder<String, XContentFilterParserFactory> filterBinder = MapBinder.newMapBinder(this.binder(), String.class, XContentFilterParserFactory.class);
        Map<String, Settings> xContentFilterParserGroups = this.settings.getGroups("index.queryparser.filter");
        for (Map.Entry<String, Settings> entry : xContentFilterParserGroups.entrySet()) {
            String fName = entry.getKey();
            Settings fSettings = entry.getValue();
            Class type = fSettings.getAsClass("type", null);
            if (type == null) {
                throw new IllegalArgumentException("Filter Parser [" + fName + "] must be provided with a type");
            }
            filterBinder.addBinding(fName).toProvider(FactoryProvider.newFactory(XContentFilterParserFactory.class, fSettings.getAsClass("type", null))).in(Scopes.SINGLETON);
        }
        QueryParsersProcessor.XContentFilterParsersBindings xContentFilterParsersBindings = new QueryParsersProcessor.XContentFilterParsersBindings(filterBinder, xContentFilterParserGroups);
        for (QueryParsersProcessor processor : this.processors) {
            processor.processXContentFilterParsers(xContentFilterParsersBindings);
        }
        this.bind(IndexQueryParserService.class).asEagerSingleton();
    }

    private static class DefaultQueryProcessors
    extends QueryParsersProcessor {
        private DefaultQueryProcessors() {
        }

        @Override
        public void processXContentQueryParsers(QueryParsersProcessor.XContentQueryParsersBindings bindings) {
            bindings.processXContentQueryParser("has_child", HasChildQueryParser.class);
            bindings.processXContentQueryParser("top_children", TopChildrenQueryParser.class);
            bindings.processXContentQueryParser("dis_max", DisMaxQueryParser.class);
            bindings.processXContentQueryParser("ids", IdsQueryParser.class);
            bindings.processXContentQueryParser("match_all", MatchAllQueryParser.class);
            bindings.processXContentQueryParser("query_string", QueryStringQueryParser.class);
            bindings.processXContentQueryParser("boosting", BoostingQueryParser.class);
            bindings.processXContentQueryParser("bool", BoolQueryParser.class);
            bindings.processXContentQueryParser("term", TermQueryParser.class);
            bindings.processXContentQueryParser("terms", TermsQueryParser.class);
            bindings.processXContentQueryParser("fuzzy", FuzzyQueryParser.class);
            bindings.processXContentQueryParser("field", FieldQueryParser.class);
            bindings.processXContentQueryParser("range", RangeQueryParser.class);
            bindings.processXContentQueryParser("prefix", PrefixQueryParser.class);
            bindings.processXContentQueryParser("wildcard", WildcardQueryParser.class);
            bindings.processXContentQueryParser("filtered", FilteredQueryParser.class);
            bindings.processXContentQueryParser("constant_score", ConstantScoreQueryParser.class);
            bindings.processXContentQueryParser("custom_boost_factor", CustomBoostFactorQueryParser.class);
            bindings.processXContentQueryParser("custom_score", CustomScoreQueryParser.class);
            bindings.processXContentQueryParser("span_term", SpanTermQueryParser.class);
            bindings.processXContentQueryParser("span_not", SpanNotQueryParser.class);
            bindings.processXContentQueryParser("span_first", SpanFirstQueryParser.class);
            bindings.processXContentQueryParser("span_near", SpanNearQueryParser.class);
            bindings.processXContentQueryParser("span_or", SpanOrQueryParser.class);
            bindings.processXContentQueryParser("mlt", MoreLikeThisQueryParser.class);
            bindings.processXContentQueryParser("mlt_field", MoreLikeThisFieldQueryParser.class);
            bindings.processXContentQueryParser("flt", FuzzyLikeThisQueryParser.class);
            bindings.processXContentQueryParser("flt_field", FuzzyLikeThisFieldQueryParser.class);
        }

        @Override
        public void processXContentFilterParsers(QueryParsersProcessor.XContentFilterParsersBindings bindings) {
            bindings.processXContentQueryFilter("has_child", HasChildFilterParser.class);
            bindings.processXContentQueryFilter("type", TypeFilterParser.class);
            bindings.processXContentQueryFilter("ids", IdsFilterParser.class);
            bindings.processXContentQueryFilter("term", TermFilterParser.class);
            bindings.processXContentQueryFilter("terms", TermsFilterParser.class);
            bindings.processXContentQueryFilter("range", RangeFilterParser.class);
            bindings.processXContentQueryFilter("numeric_range", NumericRangeFilterParser.class);
            bindings.processXContentQueryFilter("prefix", PrefixFilterParser.class);
            bindings.processXContentQueryFilter("script", ScriptFilterParser.class);
            bindings.processXContentQueryFilter("geo_distance", GeoDistanceFilterParser.class);
            bindings.processXContentQueryFilter("geo_distance_range", GeoDistanceRangeFilterParser.class);
            bindings.processXContentQueryFilter("geo_bbox", GeoBoundingBoxFilterParser.class);
            bindings.processXContentQueryFilter("geo_polygon", GeoPolygonFilterParser.class);
            bindings.processXContentQueryFilter("query", QueryFilterParser.class);
            bindings.processXContentQueryFilter("fquery", FQueryFilterParser.class);
            bindings.processXContentQueryFilter("bool", BoolFilterParser.class);
            bindings.processXContentQueryFilter("and", AndFilterParser.class);
            bindings.processXContentQueryFilter("or", OrFilterParser.class);
            bindings.processXContentQueryFilter("not", NotFilterParser.class);
            bindings.processXContentQueryFilter("match_all", MatchAllFilterParser.class);
            bindings.processXContentQueryFilter("exists", ExistsFilterParser.class);
            bindings.processXContentQueryFilter("missing", MissingFilterParser.class);
        }
    }

    public static class QueryParsersProcessor {
        public void processIndexQueryParsers(IndexQueryParsersBindings bindings) {
        }

        public void processXContentQueryParsers(XContentQueryParsersBindings bindings) {
        }

        public void processXContentFilterParsers(XContentFilterParsersBindings bindings) {
        }

        public static class XContentFilterParsersBindings {
            private final MapBinder<String, XContentFilterParserFactory> binder;
            private final Map<String, Settings> groupSettings;

            public XContentFilterParsersBindings(MapBinder<String, XContentFilterParserFactory> binder, Map<String, Settings> groupSettings) {
                this.binder = binder;
                this.groupSettings = groupSettings;
            }

            public MapBinder<String, XContentFilterParserFactory> binder() {
                return this.binder;
            }

            public Map<String, Settings> groupSettings() {
                return this.groupSettings;
            }

            public void processXContentQueryFilter(String name, Class<? extends XContentFilterParser> xcontentFilterParser) {
                if (!this.groupSettings.containsKey(name)) {
                    this.binder.addBinding(name).toProvider(FactoryProvider.newFactory(XContentFilterParserFactory.class, xcontentFilterParser)).in(Scopes.SINGLETON);
                }
            }
        }

        public static class XContentQueryParsersBindings {
            private final MapBinder<String, XContentQueryParserFactory> binder;
            private final Map<String, Settings> groupSettings;

            public XContentQueryParsersBindings(MapBinder<String, XContentQueryParserFactory> binder, Map<String, Settings> groupSettings) {
                this.binder = binder;
                this.groupSettings = groupSettings;
            }

            public MapBinder<String, XContentQueryParserFactory> binder() {
                return this.binder;
            }

            public Map<String, Settings> groupSettings() {
                return this.groupSettings;
            }

            public void processXContentQueryParser(String name, Class<? extends XContentQueryParser> xcontentQueryParser) {
                if (!this.groupSettings.containsKey(name)) {
                    this.binder.addBinding(name).toProvider(FactoryProvider.newFactory(XContentQueryParserFactory.class, xcontentQueryParser)).in(Scopes.SINGLETON);
                }
            }
        }

        public static class IndexQueryParsersBindings {
            private final MapBinder<String, IndexQueryParserFactory> binder;
            private final Map<String, Settings> groupSettings;

            public IndexQueryParsersBindings(MapBinder<String, IndexQueryParserFactory> binder, Map<String, Settings> groupSettings) {
                this.binder = binder;
                this.groupSettings = groupSettings;
            }

            public MapBinder<String, IndexQueryParserFactory> binder() {
                return this.binder;
            }

            public Map<String, Settings> groupSettings() {
                return this.groupSettings;
            }

            public void processIndexQueryParser(String name, Class<? extends IndexQueryParser> indexQueryParser) {
                if (!this.groupSettings.containsKey(name)) {
                    this.binder.addBinding(name).toProvider(FactoryProvider.newFactory(IndexQueryParserFactory.class, indexQueryParser)).in(Scopes.SINGLETON);
                }
            }
        }
    }
}

