/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard.recovery;

import org.elasticsearch.ElasticSearchWrapperException;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.shard.IndexShardException;
import org.elasticsearch.index.shard.ShardId;

public class RecoverFilesRecoveryException
extends IndexShardException
implements ElasticSearchWrapperException {
    private final int numberOfFiles;
    private final ByteSizeValue totalFilesSize;

    public RecoverFilesRecoveryException(ShardId shardId, int numberOfFiles, ByteSizeValue totalFilesSize, Throwable cause) {
        super(shardId, "Failed to transfer [" + numberOfFiles + "] files with total size of [" + totalFilesSize + "]", cause);
        this.numberOfFiles = numberOfFiles;
        this.totalFilesSize = totalFilesSize;
    }

    public int numberOfFiles() {
        return this.numberOfFiles;
    }

    public ByteSizeValue totalFilesSize() {
        return this.totalFilesSize;
    }
}

