/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.osgi.service.cm.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="profile-edit", scope="fabric", description="Edits the specified version of the specified profile (where the version defaults to the current default version)", detailedDescription="classpath:profileEdit.txt")
public class ProfileEdit
extends FabricCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileEdit.class);
    static final String FEATURE_PREFIX = "feature.";
    static final String REPOSITORY_PREFIX = "repository.";
    static final String BUNDLE_PREFIX = "bundle.";
    static final String FAB_PREFIX = "fab.";
    static final String CONFIG_PREFIX = "config.";
    static final String SYSTEM_PREFIX = "system.";
    static final String DELIMETER = ",";
    static final String PID_KEY_SEPARATOR = "/";
    @Option(name="-r", aliases={"--repositories"}, description="Edit the features repositories", required=false, multiValued=false)
    private String repositoryUriList;
    @Option(name="-f", aliases={"--features"}, description="Edit features, specifying a comma-separated list of features to add (or delete).", required=false, multiValued=false)
    private String featuresList;
    @Option(name="-b", aliases={"--bundles"}, description="Edit bundles, specifying a comma-separated list of bundles to add (or delete).", required=false, multiValued=false)
    private String bundlesList;
    @Option(name="-f", aliases={"--fabs"}, description="Edit fabs, specifying a comma-separated list of fabs to add (or delete).", required=false, multiValued=false)
    private String fabsList;
    @Option(name="-p", aliases={"--pid"}, description="Edit an OSGi configuration property, specified in the format <PID>/<Property>.", required=false, multiValued=false)
    private String configAdminConfigList;
    @Option(name="-s", aliases={"--system"}, description="Edit the Java system properties that affect installed bundles (analogous to editing etc/system.properties in a root container).", required=false, multiValued=false)
    private String systemPropertyList;
    @Option(name="-c", aliases={"--config"}, description="Edit the Java system properties that affect the karaf container (analogous to editing etc/config.properties in a root container).", required=false, multiValued=false)
    private String configPropertyList;
    @Option(name="-i", aliases={"--import-pid"}, description="Imports the pids that are edited, from local OSGi config admin", required=false, multiValued=false)
    private boolean importPid = false;
    @Option(name="--set", description="Set or create values (selected by default).")
    private boolean set = true;
    @Option(name="--delete", description="Delete values.")
    private boolean delete = false;
    @Argument(index=0, name="profile", description="The target profile to edit", required=true, multiValued=false)
    private String profileName;
    @Argument(index=1, name="version", description="The version of the profile to edit. Defaults to the current default version.", required=false, multiValued=false)
    private String versionName = "1.0";

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        if (this.delete) {
            this.set = false;
        }
        Version version = this.versionName != null ? this.fabricService.getVersion(this.versionName) : this.fabricService.getDefaultVersion();
        for (Profile profile : version.getProfiles()) {
            if (!this.profileName.equals(profile.getId())) continue;
            this.editProfile(profile);
        }
        return null;
    }

    private void editProfile(Profile profile) throws Exception {
        String key;
        Map<String, String> configMap;
        String[] keyValues;
        String value;
        Map config = profile.getConfigurations();
        HashMap<String, String> pidConfig = (HashMap<String, String>)config.get(AGENT_PID);
        if (pidConfig == null) {
            pidConfig = new HashMap<String, String>();
        }
        if (this.featuresList != null && !this.featuresList.isEmpty()) {
            String[] features;
            for (String feature : features = this.featuresList.split(DELIMETER)) {
                this.updateConfig(pidConfig, FEATURE_PREFIX + feature.replace('/', '_'), feature, this.set, this.delete);
            }
        }
        if (this.repositoryUriList != null && !this.repositoryUriList.isEmpty()) {
            String[] repositoryURIs;
            for (String repopsitoryURI : repositoryURIs = this.repositoryUriList.split(DELIMETER)) {
                this.updateConfig(pidConfig, REPOSITORY_PREFIX + repopsitoryURI.replace('/', '_'), repopsitoryURI, this.set, this.delete);
            }
        }
        if (this.bundlesList != null && !this.bundlesList.isEmpty()) {
            String[] bundles;
            for (String bundlesLocation : bundles = this.bundlesList.split(DELIMETER)) {
                this.updateConfig(pidConfig, BUNDLE_PREFIX + bundlesLocation.replace('/', '_'), bundlesLocation, this.set, this.delete);
            }
        }
        if (this.fabsList != null && !this.fabsList.isEmpty()) {
            String[] fabs;
            for (String fabsLocation : fabs = this.fabsList.split(DELIMETER)) {
                this.updateConfig(pidConfig, FAB_PREFIX + fabsLocation.replace('/', '_'), fabsLocation, this.set, this.delete);
            }
        }
        if (this.configAdminConfigList != null && !this.configAdminConfigList.isEmpty()) {
            Map<String, String> configMap2 = this.extractConfigs(this.configAdminConfigList);
            for (Map.Entry<String, String> configEntries : configMap2.entrySet()) {
                String key2 = configEntries.getKey();
                if (!key2.contains(".")) continue;
                String pid = key2.substring(0, key2.lastIndexOf(PID_KEY_SEPARATOR));
                key2 = key2.substring(key2.lastIndexOf(PID_KEY_SEPARATOR) + 1);
                value = configEntries.getValue();
                HashMap<String, String> cfg = (HashMap<String, String>)config.get(pid);
                if (cfg == null) {
                    cfg = new HashMap<String, String>();
                }
                if (this.importPid) {
                    this.importPidFromLocalConfigAdmin(pid, cfg);
                }
                this.updateConfig(cfg, key2, value, this.set, this.delete);
                config.put(pid, cfg);
            }
        }
        if (this.systemPropertyList != null && !this.systemPropertyList.isEmpty()) {
            keyValues = this.systemPropertyList.split("=");
            configMap = this.extractConfigs(this.systemPropertyList);
            for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                key = configEntries.getKey();
                value = configEntries.getValue();
                this.updateConfig(pidConfig, SYSTEM_PREFIX + key, value, this.set, this.delete);
            }
        }
        if (this.configPropertyList != null && !this.configPropertyList.isEmpty()) {
            keyValues = this.configPropertyList.split("=");
            configMap = this.extractConfigs(this.configPropertyList);
            for (Map.Entry<String, String> configEntries : configMap.entrySet()) {
                key = configEntries.getKey();
                value = configEntries.getValue();
                this.updateConfig(pidConfig, CONFIG_PREFIX + key, value, this.set, this.delete);
            }
        }
        config.put(AGENT_PID, pidConfig);
        profile.setConfigurations(config);
    }

    public void updateConfig(Map<String, String> map, String key, String value, boolean set, boolean delete) {
        if (set) {
            map.put(key, value);
        } else if (delete) {
            map.remove(key);
        }
    }

    private void importPidFromLocalConfigAdmin(String pid, Map<String, String> target) {
        try {
            Configuration[] configuration = this.configurationAdmin.listConfigurations("service.pid=" + pid + ")");
            if (configuration != null && configuration.length > 0) {
                Dictionary dictionary = configuration[0].getProperties();
                Enumeration keyEnumeration = dictionary.keys();
                while (keyEnumeration.hasMoreElements()) {
                    String key = String.valueOf(keyEnumeration.nextElement());
                    String value = String.valueOf(dictionary.get(key));
                    target.put(key, value);
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error while importing configuration {} to profile.", (Object)pid);
        }
    }

    private Map<String, String> extractConfigs(String configs) {
        HashMap<String, String> configMap = new HashMap<String, String>();
        if (configs.contains("=")) {
            String[] keyValues = configs.split("=");
            int index = 0;
            String prefix = "";
            while (index + 1 < keyValues.length) {
                String key = !prefix.isEmpty() ? prefix : keyValues[index];
                String value = keyValues[index + 1];
                if (value.contains(DELIMETER) && index + 2 != keyValues.length) {
                    prefix = value.substring(value.lastIndexOf(DELIMETER) + 1);
                    value = value.substring(0, value.lastIndexOf(DELIMETER));
                } else {
                    prefix = "";
                }
                configMap.put(key, value);
                ++index;
            }
        } else {
            String[] keys;
            for (String key : keys = configs.split(DELIMETER)) {
                configMap.put(key, "");
            }
        }
        return configMap;
    }
}

