/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.hibernate.encryptor;

import java.math.BigInteger;
import org.jasypt.encryption.pbe.PBEBigIntegerEncryptor;
import org.jasypt.encryption.pbe.StandardPBEBigIntegerEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.hibernate.encryptor.HibernatePBEEncryptorRegistry;
import org.jasypt.salt.SaltGenerator;

public final class HibernatePBEBigIntegerEncryptor {
    private String registeredName = null;
    private PBEBigIntegerEncryptor encryptor = null;
    private boolean encryptorSet = false;

    public HibernatePBEBigIntegerEncryptor() {
        this.encryptor = new StandardPBEBigIntegerEncryptor();
        this.encryptorSet = false;
    }

    HibernatePBEBigIntegerEncryptor(String registeredName, PBEBigIntegerEncryptor encryptor) {
        this.encryptor = encryptor;
        this.registeredName = registeredName;
        this.encryptorSet = true;
    }

    public PBEBigIntegerEncryptor getEncryptor() {
        return this.encryptor;
    }

    public void setEncryptor(PBEBigIntegerEncryptor encryptor) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        this.encryptor = encryptor;
        this.encryptorSet = true;
    }

    public void setPassword(String password) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigIntegerEncryptor standardPBEBigIntegerEncryptor = (StandardPBEBigIntegerEncryptor)this.encryptor;
        standardPBEBigIntegerEncryptor.setPassword(password);
    }

    public void setAlgorithm(String algorithm) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigIntegerEncryptor standardPBEBigIntegerEncryptor = (StandardPBEBigIntegerEncryptor)this.encryptor;
        standardPBEBigIntegerEncryptor.setAlgorithm(algorithm);
    }

    public void setKeyObtentionIterations(int keyObtentionIterations) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigIntegerEncryptor standardPBEBigIntegerEncryptor = (StandardPBEBigIntegerEncryptor)this.encryptor;
        standardPBEBigIntegerEncryptor.setKeyObtentionIterations(keyObtentionIterations);
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigIntegerEncryptor standardPBEBigIntegerEncryptor = (StandardPBEBigIntegerEncryptor)this.encryptor;
        standardPBEBigIntegerEncryptor.setSaltGenerator(saltGenerator);
    }

    public void setConfig(PBEConfig config) {
        if (this.encryptorSet) {
            throw new EncryptionInitializationException("An encryptor has been already set: no further configuration possible on hibernate wrapper");
        }
        StandardPBEBigIntegerEncryptor standardPBEBigIntegerEncryptor = (StandardPBEBigIntegerEncryptor)this.encryptor;
        standardPBEBigIntegerEncryptor.setConfig(config);
    }

    public BigInteger encrypt(BigInteger message) {
        if (this.encryptor == null) {
            throw new EncryptionInitializationException("Encryptor has not been set into Hibernate wrapper");
        }
        return this.encryptor.encrypt(message);
    }

    public BigInteger decrypt(BigInteger encryptedMessage) {
        if (this.encryptor == null) {
            throw new EncryptionInitializationException("Encryptor has not been set into Hibernate wrapper");
        }
        return this.encryptor.decrypt(encryptedMessage);
    }

    public void setRegisteredName(String registeredName) {
        if (this.registeredName != null) {
            HibernatePBEEncryptorRegistry.getInstance().unregisterHibernatePBEBigIntegerEncryptor(this.registeredName);
        }
        this.registeredName = registeredName;
        HibernatePBEEncryptorRegistry.getInstance().registerHibernatePBEBigIntegerEncryptor(this);
    }

    public String getRegisteredName() {
        return this.registeredName;
    }
}

