/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.adapter;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.felix.eventadmin.impl.adapter.AbstractAdapter;
import org.apache.felix.eventadmin.impl.util.LogWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public class ServiceEventAdapter
extends AbstractAdapter
implements ServiceListener {
    public ServiceEventAdapter(BundleContext context, EventAdmin admin) {
        super(admin);
        context.addServiceListener((ServiceListener)this);
    }

    public void destroy(BundleContext context) {
        context.removeServiceListener((ServiceListener)this);
    }

    public void serviceChanged(ServiceEvent event) {
        Object objectClass;
        Object pid;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("event", event);
        ((Dictionary)properties).put("service", event.getServiceReference());
        Object id = event.getServiceReference().getProperty("service.id");
        if (null != id) {
            try {
                ((Dictionary)properties).put("service.id", new Long(id.toString()));
            }
            catch (NumberFormatException ne) {
                LogWrapper.getLogger().log(event.getServiceReference(), 2, "Exception parsing service.id=" + id, ne);
            }
        }
        if (null != (pid = event.getServiceReference().getProperty("service.pid"))) {
            ((Dictionary)properties).put("service.pid", pid.toString());
        }
        if (null != (objectClass = event.getServiceReference().getProperty("objectClass"))) {
            if (objectClass instanceof String[]) {
                ((Dictionary)properties).put("service.objectClass", objectClass);
            } else {
                ((Dictionary)properties).put("service.objectClass", new String[]{objectClass.toString()});
            }
        }
        StringBuffer topic = new StringBuffer(ServiceEvent.class.getName().replace('.', '/')).append('/');
        switch (event.getType()) {
            case 1: {
                topic.append("REGISTERED");
                break;
            }
            case 2: {
                topic.append("MODIFIED");
                break;
            }
            case 4: {
                topic.append("UNREGISTERING");
                break;
            }
            default: {
                return;
            }
        }
        try {
            this.getEventAdmin().postEvent(new Event(topic.toString(), properties));
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
    }
}

