/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.inspector;

import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.rrd4j.core.RrdDb;
import org.rrd4j.inspector.RrdNode;
import org.rrd4j.inspector.Util;

class MainTreeModel
extends DefaultTreeModel {
    private static final DefaultMutableTreeNode INVALID_NODE = new DefaultMutableTreeNode("No valid RRD file specified");

    MainTreeModel() {
        super(INVALID_NODE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setFile(File newFile) {
        try {
            RrdDb rrd = new RrdDb(newFile.getAbsolutePath(), true);
            try {
                DefaultMutableTreeNode root = new DefaultMutableTreeNode(new RrdNode(rrd));
                int dsCount = rrd.getRrdDef().getDsCount();
                int arcCount = rrd.getRrdDef().getArcCount();
                for (int dsIndex = 0; dsIndex < dsCount; ++dsIndex) {
                    DefaultMutableTreeNode dsNode = new DefaultMutableTreeNode(new RrdNode(rrd, dsIndex));
                    for (int arcIndex = 0; arcIndex < arcCount; ++arcIndex) {
                        DefaultMutableTreeNode arcNode = new DefaultMutableTreeNode(new RrdNode(rrd, dsIndex, arcIndex));
                        dsNode.add(arcNode);
                    }
                    root.add(dsNode);
                }
                this.setRoot(root);
            }
            finally {
                rrd.close();
            }
            return true;
        }
        catch (Exception e) {
            this.setRoot(INVALID_NODE);
            Util.error(null, e);
            return false;
        }
    }
}

