/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.insight.log.elasticsearch;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.fusesource.insight.log.elasticsearch.ElasticSender;
import org.ops4j.pax.logging.spi.PaxAppender;
import org.ops4j.pax.logging.spi.PaxLoggingEvent;

public class InsightLogAppender
implements PaxAppender {
    private static final AtomicLong SEQUENCE_COUNTER = new AtomicLong(System.currentTimeMillis() * 1000L);
    private String name;
    private String index;
    private String type;
    private ElasticSender sender;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIndex() {
        return this.index;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ElasticSender getSender() {
        return this.sender;
    }

    public void setSender(ElasticSender sender) {
        this.sender = sender;
    }

    public void init() {
        CreateIndexRequest request = new CreateIndexRequest(this.index);
        request = request.settings("{\"analysis\":{\"analyzer\":{\"lower\":{\"type\":\"custom\",\"tokenizer\":\"keyword\",\"filter\":[\"lowercase\"]}}}}");
        HashMap<String, String> not_analyzed = new HashMap<String, String>();
        not_analyzed.put("type", "string");
        not_analyzed.put("index", "not_analyzed");
        HashMap<String, String> lower = new HashMap<String, String>();
        lower.put("type", "string");
        lower.put("analyzer", "lower");
        HashMap<String, HashMap<String, String>> properties = new HashMap<String, HashMap<String, String>>();
        properties.put("host", lower);
        properties.put("level", lower);
        properties.put("thread", lower);
        properties.put("seq", not_analyzed);
        properties.put("logger", lower);
        HashMap<String, HashMap<String, HashMap<String, String>>> options = new HashMap<String, HashMap<String, HashMap<String, String>>>();
        options.put("properties", properties);
        request.mapping(this.type, options);
        this.sender.createIndexIfNeeded(request);
    }

    public void doAppend(PaxLoggingEvent paxLoggingEvent) {
        try {
            if ("TRACE".equals(paxLoggingEvent.getLevel().toString().toUpperCase()) && !paxLoggingEvent.getProperties().containsKey("trace-id")) {
                return;
            }
            StringBuilder writer = new StringBuilder();
            writer.append("{ \"host\" : ");
            ElasticSender.quote(this.name, writer);
            writer.append(",\n  \"seq\" : " + SEQUENCE_COUNTER.incrementAndGet());
            writer.append(",\n  \"timestamp\" : ");
            ElasticSender.quote(this.formatDate(paxLoggingEvent.getTimeStamp()), writer);
            writer.append(",\n  \"level\" : ");
            ElasticSender.quote(paxLoggingEvent.getLevel().toString(), writer);
            writer.append(",\n  \"logger\" : ");
            ElasticSender.quote(paxLoggingEvent.getLoggerName(), writer);
            writer.append(",\n  \"thread\" : ");
            ElasticSender.quote(paxLoggingEvent.getThreadName(), writer);
            writer.append(",\n  \"message\" : ");
            ElasticSender.quote(paxLoggingEvent.getMessage(), writer);
            String[] throwable = paxLoggingEvent.getThrowableStrRep();
            if (throwable != null) {
                writer.append(",\n  \"exception\" : [");
                for (int i = 0; i < throwable.length; ++i) {
                    if (i != 0) {
                        writer.append(", ");
                    }
                    ElasticSender.quote(throwable[i], writer);
                }
                writer.append("]");
            }
            writer.append(",\n  \"properties\" : { ");
            boolean first = true;
            for (Object key : paxLoggingEvent.getProperties().keySet()) {
                if (first) {
                    first = false;
                } else {
                    writer.append(", ");
                }
                ElasticSender.quote(key.toString(), writer);
                writer.append(": ");
                ElasticSender.quote(paxLoggingEvent.getProperties().get(key).toString(), writer);
            }
            writer.append(" }");
            writer.append("\n}");
            IndexRequest request = new IndexRequest().index(this.index).type(this.type).source(writer.toString()).create(true);
            this.sender.put(request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String formatDate(long timestamp) {
        return this.simpleDateFormat.format(new Date(timestamp));
    }
}

