/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.fusesource.fabric.fab.DependencyTree;
import org.fusesource.fabric.fab.TreeClassLoader;

public class DependencyClassLoader
extends URLClassLoader {
    private final DependencyTree tree;

    public static DependencyClassLoader newInstance(DependencyTree tree, List<DependencyTree> nonSharedDependencies, List<DependencyClassLoader> childClassLoaders, ClassLoader parent) throws MalformedURLException {
        ClassLoader parentClassLoader = childClassLoaders == null || childClassLoaders.isEmpty() ? parent : new TreeClassLoader(childClassLoaders, parent);
        ArrayList<DependencyTree> dependencies = new ArrayList<DependencyTree>();
        if (tree.isValidLibrary()) {
            dependencies.add(tree);
        }
        dependencies.addAll(nonSharedDependencies);
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (DependencyTree dependency : dependencies) {
            if (!dependency.isValidLibrary()) continue;
            URL u = dependency.getJarURL();
            urlList.add(u);
        }
        URL[] urls = urlList.toArray(new URL[urlList.size()]);
        return new DependencyClassLoader(tree, urls, parentClassLoader);
    }

    public DependencyClassLoader(DependencyTree tree, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.tree = tree;
    }

    public String toString() {
        return "ClassLoader[" + this.tree.getDependencyId() + ":" + this.tree.getVersion() + "]";
    }

    @Override
    public Class<?> loadClass(String s, boolean b) throws ClassNotFoundException {
        return super.loadClass(s, b);
    }
}

