/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.internal;

import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Constants;
import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.URLResource;
import aQute.lib.spring.SpringXMLType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.bundleplugin.BlueprintPlugin;
import org.fusesource.fabric.fab.osgi.internal.OverwriteMode;
import org.fusesource.fabric.fab.osgi.internal.VersionResolver;
import org.fusesource.fabric.fab.util.Files;
import org.fusesource.fabric.fab.util.Strings;
import org.ops4j.lang.NullArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BndUtils {
    private static final Logger LOG = LoggerFactory.getLogger(BndUtils.class);
    private static final Pattern INSTRUCTIONS_PATTERN = Pattern.compile("([a-zA-Z_0-9-]+)=([-!\"'()*+,.0-9A-Z_a-z%;:=/]+)");
    private static final String ALLOWED_PACKAGE_CLAUSES = Strings.join(Arrays.asList(Constants.directives), ",") + ",version";
    private static final String ANALYZER_PLUGIN_NAMES = BlueprintPlugin.class.getName() + "," + SpringXMLType.class.getName();

    private BndUtils() {
    }

    public static InputStream createBundle(InputStream jarInputStream, Properties instructions, String jarInfo) throws Exception {
        return BndUtils.createBundle(jarInputStream, instructions, jarInfo, OverwriteMode.KEEP, Collections.EMPTY_MAP, Collections.EMPTY_MAP, new HashSet<String>(), null);
    }

    public static InputStream createBundle(InputStream jarInputStream, Properties instructions, String jarInfo, OverwriteMode overwriteMode, Map<String, Object> embeddedResources, Map<String, Map<String, String>> extraImportPackages, Set<String> actualImports, VersionResolver versionResolver) throws Exception {
        Jar jar = BndUtils.createJar(jarInputStream, instructions, jarInfo, overwriteMode, embeddedResources, extraImportPackages, actualImports, versionResolver);
        return BndUtils.createInputStream(jar);
    }

    public static Jar createJar(InputStream jarInputStream, Properties instructions, String jarInfo, OverwriteMode overwriteMode, Map<String, Object> embeddedResources, Map<String, Map<String, String>> extraImportPackages, Set<String> actualImports, VersionResolver versionResolver) throws Exception {
        NullArgumentException.validateNotNull((Object)jarInputStream, (String)"Jar URL");
        NullArgumentException.validateNotNull((Object)instructions, (String)"Instructions");
        NullArgumentException.validateNotEmpty((String)jarInfo, (String)"Jar info");
        LOG.debug("Creating bundle for [" + jarInfo + "]");
        LOG.debug("Overwrite mode: " + (Object)((Object)overwriteMode));
        LOG.trace("Using instructions " + instructions);
        Jar jar = new Jar("dot", jarInputStream);
        Manifest manifest = jar.getManifest();
        if (manifest == null || OverwriteMode.KEEP != overwriteMode || manifest.getMainAttributes().getValue("Export-Package") == null && manifest.getMainAttributes().getValue("Import-Package") == null) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)instructions);
            properties.put("Generated-By-FAB-From", jarInfo);
            properties.put("-plugin", ANALYZER_PLUGIN_NAMES);
            Analyzer analyzer = new Analyzer();
            analyzer.setJar(jar);
            analyzer.setProperties(properties);
            for (Map.Entry<String, Object> entry : embeddedResources.entrySet()) {
                String path = entry.getKey();
                Object value = entry.getValue();
                Resource resource = BndUtils.toResource(value);
                if (resource == null) continue;
                jar.putResource(path, resource);
                try {
                    File file = BndUtils.toFile(value);
                    analyzer.addClasspath(file);
                }
                catch (IOException e) {
                    LOG.warn("Failed to get File for " + value + ". " + e, (Throwable)e);
                }
            }
            if (manifest != null && OverwriteMode.MERGE == overwriteMode) {
                analyzer.mergeManifest(manifest);
            }
            BndUtils.checkMandatoryProperties(analyzer, jar, jarInfo);
            analyzer.calcManifest();
            Attributes main = jar.getManifest().getMainAttributes();
            String importPackages = Strings.emptyIfNull(main.getValue("Import-Package"));
            Map values = new Analyzer().parseHeader(importPackages);
            if (versionResolver != null) {
                for (Map.Entry<Object, Object> entry : values.entrySet()) {
                    String version;
                    String packageName = (String)entry.getKey();
                    Map packageValues = (Map)entry.getValue();
                    if (packageValues.containsKey("version") || (version = versionResolver.resolvePackageVersion(packageName)) == null) continue;
                    packageValues.put("version", version);
                }
            }
            for (Map.Entry<Object, Object> entry : extraImportPackages.entrySet()) {
                Map original = (Map)values.get(entry.getKey());
                if (original == null) {
                    original = (Map)entry.getValue();
                } else {
                    original.putAll((Map)entry.getValue());
                }
                values.put(entry.getKey(), original);
            }
            String excludedPackagesText = main.getValue("FAB-Exclude-Import-Package");
            if (Strings.notEmpty(excludedPackagesText)) {
                StringTokenizer stringTokenizer = new StringTokenizer(excludedPackagesText);
                while (stringTokenizer.hasMoreTokens()) {
                    String expression = stringTokenizer.nextToken();
                    String ignore = expression;
                    if (ignore.endsWith("*")) {
                        while ((ignore = ignore.substring(0, ignore.length() - 1)).endsWith("*")) {
                        }
                        if (ignore.length() == 0) {
                            LOG.debug("Ignoring all imports due to %s value of %s", (Object)"FAB-Exclude-Import-Package", (Object)expression);
                            values.clear();
                            continue;
                        }
                        ArrayList packageNames = new ArrayList(values.keySet());
                        for (String packageName : packageNames) {
                            if (!packageName.equals(ignore) && !packageName.startsWith(ignore)) continue;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Ignoring package " + packageName + " due to " + "FAB-Exclude-Import-Package" + " value of " + expression);
                            }
                            values.remove(packageName);
                        }
                        continue;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Ignoring package " + ignore + " due to " + "FAB-Exclude-Import-Package" + " header");
                    }
                    values.remove(ignore);
                }
            }
            for (Map.Entry entry : values.entrySet()) {
                String packageName = (String)entry.getKey();
                Map map = (Map)entry.getValue();
                String res = (String)map.get("resolution:");
                if ("optional".equals(res) && !versionResolver.isPackageOptional(packageName)) {
                    map.remove("resolution:");
                    res = null;
                }
                if ("optional".equals(res)) continue;
                actualImports.add(packageName);
            }
            importPackages = Processor.printClauses((Map)values, (String)ALLOWED_PACKAGE_CLAUSES);
            if (Strings.notEmpty(importPackages)) {
                main.putValue("Import-Package", importPackages);
            }
            String string = Strings.emptyIfNull(main.getValue("Export-Package"));
            Map exports = new Analyzer().parseHeader(string);
            for (Map.Entry entry : exports.entrySet()) {
                String packageName = (String)entry.getKey();
                Map map = (Map)entry.getValue();
                String version = (String)map.get("version");
                if (version != null || (version = versionResolver.resolveExportPackageVersion(packageName)) == null) continue;
                map.put("version", version);
            }
            String string2 = Processor.printClauses((Map)exports, (String)ALLOWED_PACKAGE_CLAUSES);
            if (Strings.notEmpty(string2)) {
                main.putValue("Export-Package", string2);
            }
        }
        return jar;
    }

    private static File toFile(Object value) throws IOException {
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof URL) {
            return Files.urlToFile((URL)value, "fabric-analyser-jar-", ".jar");
        }
        throw new IllegalArgumentException("Cannot convert value " + value + " into a Resource. Expected File or URL");
    }

    protected static Resource toResource(Object value) {
        if (value instanceof File) {
            return new FileResource((File)value);
        }
        if (value instanceof URL) {
            return new URLResource((URL)value);
        }
        throw new IllegalArgumentException("Cannot convert value " + value + " into a Resource. Expected File or URL");
    }

    public static PipedInputStream createInputStream(final Jar jar) throws IOException {
        PipedInputStream pin = new PipedInputStream();
        final PipedOutputStream pout = new PipedOutputStream(pin);
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    jar.write((OutputStream)pout);
                }
                catch (Exception e) {
                    LOG.warn("Bundle cannot be generated");
                }
                finally {
                    try {
                        jar.close();
                        pout.close();
                    }
                    catch (IOException ignore) {
                        LOG.error("Bundle cannot be generated", (Throwable)ignore);
                    }
                }
            }
        }.start();
        return pin;
    }

    private static void checkMandatoryProperties(Analyzer analyzer, Jar jar, String symbolicName) {
        String exportPackage;
        String importPackage = analyzer.getProperty("Import-Package");
        if (importPackage == null || importPackage.trim().length() == 0) {
            analyzer.setProperty("Import-Package", "*;resolution:=optional");
        }
        if ((exportPackage = analyzer.getProperty("Export-Package")) == null || exportPackage.trim().length() == 0) {
            analyzer.setProperty("Export-Package", analyzer.calculateExportsFromContents(jar));
        }
        String localSymbolicName = analyzer.getProperty("Bundle-SymbolicName", symbolicName);
        analyzer.setProperty("Bundle-SymbolicName", BndUtils.generateSymbolicName(localSymbolicName));
    }

    private static String generateSymbolicName(String symbolicName) {
        return symbolicName.replaceAll("[^a-zA-Z_0-9.-]", "_");
    }

    public static Properties parseInstructions(String query) throws MalformedURLException {
        Properties instructions = new Properties();
        if (query != null) {
            try {
                String[] segments;
                for (String segment : segments = query.split("&")) {
                    if (segment.trim().length() <= 0) continue;
                    Matcher matcher = INSTRUCTIONS_PATTERN.matcher(segment);
                    if (matcher.matches()) {
                        instructions.setProperty(matcher.group(1), URLDecoder.decode(matcher.group(2), "UTF-8"));
                        continue;
                    }
                    throw new MalformedURLException("Invalid syntax for instruction [" + segment + "]. Take a look at http://www.aqute.biz/Code/Bnd.");
                }
            }
            catch (UnsupportedEncodingException e) {
                BndUtils.throwAsMalformedURLException("Could not retrieve the instructions from [" + query + "]", e);
            }
        }
        return instructions;
    }

    private static void throwAsMalformedURLException(String message, Exception cause) throws MalformedURLException {
        MalformedURLException exception = new MalformedURLException(message);
        exception.initCause(cause);
        throw exception;
    }
}

