/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.fab.osgi.internal;

import aQute.lib.osgi.Analyzer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.felix.utils.version.VersionCleaner;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.fusesource.fabric.fab.DependencyFilters;
import org.fusesource.fabric.fab.DependencyId;
import org.fusesource.fabric.fab.DependencyTree;
import org.fusesource.fabric.fab.DependencyTreeFilters;
import org.fusesource.fabric.fab.DependencyTreeResult;
import org.fusesource.fabric.fab.FabConfiguration;
import org.fusesource.fabric.fab.MavenResolver;
import org.fusesource.fabric.fab.ModuleDescriptor;
import org.fusesource.fabric.fab.ModuleRegistry;
import org.fusesource.fabric.fab.VersionedDependencyId;
import org.fusesource.fabric.fab.osgi.ServiceConstants;
import org.fusesource.fabric.fab.osgi.internal.Activator;
import org.fusesource.fabric.fab.osgi.internal.FabFacade;
import org.fusesource.fabric.fab.osgi.internal.Versions;
import org.fusesource.fabric.fab.osgi.util.FeatureCollector;
import org.fusesource.fabric.fab.util.Collectors;
import org.fusesource.fabric.fab.util.Filter;
import org.fusesource.fabric.fab.util.IOHelpers;
import org.fusesource.fabric.fab.util.Manifests;
import org.fusesource.fabric.fab.util.Maps;
import org.fusesource.fabric.fab.util.Strings;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.RepositoryException;
import org.sonatype.aether.graph.Dependency;

public class FabClassPathResolver
implements FabConfiguration {
    private static final transient Logger LOG = LoggerFactory.getLogger(FabClassPathResolver.class);
    private FabFacade connection;
    private Properties instructions;
    private Map<String, Object> embeddedResources;
    private HashMap<String, DependencyTree> dependenciesByPackage = new HashMap();
    private ModuleRegistry moduleRegistry;
    private List<String> bundleClassPath = new ArrayList<String>();
    private List<String> requireBundles = new ArrayList<String>();
    private Map<String, Map<String, String>> importPackages = new HashMap<String, Map<String, String>>();
    private boolean offline = false;
    protected final List<Filter<DependencyTree>> pruningFilters = new LinkedList<Filter<DependencyTree>>();
    HashSet<String> sharedFilterPatterns = new HashSet();
    HashSet<String> requireBundleFilterPatterns = new HashSet();
    HashSet<String> excludeDependencyFilterPatterns = new HashSet();
    HashSet<String> optionalDependencyPatterns = new HashSet();
    HashSet<String> importExportFilterPatterns = new HashSet();
    private Filter<DependencyTree> sharedFilter;
    private Filter<DependencyTree> requireBundleFilter;
    private Filter<DependencyTree> excludeDependencyFilter;
    private Filter<DependencyTree> optionalDependencyFilter;
    private Filter<DependencyTree> importExportFilter;
    private Collectors<String> installFeatures = new Collectors();
    private List<URI> installFeatureURLs = new LinkedList<URI>();
    private List<DependencyTree> nonSharedDependencies = new ArrayList<DependencyTree>();
    private List<DependencyTree> sharedDependencies = new ArrayList<DependencyTree>();
    private List<DependencyTree> installDependencies = new ArrayList<DependencyTree>();
    private List<DependencyTree> optionalDependencies = new ArrayList<DependencyTree>();
    private DependencyTree rootTree;
    private boolean processImportPackages = false;
    private MavenResolver resolver;
    private VersionedDependencyId moduleId;
    private Manifest manifest;

    public FabClassPathResolver(FabFacade connection, Properties instructions, Map<String, Object> embeddedResources) {
        this.connection = connection;
        this.instructions = instructions;
        this.embeddedResources = embeddedResources;
        this.moduleRegistry = Activator.registry;
        this.resolver = connection.getResolver();
    }

    public void resolve() throws RepositoryException, IOException, XmlPullParserException, BundleException {
        String bundleVersion;
        this.moduleId = this.connection.getVersionedDependencyId();
        if (this.moduleId == null) {
            return;
        }
        this.processFabInstructions();
        this.sharedFilter = DependencyTreeFilters.parseShareFilter(Strings.join(this.sharedFilterPatterns, " "));
        this.requireBundleFilter = DependencyTreeFilters.parseRequireBundleFilter(Strings.join(this.requireBundleFilterPatterns, " "));
        this.optionalDependencyFilter = DependencyTreeFilters.parseExcludeOptionalFilter(Strings.join(this.optionalDependencyPatterns, " "));
        this.excludeDependencyFilter = DependencyTreeFilters.parseExcludeFilter(Strings.join(this.excludeDependencyFilterPatterns, " "), this.optionalDependencyFilter);
        this.importExportFilter = DependencyTreeFilters.parse(Strings.join(this.importExportFilterPatterns, " "));
        this.bundleClassPath.addAll(Strings.splitAsList(this.getManifestProperty("Bundle-ClassPath"), ","));
        this.requireBundles.addAll(Strings.splitAsList(this.getManifestProperty("Require-Bundle"), ","));
        this.importPackages.putAll(new Analyzer().parseHeader(Strings.emptyIfNull(this.getManifestProperty("Import-Package"))));
        Filter<Dependency> optionalFilter = DependencyFilters.parseExcludeOptionalFilter(Strings.join(this.optionalDependencyPatterns, " "));
        Filter<Dependency> excludeFilter = DependencyFilters.parseExcludeFilter(Strings.join(this.excludeDependencyFilterPatterns, " "), optionalFilter);
        this.rootTree = this.connection.collectDependencyTree(this.offline, excludeFilter);
        for (Filter<DependencyTree> filter : this.pruningFilters) {
            DependencyTreeFilters.prune(this.rootTree, filter);
        }
        String name = this.getManifestProperty("Bundle-SymbolicName");
        if (name.length() <= 0) {
            name = this.rootTree.getBundleSymbolicName();
            this.instructions.setProperty("Bundle-SymbolicName", name);
        }
        if ((bundleVersion = this.getManifestProperty("Bundle-Version")).length() <= 0) {
            bundleVersion = VersionCleaner.clean((String)this.rootTree.getVersion());
            this.instructions.setProperty("Bundle-Version", bundleVersion);
        }
        for (String propertyName : ServiceConstants.FAB_PROPERTY_NAMES) {
            String value = this.getManifestProperty(propertyName);
            if (value == null) continue;
            this.instructions.setProperty(propertyName, value);
        }
        LOG.debug("Resolving Dependencies for: " + this.rootTree.getDependencyId());
        this.addDependencies(this.rootTree);
        ModuleRegistry.VersionedModule module = this.moduleRegistry.getVersionedModule(this.moduleId);
        if (module == null || module.getFile() != null) {
            this.registerModule();
        }
        this.resolveExtensions(this.rootTree, excludeFilter);
        for (DependencyTree dependencyTree : this.sharedDependencies) {
            if (this.requireBundleFilter.matches(dependencyTree)) {
                String bundleId = dependencyTree.getBundleSymbolicName();
                Version version = new Version(VersionCleaner.clean((String)dependencyTree.getVersion()));
                this.requireBundles.add(bundleId + ";bundle-version=" + version + "");
                continue;
            }
            if (!this.processImportPackages) continue;
            this.importAllExportedPackages(dependencyTree);
        }
        for (DependencyTree dependencyTree : this.nonSharedDependencies) {
            String path;
            String url;
            if (!dependencyTree.isValidLibrary() || (url = dependencyTree.getUrl()) == null || this.bundleClassPath.contains(path = dependencyTree.getGroupId() + "." + dependencyTree.getArtifactId() + ".jar")) continue;
            File file = new File(url);
            if (file.exists()) {
                this.embeddedResources.put(path, file);
            } else {
                this.embeddedResources.put(path, new URL(url));
            }
            this.addBundleClassPath(path);
        }
        this.nonSharedDependencies = this.filterOutDuplicates(this.nonSharedDependencies);
        this.sharedDependencies = this.filterOutDuplicates(this.sharedDependencies);
        this.installDependencies = this.filterOutDuplicates(this.installDependencies);
        this.optionalDependencies = this.filterOutDuplicates(this.optionalDependencies);
        LOG.debug("Required features:");
        for (String feature : this.getInstallFeatures()) {
            LOG.debug("- " + feature);
        }
        LOG.debug("nonSharedDependencies:");
        for (DependencyTree d : this.nonSharedDependencies) {
            LOG.debug("  " + d.getDependencyId());
        }
        LOG.debug("sharedDependencies:");
        for (DependencyTree d : this.sharedDependencies) {
            LOG.debug("  " + d.getDependencyId());
        }
        LOG.debug("installDependencies:");
        for (DependencyTree d : this.installDependencies) {
            LOG.debug("  " + d.getDependencyId());
        }
        LOG.debug("resolved: bundleClassPath: " + Strings.join(this.bundleClassPath, "\t\n"));
        LOG.debug("resolved: requireBundles: " + Strings.join(this.requireBundles, "\t\n"));
        LOG.debug("resolved: importPackages: " + Strings.join(this.importPackages.keySet(), "\t\n"));
        this.instructions.setProperty("Bundle-ClassPath", Strings.join(this.bundleClassPath, ","));
        this.instructions.setProperty("Require-Bundle", Strings.join(this.requireBundles, ","));
        this.instructions.setProperty("FAB-Id", this.moduleId.toString());
        if (!this.sharedFilterPatterns.isEmpty()) {
            this.instructions.setProperty("FAB-Provided-Dependency", Strings.join(this.sharedFilterPatterns, " "));
        }
        if (!this.requireBundleFilterPatterns.isEmpty()) {
            this.instructions.setProperty("FAB-Dependency-Require-Bundle", Strings.join(this.requireBundleFilterPatterns, " "));
        }
        if (!this.excludeDependencyFilterPatterns.isEmpty()) {
            this.instructions.setProperty("FAB-Exclude-Dependency", Strings.join(this.excludeDependencyFilterPatterns, " "));
        }
        if (!this.optionalDependencyPatterns.isEmpty()) {
            this.instructions.setProperty("FAB-Include-Optional-Dependency", Strings.join(this.optionalDependencyPatterns, " "));
        }
    }

    protected void processFabInstructions() {
        this.sharedFilterPatterns.addAll(Strings.splitAndTrimAsList(Strings.emptyIfNull(this.getManifestProperty("FAB-Provided-Dependency")), "\\s+"));
        this.requireBundleFilterPatterns.addAll(Strings.splitAndTrimAsList(Strings.emptyIfNull(this.getManifestProperty("FAB-Dependency-Require-Bundle")), "\\s+"));
        this.excludeDependencyFilterPatterns.addAll(Strings.splitAndTrimAsList(Strings.emptyIfNull(this.getManifestProperty("FAB-Exclude-Dependency")), "\\s+"));
        this.optionalDependencyPatterns.addAll(Strings.splitAndTrimAsList(Strings.emptyIfNull(this.getManifestProperty("FAB-Include-Optional-Dependency")), "\\s+"));
        this.importExportFilterPatterns.addAll(Strings.splitAndTrimAsList(Strings.emptyIfNull(this.getManifestProperty("FAB-Import-Dependency-Exports")), "\\s+"));
        this.installFeatures.addCollection(Strings.splitAndTrimAsList(Strings.emptyIfNull(this.getManifestProperty("FAB-Require-Feature")), "\\s+"));
        for (String url : Strings.splitAndTrimAsList(Strings.emptyIfNull(this.getManifestProperty("FAB-Require-Feature-URL")), "\\s+")) {
            try {
                this.installFeatureURLs.add(new URI(url));
            }
            catch (URISyntaxException e) {
                LOG.warn("Invalid URI {} listed in {} will be ignored", new Object[]{url, "FAB-Require-Feature-URL"});
            }
        }
    }

    public List<DependencyTree> getInstallDependencies() {
        return this.installDependencies;
    }

    public List<DependencyTree> getSharedDependencies() {
        return this.sharedDependencies;
    }

    public List<DependencyTree> getNonSharedDependencies() {
        return this.nonSharedDependencies;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public DependencyTree getRootTree() {
        return this.rootTree;
    }

    public Filter<DependencyTree> getOptionalDependencyFilter() {
        return this.optionalDependencyFilter;
    }

    private List<DependencyTree> filterOutDuplicates(List<DependencyTree> list) {
        LinkedHashMap<DependencyId, DependencyTree> map = new LinkedHashMap<DependencyId, DependencyTree>();
        for (DependencyTree tree : list) {
            if (map.containsKey(tree.getDependencyId())) continue;
            map.put(tree.getDependencyId(), tree);
        }
        return new ArrayList<DependencyTree>(map.values());
    }

    private void registerModule() throws IOException, XmlPullParserException {
        try {
            Properties moduleProperties = new Properties();
            for (String key : ModuleDescriptor.FAB_MODULE_PROPERTIES) {
                String value = this.getManifestProperty("FAB-" + key);
                if (!Strings.notEmpty(value)) continue;
                moduleProperties.setProperty(key, value);
            }
            if (!moduleProperties.containsKey("Id")) {
                moduleProperties.setProperty("Id", this.moduleId.toString());
            }
            if (!moduleProperties.containsKey("Name")) {
                moduleProperties.setProperty("Name", this.moduleId.getArtifactId());
            }
            if (!moduleProperties.containsKey("Description")) {
                moduleProperties.setProperty("Description", Strings.emptyIfNull(this.connection.getProjectDescription()));
            }
            ModuleDescriptor descriptor = ModuleDescriptor.fromProperties(moduleProperties);
            this.moduleRegistry.add(descriptor);
        }
        catch (Exception e) {
            System.err.println("Failed to register the fabric module for: " + this.moduleId);
            e.printStackTrace();
        }
    }

    protected void resolveExtensions(DependencyTree root, Filter<Dependency> excludeDependencyFilter) throws IOException, RepositoryException, XmlPullParserException {
        ModuleRegistry.VersionedModule module = this.moduleRegistry.getVersionedModule(this.moduleId);
        if (module != null) {
            Map<String, ModuleRegistry.VersionedModule> availableExtensions = module.getAvailableExtensions();
            String extensionsString = "";
            for (String enabledExtension : module.getEnabledExtensions()) {
                ModuleRegistry.VersionedModule extensionModule = availableExtensions.get(enabledExtension);
                if (extensionModule == null) continue;
                VersionedDependencyId id = extensionModule.getId();
                DependencyTreeResult result = this.resolver.collectDependencies(id, this.offline, excludeDependencyFilter);
                if (result != null) {
                    DependencyTree tree = result.getTree();
                    this.sharedFilterPatterns.addAll(Strings.splitAndTrimAsList(Strings.emptyIfNull(tree.getManifestEntry("FAB-Provided-Dependency")), "\\s+"));
                    this.requireBundleFilterPatterns.addAll(Strings.splitAndTrimAsList(Strings.emptyIfNull(tree.getManifestEntry("FAB-Dependency-Require-Bundle")), "\\s+"));
                    this.excludeDependencyFilterPatterns.addAll(Strings.splitAndTrimAsList(Strings.emptyIfNull(tree.getManifestEntry("FAB-Exclude-Dependency")), "\\s+"));
                    this.optionalDependencyPatterns.addAll(Strings.splitAndTrimAsList(Strings.emptyIfNull(tree.getManifestEntry("FAB-Include-Optional-Dependency")), "\\s+"));
                    this.sharedFilter = DependencyTreeFilters.parseShareFilter(Strings.join(this.sharedFilterPatterns, " "));
                    this.requireBundleFilter = DependencyTreeFilters.parseRequireBundleFilter(Strings.join(this.requireBundleFilterPatterns, " "));
                    this.optionalDependencyFilter = DependencyTreeFilters.parseExcludeOptionalFilter(Strings.join(this.optionalDependencyPatterns, " "));
                    this.excludeDependencyFilter = DependencyTreeFilters.parseExcludeFilter(Strings.join(this.excludeDependencyFilterPatterns, " "), this.optionalDependencyFilter);
                    LOG.debug("Adding extension: " + tree.getDependencyId());
                    if (extensionsString.length() != 0) {
                        extensionsString = extensionsString + " ";
                    }
                    extensionsString = extensionsString + id;
                    this.addChildDependency(tree);
                    continue;
                }
                LOG.debug("Could not resolve extension: " + id);
            }
            if (extensionsString.length() != 0) {
                this.instructions.put("FAB-Enabled-Extensions", extensionsString);
            }
        }
    }

    protected void importAllExportedPackages(DependencyTree dependencyTree) {
        try {
            String text = dependencyTree.getManifestEntry("Export-Package");
            if (text != null && text.length() > 0) {
                Map map = new Analyzer().parseHeader(text);
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    Map values = (Map)entry.getValue();
                    Map<String, String> current = this.importPackages.get(key);
                    if (current == null) {
                        current = new HashMap<String, String>();
                        this.importPackages.put(key, current);
                    }
                    Maps.putAll(current, values, ServiceConstants.IMPORT_PACKAGE_PARAMETERS);
                    String specVersion = current.get("specification-version");
                    if (specVersion == null) continue;
                    current.remove("specification-version");
                    String version = current.get("version");
                    if (version == null) {
                        current.put("version", this.connection.toVersionRange(specVersion));
                        continue;
                    }
                    LOG.warn("Have specification-version " + specVersion + " and version: " + version + " for dependency: " + dependencyTree + " will ignore specification-version");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to find export packages for " + dependencyTree + ". " + e, (Throwable)e);
        }
        List<DependencyTree> children = dependencyTree.getChildren();
        for (DependencyTree child : children) {
            if (child.isOptional()) continue;
            this.importAllExportedPackages(child);
        }
    }

    public boolean isProcessImportPackages() {
        return this.processImportPackages;
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                File jarFile = this.connection.getJarFile();
                if (jarFile != null && jarFile.exists()) {
                    this.manifest = Manifests.getManifest(jarFile);
                }
            }
            catch (IOException e) {
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    public String getManifestProperty(String name) {
        String answer = null;
        Manifest manifest = this.getManifest();
        answer = manifest != null ? manifest.getMainAttributes().getValue(name) : this.instructions.getProperty(name, "");
        if (answer == null) {
            answer = "";
        }
        return answer;
    }

    protected void addPackagesRecursive(DependencyTree tree) {
        this.addPackages(tree);
        List<DependencyTree> children = tree.getChildren();
        for (DependencyTree child : children) {
            if (this.isExcludedDependency(child)) continue;
            if (this.isIncludedOptionaDependency(child)) {
                this.addPackages(child);
                List<DependencyTree> descendants = child.getDescendants();
                for (DependencyTree descendant : descendants) {
                    if (this.isExcludedDependency(descendant)) continue;
                    this.addPackages(descendant);
                }
                continue;
            }
            this.addPackagesRecursive(child);
        }
    }

    protected void addPackages(DependencyTree tree) {
        try {
            for (String p : tree.getPackages()) {
                DependencyTree current = this.dependenciesByPackage.get(p);
                if (current != null) {
                    String version2;
                    String version1 = Versions.getOSGiPackageVersion(current, p);
                    if (!Versions.isVersionOlder(version1, version2 = Versions.getOSGiPackageVersion(tree, p))) continue;
                    current.addHiddenPackage(p);
                    if (current.isAllPackagesHidden() && !current.isBundleFragment()) {
                        LOG.debug("Dependency now hidden: " + current + " due to " + tree);
                    }
                }
                this.dependenciesByPackage.put(p, tree);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void addDependencies(DependencyTree tree) throws IOException {
        this.addPackagesRecursive(tree);
        List<DependencyTree> children = tree.getChildren();
        for (DependencyTree child : children) {
            this.addChildDependency(child);
        }
    }

    private void addChildDependency(DependencyTree child) throws IOException {
        String dependencyId = child.getDependencyId().toString();
        if (this.isExcludedDependency(child)) {
            LOG.debug("Excluded dependency: " + dependencyId);
        } else if (this.isIncludedOptionaDependency(child)) {
            this.addOptionalDependency(child);
        } else if (this.isSharedOrRequired(child)) {
            this.addSharedDependency(child);
        } else {
            LOG.debug("Added non-shared dependency: " + dependencyId);
            this.nonSharedDependencies.add(child);
            this.addDependencies(child);
        }
    }

    protected boolean isIncludedOptionaDependency(DependencyTree child) {
        return this.optionalDependencyFilter.matches(child);
    }

    protected boolean isExcludedDependency(DependencyTree child) {
        return this.excludeDependencyFilter.matches(child) || child.isAllPackagesHidden() && !child.isBundleFragment();
    }

    protected boolean isSharedOrRequired(DependencyTree child) {
        return this.sharedFilter.matches(child) || this.requireBundleFilter.matches(child);
    }

    private void addOptionalDependency(DependencyTree tree) {
        LOG.debug("Added optional dependency: " + tree.getDependencyId());
        this.optionalDependencies.add(tree);
        List<DependencyTree> list = tree.getDescendants();
        for (DependencyTree child : list) {
            if (this.isExcludedDependency(child)) {
                LOG.debug("Excluded transitive dependency: " + child.getDependencyId());
                continue;
            }
            this.addOptionalDependency(child);
        }
    }

    protected void addSharedDependency(DependencyTree tree) throws IOException {
        if (!this.isInstallProvidedBundleDependencies() && this.connection.isInstalled(tree)) {
            LOG.debug("Skipping {} since it is already installed", (Object)tree.getDependencyId());
            return;
        }
        LOG.debug("Added shared dependency: " + tree.getDependencyId());
        this.sharedDependencies.add(tree);
        boolean importExports = false;
        if (this.connection.isIncludeSharedResources()) {
            importExports = this.includeSharedResources(tree);
        }
        if (!importExports && this.importExportFilter.matches(tree)) {
            importExports = true;
        }
        if (importExports) {
            this.importAllExportedPackages(tree);
        }
        List<DependencyTree> list = tree.getChildren();
        for (DependencyTree child : list) {
            if (this.isExcludedDependency(child)) {
                LOG.debug("Excluded transitive dependency: " + child.getDependencyId());
                continue;
            }
            if (this.isIncludedOptionaDependency(child)) {
                LOG.debug("Excluded optional transitive dependency: " + child.getDependencyId());
                continue;
            }
            this.addSharedDependency(child);
            if (!this.importExportFilter.matches(child)) continue;
            this.importAllExportedPackages(child);
        }
        this.addInstallDependencies(tree);
    }

    protected boolean includeSharedResources(DependencyTree tree) throws IOException {
        File file;
        boolean answer = false;
        if (tree.isValidLibrary() && (file = tree.getJarFile()).exists()) {
            File sharedResourceFile = null;
            ZipOutputStream out = null;
            JarFile jarFile = new JarFile(file);
            String[] sharedPaths = this.connection.getConfiguration().getSharedResourcePaths();
            String pathPrefix = tree.getGroupId() + "." + tree.getArtifactId() + "-resources";
            String path = pathPrefix + ".jar";
            if (sharedPaths != null) {
                for (String sharedPath : sharedPaths) {
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        String name = jarEntry.getName();
                        if (!name.startsWith(sharedPath)) continue;
                        if (sharedResourceFile == null) {
                            sharedResourceFile = File.createTempFile(pathPrefix + "-", ".jar");
                            out = new JarOutputStream(new FileOutputStream(sharedResourceFile));
                        }
                        ((JarOutputStream)out).putNextEntry(new ZipEntry(jarEntry.getName()));
                        if (!jarEntry.isDirectory()) {
                            IOHelpers.writeTo(out, jarFile.getInputStream(jarEntry), false);
                        }
                        out.closeEntry();
                    }
                }
            }
            if (sharedResourceFile != null) {
                out.finish();
                out.close();
                if (!this.bundleClassPath.contains(path)) {
                    this.embeddedResources.put(path, sharedResourceFile);
                    this.addBundleClassPath(path);
                    LOG.info("Adding shared resources jar: " + path);
                    answer = true;
                }
            }
        }
        return answer;
    }

    protected void addBundleClassPath(String path) {
        if (this.bundleClassPath.isEmpty()) {
            this.bundleClassPath.add(".");
        }
        this.bundleClassPath.add(path);
    }

    protected void addInstallDependencies(DependencyTree node) {
        if (node.isBundle()) {
            List<DependencyTree> list = node.getChildren();
            for (DependencyTree child : list) {
                if (this.isExcludedDependency(child) || child.isThisOrDescendantOptional() && this.isIncludedOptionaDependency(child)) continue;
                this.addInstallDependencies(child);
            }
        }
        this.installDependencies.add(node);
    }

    public Collection<String> getInstallFeatures() {
        return this.installFeatures.getCollection();
    }

    public Collection<URI> getInstallFeatureURLs() {
        return this.installFeatureURLs;
    }

    public Map<String, Map<String, String>> getExtraImportPackages() {
        return this.importPackages;
    }

    public Map<String, DependencyTree> getDependenciesByPackage() {
        return this.dependenciesByPackage;
    }

    public List<DependencyTree> getOptionalDependencies() {
        return this.optionalDependencies;
    }

    public void addPruningFilter(Filter<DependencyTree> filter) {
        this.pruningFilters.add(filter);
        if (filter instanceof FeatureCollector) {
            this.installFeatures.addCollector((FeatureCollector)((Object)filter));
        }
    }

    protected boolean isInstallProvidedBundleDependencies() {
        return Boolean.valueOf(this.getManifestProperty("FAB-Install-Provided-Bundle-Dependencies"));
    }

    @Override
    public String getStringProperty(String name) {
        return this.getManifestProperty(name);
    }
}

