/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.zookeeper.KeeperException;
import org.codehaus.jackson.map.ObjectMapper;
import org.fusesource.fabric.boot.commands.support.FabricCommand;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.IZKClient;

@Command(name="cluster-list", scope="fabric", description="Lists all ActiveMQ message brokers in the fabric, enabling you to see which brokers are grouped into clusters.")
public class ClusterList
extends FabricCommand {
    protected static String CLUSTER_PREFIX = "/fabric/registry/clusters";
    @Argument(required=false, description="Path of the fabric registry node (Zookeeper registry node) to list. Relative paths are evaluated relative to the base node, /fabric/registry/clusters. If not specified, all clusters are listed.")
    String path = "";

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        String realPath = this.path;
        if (!realPath.startsWith("/")) {
            realPath = CLUSTER_PREFIX;
            if (this.path.length() > 0) {
                realPath = realPath + "/" + this.path;
            }
        }
        this.printCluster(realPath, System.out);
        return null;
    }

    protected void printCluster(String dir, PrintStream out) throws InterruptedException, KeeperException, IOException, URISyntaxException {
        out.println(String.format("%-30s %-30s %-10s %s", "[cluster]", "[id]", "[master]", "[services]"));
        this.printChildren(dir, dir, out);
    }

    private void printChildren(String rootDir, String dir, PrintStream out) throws KeeperException, InterruptedException, IOException, URISyntaxException {
        if (this.getZooKeeper().exists(dir) == null) {
            return;
        }
        List children = this.getZooKeeper().getChildren(dir, false);
        boolean master = true;
        for (String child : children) {
            String text;
            String childDir = dir + "/" + child;
            byte[] data = this.getZooKeeper().getData(childDir);
            if (data != null && data.length > 0 && !(text = new String(data).trim()).isEmpty()) {
                String clusterName = dir;
                if (clusterName.startsWith(rootDir)) {
                    clusterName = clusterName.substring(rootDir.length());
                }
                if (clusterName.startsWith("/")) {
                    clusterName = clusterName.substring(1);
                }
                if (clusterName.length() == 0) {
                    clusterName = ".";
                }
                ObjectMapper mapper = new ObjectMapper();
                Map map = (Map)mapper.readValue(data, HashMap.class);
                Object id = this.value(map, "id", "container");
                Object services = this.value(map, "services");
                if (services != null) {
                    String serviceText = services.toString();
                    if (serviceText.startsWith("[") && serviceText.endsWith("]")) {
                        serviceText = serviceText.substring(1, serviceText.length() - 1);
                    }
                    services = ZooKeeperUtils.getSubstitutedData((IZKClient)this.getZooKeeper(), (String)serviceText);
                }
                out.println(String.format("%-30s %-30s %-10s %s", clusterName, id, master, services));
                master = false;
            }
            this.printChildren(rootDir, childDir, out);
        }
    }

    protected Object value(Map<String, Object> map, String ... keys) {
        for (String key : keys) {
            Object value = map.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

