/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CompleterValues;
import org.apache.felix.gogo.commands.Option;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.api.Version;
import org.fusesource.fabric.boot.commands.support.FabricCommand;

@Command(name="profile-display", scope="fabric", description="Displays information about the specified version of the specified profile (where the version defaults to the current default version)")
public class ProfileDisplay
extends FabricCommand {
    @Option(name="--version", description="Select a specific profile version. Defaults to the current default version.")
    private String version;
    @Option(name="--overlay", aliases={"-o"}, description="Shows the effective profile settings, taking into account the settings inherited from parent profiles.")
    private Boolean overlay = false;
    @Argument(index=0, required=true, name="profile", description="The name of the profile.")
    @CompleterValues(index=0)
    private String name;

    protected Object doExecute() throws Exception {
        this.checkFabricAvailable();
        Version ver = this.version != null ? this.fabricService.getVersion(this.version) : this.fabricService.getDefaultVersion();
        for (Profile profile : ver.getProfiles()) {
            if (!this.name.equals(profile.getId())) continue;
            this.displayProfile(profile);
        }
        return null;
    }

    private String toString(Container[] containers) {
        StringBuffer rc = new StringBuffer();
        for (Container container : containers) {
            rc.append(container.getId());
            rc.append(" ");
        }
        return rc.toString().trim();
    }

    private static void printConfigList(String header, PrintStream out, List<String> list) {
        out.println(header);
        for (String str : list) {
            out.printf("\t%s\n", str);
        }
        out.println();
    }

    private void displayProfile(Profile p) {
        PrintStream output = this.session.getConsole();
        output.println("Profile id: " + p.getId());
        output.println("Version   : " + p.getVersion());
        output.println("Parents   : " + this.toString(p.getParents()));
        output.printf("Associated Containers : %s\n", this.toString(p.getAssociatedContainers()));
        Profile profile = this.overlay != false ? p.getOverlay() : p;
        Map configuration = profile.getConfigurations();
        Map agentConfiguration = profile.getContainerConfiguration();
        ArrayList<String> agentProperties = new ArrayList<String>();
        ArrayList<String> systemProperties = new ArrayList<String>();
        ArrayList<String> configProperties = new ArrayList<String>();
        for (Map.Entry entry : agentConfiguration.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.contains(",")) {
                value = "\t" + value.replace(",", ",\n\t\t");
            }
            if (key.startsWith("system.")) {
                systemProperties.add("  " + key.substring("system.".length()) + " = " + value);
                continue;
            }
            if (key.startsWith("config.")) {
                configProperties.add("  " + key.substring("config.".length()) + " = " + value);
                continue;
            }
            if (key.startsWith("feature.") || key.startsWith("repository") || key.startsWith("bundle.") || key.startsWith("fab.")) continue;
            agentProperties.add("  " + key + " = " + value);
        }
        if (configuration.containsKey(AGENT_PID)) {
            output.println("\nContainer settings");
            output.println("----------------------------");
            if (profile.getRepositories().size() > 0) {
                ProfileDisplay.printConfigList("Repositories : ", output, profile.getRepositories());
            }
            if (profile.getFeatures().size() > 0) {
                ProfileDisplay.printConfigList("Features : ", output, profile.getFeatures());
            }
            if (profile.getBundles().size() > 0) {
                ProfileDisplay.printConfigList("Bundles : ", output, profile.getBundles());
            }
            if (profile.getFabs().size() > 0) {
                ProfileDisplay.printConfigList("Fabs : ", output, profile.getFabs());
            }
            if (agentProperties.size() > 0) {
                ProfileDisplay.printConfigList("Agent Properties : ", output, agentProperties);
            }
            if (systemProperties.size() > 0) {
                ProfileDisplay.printConfigList("System Properties : ", output, systemProperties);
            }
            if (configProperties.size() > 0) {
                ProfileDisplay.printConfigList("Config Properties : ", output, configProperties);
            }
            configuration.remove(AGENT_PID);
        }
        output.println("\nConfiguration details");
        output.println("----------------------------");
        for (Map.Entry cfg : configuration.entrySet()) {
            output.println("PID: " + (String)cfg.getKey());
            for (Map.Entry values : ((Map)cfg.getValue()).entrySet()) {
                output.println("  " + (String)values.getKey() + " " + (String)values.getValue());
            }
            output.println("\n");
        }
    }
}

