/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;

public class TermsFilter
extends Filter {
    Set<Term> terms = new TreeSet<Term>();

    public void addTerm(Term term) {
        this.terms.add(term);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        OpenBitSet result = new OpenBitSet(reader.maxDoc());
        TermDocs td = reader.termDocs();
        try {
            for (Term term : this.terms) {
                td.seek(term);
                while (td.next()) {
                    result.set(td.doc());
                }
            }
        }
        finally {
            td.close();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        TermsFilter test = (TermsFilter)obj;
        return this.terms == test.terms || this.terms != null && ((Object)this.terms).equals(test.terms);
    }

    public int hashCode() {
        int hash = 9;
        for (Term term : this.terms) {
            hash = 31 * hash + term.hashCode();
        }
        return hash;
    }
}

