/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.List;
import org.elasticsearch.common.aopalliance.intercept.MethodInvocation;
import org.elasticsearch.common.inject.internal.cglib.proxy.MethodInterceptor;
import org.elasticsearch.common.inject.internal.cglib.proxy.MethodProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InterceptorStackCallback
implements MethodInterceptor {
    final org.elasticsearch.common.aopalliance.intercept.MethodInterceptor[] interceptors;
    final Method method;

    public InterceptorStackCallback(Method method, List<org.elasticsearch.common.aopalliance.intercept.MethodInterceptor> interceptors) {
        this.method = method;
        this.interceptors = interceptors.toArray(new org.elasticsearch.common.aopalliance.intercept.MethodInterceptor[interceptors.size()]);
    }

    @Override
    public Object intercept(Object proxy, Method method, Object[] arguments, MethodProxy methodProxy) throws Throwable {
        return new InterceptedMethodInvocation(proxy, methodProxy, arguments).proceed();
    }

    class InterceptedMethodInvocation
    implements MethodInvocation {
        final Object proxy;
        final Object[] arguments;
        final MethodProxy methodProxy;
        int index = -1;

        public InterceptedMethodInvocation(Object proxy, MethodProxy methodProxy, Object[] arguments) {
            this.proxy = proxy;
            this.methodProxy = methodProxy;
            this.arguments = arguments;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object proceed() throws Throwable {
            try {
                ++this.index;
                Object object = this.index == InterceptorStackCallback.this.interceptors.length ? this.methodProxy.invokeSuper(this.proxy, this.arguments) : InterceptorStackCallback.this.interceptors[this.index].invoke(this);
                return object;
            }
            finally {
                --this.index;
            }
        }

        public Method getMethod() {
            return InterceptorStackCallback.this.method;
        }

        public Object[] getArguments() {
            return this.arguments;
        }

        public Object getThis() {
            return this.proxy;
        }

        public AccessibleObject getStaticPart() {
            return this.getMethod();
        }
    }
}

