/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.common.util.concurrent.ThreadSafe;

@ThreadSafe
public class CopyOnWriteMap<K, V>
implements ConcurrentMap<K, V> {
    private volatile Map<K, V> map = new HashMap();

    @Override
    public void clear() {
        this.map = new HashMap();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        CopyOnWriteMap copyOnWriteMap = this;
        synchronized (copyOnWriteMap) {
            Map<K, V> copyMap = this.copyMap();
            V put = copyMap.put(key, value);
            this.map = copyMap;
            return put;
        }
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        Map<? extends K, ? extends V> copyMap = this.copyMap();
        copyMap.putAll(t);
        this.map = copyMap;
    }

    @Override
    public synchronized V remove(Object key) {
        Map<K, V> copyMap = this.copyMap();
        V remove = copyMap.remove(key);
        this.map = copyMap;
        return remove;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    private Map<K, V> copyMap() {
        return new HashMap<K, V>(this.map);
    }

    @Override
    public synchronized V putIfAbsent(K key, V value) {
        V v = this.map.get(key);
        if (v == null) {
            Map<K, V> copyMap = this.copyMap();
            copyMap.put(key, value);
            this.map = copyMap;
        }
        return v;
    }

    @Override
    public synchronized boolean remove(Object key, Object value) {
        V v = this.map.get(key);
        if (v != null && v.equals(value)) {
            Map<K, V> copyMap = this.copyMap();
            copyMap.remove(key);
            this.map = copyMap;
            return true;
        }
        return false;
    }

    @Override
    public synchronized V replace(K key, V value) {
        V v = this.map.get(key);
        if (v != null) {
            Map<K, V> copyMap = this.copyMap();
            copyMap.put(key, value);
            this.map = copyMap;
        }
        return v;
    }

    @Override
    public synchronized boolean replace(K key, V oldValue, V newValue) {
        V v = this.map.get(key);
        if (v != null && v.equals(oldValue)) {
            Map<K, V> copyMap = this.copyMap();
            copyMap.put(key, newValue);
            this.map = copyMap;
            return true;
        }
        return false;
    }
}

