/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.util.concurrent.Immutable;
import org.elasticsearch.index.mapper.FieldMapper;

@Immutable
public class FieldMappers
implements Iterable<FieldMapper> {
    private final ImmutableList<FieldMapper> fieldMappers;

    public FieldMappers() {
        this.fieldMappers = ImmutableList.of();
    }

    public FieldMappers(FieldMapper fieldMapper) {
        this(new FieldMapper[]{fieldMapper});
    }

    public FieldMappers(FieldMapper[] fieldMappers) {
        if (fieldMappers == null) {
            fieldMappers = new FieldMapper[]{};
        }
        this.fieldMappers = ImmutableList.copyOf(Iterators.forArray(fieldMappers));
    }

    public FieldMappers(ImmutableList<FieldMapper> fieldMappers) {
        this.fieldMappers = fieldMappers;
    }

    public FieldMapper mapper() {
        if (this.fieldMappers.isEmpty()) {
            return null;
        }
        return (FieldMapper)this.fieldMappers.get(0);
    }

    public boolean isEmpty() {
        return this.fieldMappers.isEmpty();
    }

    public ImmutableList<FieldMapper> mappers() {
        return this.fieldMappers;
    }

    @Override
    public UnmodifiableIterator<FieldMapper> iterator() {
        return this.fieldMappers.iterator();
    }

    public FieldMappers concat(FieldMapper mapper) {
        return new FieldMappers((ImmutableList<FieldMapper>)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.fieldMappers)).add(mapper)).build());
    }

    public FieldMappers concat(FieldMappers mappers) {
        return new FieldMappers((ImmutableList<FieldMapper>)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.fieldMappers)).addAll((Iterable)mappers)).build());
    }

    public FieldMappers remove(List<FieldMapper> mappers) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (FieldMapper fieldMapper : this.fieldMappers) {
            boolean found = false;
            for (FieldMapper mapper : mappers) {
                if (!fieldMapper.equals(mapper)) continue;
                found = true;
            }
            if (found) continue;
            builder.add(fieldMapper);
        }
        return new FieldMappers((ImmutableList<FieldMapper>)builder.build());
    }

    public FieldMappers remove(FieldMapper mapper) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        for (FieldMapper fieldMapper : this.fieldMappers) {
            if (fieldMapper.equals(mapper)) continue;
            builder.add(fieldMapper);
        }
        return new FieldMappers((ImmutableList<FieldMapper>)builder.build());
    }
}

