/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.Uid;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class ParentFieldMapper
extends AbstractFieldMapper<Uid>
implements org.elasticsearch.index.mapper.ParentFieldMapper {
    public static final String CONTENT_TYPE = "_parent";
    private final String type;

    protected ParentFieldMapper(String name, String indexName, String type) {
        super(new FieldMapper.Names(name, indexName, indexName, name), Defaults.INDEX, Field.Store.YES, Defaults.TERM_VECTOR, 1.0f, true, true, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        this.type = type;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    protected Field parseCreateField(ParseContext context) throws IOException {
        if (context.parser().currentName() != null && context.parser().currentName().equals(CONTENT_TYPE)) {
            String parentId = context.parser().text();
            return new Field(this.names.indexName(), Uid.createUid(context.stringBuilder(), this.type, parentId), this.store, this.index);
        }
        String parsedParentId = context.doc().get(CONTENT_TYPE);
        if (context.externalValueSet()) {
            String parentId = (String)context.externalValue();
            if (parsedParentId == null) {
                if (parentId == null) {
                    throw new MapperParsingException("No parent id provided, not within the document, and not externally");
                }
                return new Field(this.names.indexName(), Uid.createUid(context.stringBuilder(), this.type, parentId), this.store, this.index);
            }
            if (parentId != null && !parsedParentId.equals(Uid.createUid(context.stringBuilder(), this.type, parentId))) {
                throw new MapperParsingException("Parent id mismatch, document value is [" + Uid.createUid(parsedParentId).id() + "], while external value is [" + parentId + "]");
            }
        }
        return null;
    }

    @Override
    public Uid value(Fieldable field) {
        return Uid.createUid(field.stringValue());
    }

    @Override
    public Uid valueFromString(String value) {
        return Uid.createUid(value);
    }

    @Override
    public String valueAsString(Fieldable field) {
        return field.stringValue();
    }

    @Override
    public Object valueForSearch(Fieldable field) {
        String fieldValue = field.stringValue();
        if (fieldValue == null) {
            return null;
        }
        int index = fieldValue.indexOf(35);
        if (index == -1) {
            return fieldValue;
        }
        return fieldValue.substring(index + 1);
    }

    @Override
    public String indexedValue(String value) {
        if (value.indexOf(35) == -1) {
            return Uid.createUid(this.type, value);
        }
        return value;
    }

    @Override
    public Term term(String type, String id) {
        return this.term(Uid.createUid(type, id));
    }

    @Override
    public Term term(String uid) {
        return new Term(this.names.indexName(), uid);
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(CONTENT_TYPE);
        builder.field("type", this.type);
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends XContentMapper.Builder<Builder, ParentFieldMapper> {
        protected String indexName;
        private String type;

        public Builder() {
            super(ParentFieldMapper.CONTENT_TYPE);
            this.indexName = this.name;
        }

        public Builder type(String type) {
            this.type = type;
            return (Builder)this.builder;
        }

        @Override
        public ParentFieldMapper build(XContentMapper.BuilderContext context) {
            if (this.type == null) {
                throw new MapperParsingException("Parent mapping must contain the parent type");
            }
            return new ParentFieldMapper(this.name, this.indexName, this.type);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_parent";
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
    }
}

