/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.query.IndexQueryParser;
import org.elasticsearch.index.query.IndexQueryParserFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class IndexQueryParserService
extends AbstractIndexComponent {
    private final IndexQueryParser defaultIndexQueryParser;
    private final Map<String, IndexQueryParser> indexQueryParsers;

    @Inject
    public IndexQueryParserService(Index index, @IndexSettings Settings indexSettings, @Nullable Map<String, IndexQueryParserFactory> indexQueryParsersFactories) {
        super(index, indexSettings);
        Map<Object, Object> queryParserGroupSettings = indexSettings != null ? indexSettings.getGroups("index.queryparser.types") : Maps.newHashMap();
        HashMap<String, IndexQueryParser> qparsers = Maps.newHashMap();
        if (indexQueryParsersFactories != null) {
            for (Map.Entry<String, IndexQueryParserFactory> entry : indexQueryParsersFactories.entrySet()) {
                String qparserName = entry.getKey();
                Settings qparserSettings = (Settings)queryParserGroupSettings.get(qparserName);
                if (qparserSettings == null) {
                    qparserSettings = ImmutableSettings.Builder.EMPTY_SETTINGS;
                }
                qparsers.put(qparserName, entry.getValue().create(qparserName, qparserSettings));
            }
        }
        this.indexQueryParsers = ImmutableMap.copyOf(qparsers);
        this.defaultIndexQueryParser = this.indexQueryParser("default");
    }

    public IndexQueryParser indexQueryParser(String name) {
        return this.indexQueryParsers.get(name);
    }

    public IndexQueryParser defaultIndexQueryParser() {
        return this.defaultIndexQueryParser;
    }

    public static final class Defaults {
        public static final String DEFAULT = "default";
        public static final String PREFIX = "index.queryparser.types";
    }
}

