/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.xcontent.BaseFilterBuilder;
import org.elasticsearch.index.search.geo.GeoHashUtils;
import org.elasticsearch.index.search.geo.GeoPolygonFilter;

public class GeoPolygonFilterBuilder
extends BaseFilterBuilder {
    private final String name;
    private final List<GeoPolygonFilter.Point> points = Lists.newArrayList();
    private Boolean cache;
    private String filterName;

    public GeoPolygonFilterBuilder(String name) {
        this.name = name;
    }

    public GeoPolygonFilterBuilder addPoint(double lat, double lon) {
        this.points.add(new GeoPolygonFilter.Point(lat, lon));
        return this;
    }

    public GeoPolygonFilterBuilder addPoint(String geohash) {
        double[] values = GeoHashUtils.decode(geohash);
        return this.addPoint(values[0], values[1]);
    }

    public GeoPolygonFilterBuilder filterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    public GeoPolygonFilterBuilder cache(boolean cache) {
        this.cache = cache;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("geo_polygon");
        builder.startObject(this.name);
        builder.startArray("points");
        for (GeoPolygonFilter.Point point : this.points) {
            builder.startArray().value(point.lon).value(point.lat).endArray();
        }
        builder.endArray();
        builder.endObject();
        if (this.filterName != null) {
            builder.field("_name", this.filterName);
        }
        if (this.cache != null) {
            builder.field("_cache", (Object)this.cache);
        }
        builder.endObject();
    }
}

