/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.fusesource.fabric.zookeeper.IZKClient;
import org.linkedin.util.clock.Clock;
import org.linkedin.util.clock.SystemClock;
import org.linkedin.util.clock.Timespan;
import org.linkedin.util.concurrent.ConcurrentUtils;
import org.linkedin.zookeeper.client.AbstractZKClient;
import org.linkedin.zookeeper.client.ChrootedZKClient;
import org.linkedin.zookeeper.client.IZooKeeper;
import org.linkedin.zookeeper.client.LifecycleListener;
import org.linkedin.zookeeper.client.ZooKeeperFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiZkClient
extends AbstractZKClient
implements Watcher,
ManagedService,
IZKClient {
    public static final String PID = "org.fusesource.fabric.zookeeper";
    public static final Logger log = LoggerFactory.getLogger((String)OsgiZkClient.class.getName());
    private ConfigurationAdmin configurationAdmin;
    private BundleContext bundleContext;
    private ServiceRegistration managedServiceRegistration;
    private ServiceRegistration zkClientRegistration;
    private final Clock _clock = SystemClock.instance();
    private final List<LifecycleListener> _listeners = new CopyOnWriteArrayList<LifecycleListener>();
    private final Object _lock = new Object();
    private volatile State _state = State.NONE;
    private final StateChangeDispatcher _stateChangeDispatcher = new StateChangeDispatcher();
    private ZooKeeperFactory _factory;
    private IZooKeeper _zk;
    private Timespan _reconnectTimeout = Timespan.parse((String)"20s");
    Timespan sessionTimeout = new Timespan(30L, Timespan.TimeUnit.SECOND);
    private ExpiredSessionRecovery _expiredSessionRecovery = null;

    public OsgiZkClient() {
        super(null);
    }

    public void setConfigurationAdmin(ConfigurationAdmin configurationAdmin) {
        this.configurationAdmin = configurationAdmin;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        Object object = this._lock;
        synchronized (object) {
            this._stateChangeDispatcher.setDaemon(true);
            this._stateChangeDispatcher.start();
            this.bundleContext.addServiceListener(new ServiceListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void serviceChanged(ServiceEvent event) {
                    if (OsgiZkClient.this._state == State.CONNECTED && event.getType() == 1) {
                        LifecycleListener listener = (LifecycleListener)OsgiZkClient.this.bundleContext.getService(event.getServiceReference());
                        try {
                            listener.onConnected();
                        }
                        catch (Throwable e) {
                            log.warn("Exception while executing listener (ignored)", e);
                        }
                        finally {
                            OsgiZkClient.this.bundleContext.ungetService(event.getServiceReference());
                        }
                    }
                }
            }, "(objectClass=" + LifecycleListener.class.getName() + ")");
            Hashtable<String, String> ht = new Hashtable<String, String>();
            this.zkClientRegistration = this.bundleContext.registerService(new String[]{IZKClient.class.getName(), org.linkedin.zookeeper.client.IZKClient.class.getName()}, (Object)this, ht);
            ht = new Hashtable();
            ht.put("service.pid", PID);
            this.managedServiceRegistration = this.bundleContext.registerService(ManagedService.class.getName(), (Object)this, ht);
            this.updated(this.getDefaultProperties());
        }
    }

    private Dictionary getDefaultProperties() {
        try {
            Configuration c = this.configurationAdmin != null ? this.configurationAdmin.getConfiguration(PID, null) : null;
            return c != null ? c.getProperties() : null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.managedServiceRegistration != null) {
            this.managedServiceRegistration.unregister();
        }
        if (this.zkClientRegistration != null) {
            this.zkClientRegistration.unregister();
        }
        if (this._stateChangeDispatcher != null) {
            this._stateChangeDispatcher.end();
            try {
                this._stateChangeDispatcher.join(1000L);
            }
            catch (Exception e) {
                log.debug("ignored exception", (Throwable)e);
            }
        }
        Object object = this._lock;
        synchronized (object) {
            if (this._zk != null) {
                try {
                    this.changeState(State.NONE);
                    this._zk.close();
                    Thread th = this.getSendThread();
                    if (th != null) {
                        th.join(1000L);
                    }
                    this._zk = null;
                }
                catch (Exception e) {
                    log.debug("ignored exception", (Throwable)e);
                }
            }
        }
    }

    protected Thread getSendThread() {
        try {
            return (Thread)this.getField((Object)this._zk, "_zk", "cnxn", "sendThread");
        }
        catch (Throwable e) {
            return null;
        }
    }

    public void testGenerateConnectionLoss() throws Exception {
        Object clientCnxnSocket = this.getField((Object)this._zk, "_zk", "cnxn", "sendThread", "clientCnxnSocket");
        this.callMethod(clientCnxnSocket, "testableCloseSocket", new Object[0]);
    }

    protected Object getField(Object obj, String ... names) throws Exception {
        for (String name : names) {
            obj = this.getField(obj, name);
        }
        return obj;
    }

    protected Object getField(Object obj, String name) throws Exception {
        Class<?> clazz = obj.getClass();
        while (clazz != null) {
            for (Field f : clazz.getDeclaredFields()) {
                if (!f.getName().equals(name)) continue;
                f.setAccessible(true);
                return f.get(obj);
            }
        }
        throw new NoSuchFieldError(name);
    }

    protected Object callMethod(Object obj, String name, Object ... args) throws Exception {
        Class<?> clazz = obj.getClass();
        while (clazz != null) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!m.getName().equals(name)) continue;
                m.setAccessible(true);
                return m.invoke(obj, args);
            }
        }
        throw new NoSuchMethodError(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(Dictionary properties) throws ConfigurationException {
        Object object = this._lock;
        synchronized (object) {
            String url = System.getProperty("zookeeper.url");
            if (properties != null) {
                if (properties.get("zookeeper.url") != null) {
                    url = (String)properties.get("zookeeper.url");
                }
                if (properties.get("zookeeper.timeout") != null) {
                    this.sessionTimeout = Timespan.parse((String)((String)properties.get("zookeeper.timeout")));
                }
            }
            if (this._factory == null && url == null || this._factory != null && url != null && this._factory.getConnectString().equals(url)) {
                return;
            }
            if (this._state != State.NONE) {
                this.changeState(url != null ? State.RECONNECTING : State.NONE);
                try {
                    this._zk.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this._zk = null;
                this._factory = null;
            }
            if (url != null) {
                this._factory = new ZooKeeperFactory(url, this.sessionTimeout, (Watcher)this);
                this.tryStart();
            }
            this.zkClientRegistration.setProperties(properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tryStart() {
        Object object = this._lock;
        synchronized (object) {
            block5: {
                try {
                    this.start();
                }
                catch (Throwable e) {
                    log.warn("Error while restarting:", e);
                    if (this._expiredSessionRecovery != null) break block5;
                    this._expiredSessionRecovery = new ExpiredSessionRecovery();
                    this._expiredSessionRecovery.setDaemon(true);
                    this._expiredSessionRecovery.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this._lock;
        synchronized (object) {
            this.changeState(State.CONNECTING);
            this._zk = this._factory.createZooKeeper((Watcher)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WatchedEvent event) {
        if (event.getState() != null) {
            log.debug("event: {}", (Object)event.getState());
            Object object = this._lock;
            synchronized (object) {
                switch (event.getState()) {
                    case SyncConnected: {
                        this.changeState(State.CONNECTED);
                        break;
                    }
                    case Disconnected: {
                        if (this._state == State.NONE) break;
                        this.changeState(State.RECONNECTING);
                        break;
                    }
                    case Expired: {
                        this._zk = null;
                        log.warn("Expiration detected: trying to restart...");
                        this.tryStart();
                        break;
                    }
                    default: {
                        log.warn("unprocessed event state: {}", (Object)event.getState());
                    }
                }
            }
        }
    }

    protected IZooKeeper getZk() {
        IZooKeeper zk;
        State state = this._state;
        if (state == State.NONE) {
            throw new IllegalStateException("ZooKeeper client has not been configured yet. You need to either create an ensemble or join one.");
        }
        if (state != State.CONNECTED) {
            try {
                this.waitForConnected();
            }
            catch (Exception e) {
                throw new IllegalStateException("Error waiting for ZooKeeper connection", e);
            }
        }
        if ((zk = this._zk) == null) {
            throw new IllegalStateException("No ZooKeeper connection available");
        }
        return zk;
    }

    @Override
    public void waitForConnected(Timespan timeout) throws InterruptedException, TimeoutException {
        this.waitForState(State.CONNECTED, timeout);
    }

    @Override
    public void waitForConnected() throws InterruptedException, TimeoutException {
        this.waitForConnected(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState(State state, Timespan timeout) throws TimeoutException, InterruptedException {
        long endTime = (timeout == null ? this.sessionTimeout : timeout).futureTimeMillis(this._clock);
        if (this._state != state) {
            Object object = this._lock;
            synchronized (object) {
                while (this._state != state) {
                    ConcurrentUtils.awaitUntil((Clock)this._clock, (Object)this._lock, (long)endTime);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeState(State newState) {
        Object object = this._lock;
        synchronized (object) {
            State oldState = this._state;
            if (oldState != newState) {
                this._stateChangeDispatcher.addEvent(oldState, newState);
                this._state = newState;
                this._lock.notifyAll();
            }
        }
    }

    public void registerListener(LifecycleListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
        if (this._state == State.CONNECTED) {
            listener.onConnected();
        }
    }

    public void removeListener(LifecycleListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is null");
        }
        this._listeners.remove(listener);
    }

    public org.linkedin.zookeeper.client.IZKClient chroot(String path) {
        return new ChrootedZKClient((org.linkedin.zookeeper.client.IZKClient)this, this.adjustPath(path));
    }

    public boolean isConnected() {
        return this._state == State.CONNECTED;
    }

    public boolean isConfigured() {
        return this._state != State.NONE;
    }

    public String getConnectString() {
        return this._factory.getConnectString();
    }

    @Override
    public Stat createOrSetByteWithParents(String path, byte[] data, List<ACL> acl, CreateMode createMode) throws InterruptedException, KeeperException {
        if (this.exists(path) != null) {
            return this.setByteData(path, data);
        }
        try {
            this.createBytesNodeWithParents(path, data, acl, createMode);
            return null;
        }
        catch (KeeperException.NodeExistsException e) {
            return this.setByteData(path, data);
        }
    }

    private class ExpiredSessionRecovery
    extends Thread {
        private ExpiredSessionRecovery() {
            super("ZooKeeper expired session recovery thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            log.info("Entering recovery mode");
            Object object = OsgiZkClient.this._lock;
            synchronized (object) {
                try {
                    int count = 0;
                    while (OsgiZkClient.this._state == State.NONE) {
                        try {
                            log.warn("Recovery mode: trying to reconnect to zookeeper [" + ++count + "]");
                            OsgiZkClient.this.start();
                        }
                        catch (Throwable e) {
                            log.warn("Recovery mode: reconnect attempt failed [" + count + "]... waiting for " + OsgiZkClient.this._reconnectTimeout, e);
                            try {
                                OsgiZkClient.this._lock.wait(OsgiZkClient.this._reconnectTimeout.getDurationInMilliseconds());
                            }
                            catch (InterruptedException e1) {
                                throw new RuntimeException("Recovery mode: wait interrupted... bailing out", e1);
                            }
                        }
                    }
                    return;
                }
                finally {
                    OsgiZkClient.this._expiredSessionRecovery = null;
                    log.info("Exiting recovery mode.");
                }
            }
        }
    }

    private class StateChangeDispatcher
    extends Thread {
        private final AtomicBoolean _running;
        private final BlockingQueue<Boolean> _events;

        private StateChangeDispatcher() {
            super("ZooKeeper state change dispatcher thread");
            this._running = new AtomicBoolean(true);
            this._events = new LinkedBlockingQueue<Boolean>();
        }

        @Override
        public void run() {
            IdentityHashMap history = new IdentityHashMap();
            log.info("Starting StateChangeDispatcher");
            while (this._running.get()) {
                IdentityHashMap<Object, Boolean> newHistory;
                block17: {
                    Boolean isConnectedEvent;
                    try {
                        isConnectedEvent = this._events.take();
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    if (!this._running.get() || isConnectedEvent == null) continue;
                    newHistory = new IdentityHashMap<Object, Boolean>();
                    for (LifecycleListener listener : OsgiZkClient.this._listeners) {
                        Boolean previousEvent = (Boolean)history.get(listener);
                        if (previousEvent == null || previousEvent != isConnectedEvent) {
                            try {
                                if (isConnectedEvent.booleanValue()) {
                                    listener.onConnected();
                                } else {
                                    listener.onDisconnected();
                                }
                            }
                            catch (Throwable e) {
                                log.warn("Exception while executing listener (ignored)", e);
                            }
                        }
                        newHistory.put(listener, isConnectedEvent);
                    }
                    try {
                        ServiceReference[] references = OsgiZkClient.this.bundleContext.getServiceReferences(LifecycleListener.class.getName(), null);
                        if (references == null) break block17;
                        for (ServiceReference reference : references) {
                            LifecycleListener listener = (LifecycleListener)OsgiZkClient.this.bundleContext.getService(reference);
                            Boolean previousEvent = (Boolean)history.get(reference);
                            if (previousEvent == null || previousEvent != isConnectedEvent) {
                                try {
                                    if (isConnectedEvent.booleanValue()) {
                                        listener.onConnected();
                                    } else {
                                        listener.onDisconnected();
                                    }
                                }
                                catch (Throwable e) {
                                    log.warn("Exception while executing listener (ignored)", e);
                                }
                            }
                            newHistory.put(reference, isConnectedEvent);
                            OsgiZkClient.this.bundleContext.ungetService(reference);
                        }
                    }
                    catch (InvalidSyntaxException e) {
                        throw new IllegalStateException(e);
                    }
                }
                history = newHistory;
            }
            log.info("StateChangeDispatcher terminated.");
        }

        public void end() {
            this._events.add(false);
            this._running.set(false);
        }

        public void addEvent(State oldState, State newState) {
            log.debug("addEvent: {} => {}", (Object)oldState, (Object)newState);
            if (newState == State.CONNECTED) {
                this._events.add(true);
            } else if (oldState == State.CONNECTED) {
                this._events.add(false);
            }
        }
    }

    public static enum State {
        NONE,
        CONNECTING,
        CONNECTED,
        RECONNECTING;

    }
}

