/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.zookeeper.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumStats;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKServerFactoryBean
implements ManagedServiceFactory {
    private static final transient Logger LOG = LoggerFactory.getLogger(ZKServerFactoryBean.class);
    private BundleContext bundleContext;
    private Map<String, Object> servers = new HashMap<String, Object>();
    private Map<String, ServiceRegistration> services = new HashMap<String, ServiceRegistration>();
    private final AtomicBoolean destroyed = new AtomicBoolean();

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public String getName() {
        return "ZooKeeper Server";
    }

    public void debug(String str, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format(str, args));
        }
    }

    public synchronized void updated(String pid, Dictionary properties) throws ConfigurationException {
        if (this.destroyed.get()) {
            return;
        }
        this.doCreate(pid, properties);
    }

    public synchronized void deleted(String pid) {
        if (this.destroyed.get()) {
            return;
        }
        this.doDelete(pid);
    }

    public synchronized void destroy() throws Exception {
        if (this.destroyed.compareAndSet(false, true)) {
            while (!this.servers.isEmpty()) {
                String pid = this.servers.keySet().iterator().next();
                this.doDelete(pid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCreate(String pid, Dictionary properties) throws ConfigurationException {
        block15: {
            try {
                this.deleted(pid);
                Properties props = new Properties();
                Enumeration ek = properties.keys();
                while (ek.hasMoreElements()) {
                    Object key = ek.nextElement();
                    Object val = properties.get(key);
                    props.put(key.toString(), val != null ? val.toString() : "");
                }
                String serverId = props.getProperty("server.id");
                if (serverId != null) {
                    props.remove("server.id");
                    File myId = new File(props.getProperty("dataDir"), "myid");
                    if (myId.exists()) {
                        myId.delete();
                    }
                    if (myId.getParentFile() != null) {
                        myId.getParentFile().mkdirs();
                    }
                    FileOutputStream fos = new FileOutputStream(myId);
                    try {
                        fos.write((serverId + "\n").getBytes());
                    }
                    finally {
                        fos.close();
                    }
                }
                QuorumPeerConfig config = new QuorumPeerConfig();
                config.parseProperties(props);
                if (!config.getServers().isEmpty()) {
                    NIOServerCnxnFactory cnxnFactory = new NIOServerCnxnFactory();
                    cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
                    QuorumPeer quorumPeer = new QuorumPeer();
                    quorumPeer.setClientPortAddress(config.getClientPortAddress());
                    quorumPeer.setTxnFactory(new FileTxnSnapLog(new File(config.getDataLogDir()), new File(config.getDataDir())));
                    quorumPeer.setQuorumPeers(config.getServers());
                    quorumPeer.setElectionType(config.getElectionAlg());
                    quorumPeer.setMyid(config.getServerId());
                    quorumPeer.setTickTime(config.getTickTime());
                    quorumPeer.setMinSessionTimeout(config.getMinSessionTimeout());
                    quorumPeer.setMaxSessionTimeout(config.getMaxSessionTimeout());
                    quorumPeer.setInitLimit(config.getInitLimit());
                    quorumPeer.setSyncLimit(config.getSyncLimit());
                    quorumPeer.setQuorumVerifier(config.getQuorumVerifier());
                    quorumPeer.setCnxnFactory((ServerCnxnFactory)cnxnFactory);
                    quorumPeer.setZKDatabase(new ZKDatabase(quorumPeer.getTxnFactory()));
                    quorumPeer.setLearnerType(config.getPeerType());
                    try {
                        this.debug("Starting quorum peer \"%s\" on address %s", quorumPeer.getMyid(), config.getClientPortAddress());
                        quorumPeer.start();
                        this.debug("Started quorum peer \"%s\"", quorumPeer.getMyid());
                    }
                    catch (Exception e) {
                        LOG.warn(String.format("Failed to start quorum peer \"%s\", reason : ", quorumPeer.getMyid(), e));
                        quorumPeer.shutdown();
                        throw e;
                    }
                    this.servers.put(pid, quorumPeer);
                    this.services.put(pid, this.bundleContext.registerService(QuorumStats.Provider.class.getName(), (Object)quorumPeer, properties));
                    break block15;
                }
                ServerConfig cfg = new ServerConfig();
                cfg.readFrom(config);
                ZooKeeperServer zkServer = new ZooKeeperServer();
                FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(cfg.getDataLogDir()), new File(cfg.getDataDir()));
                zkServer.setTxnLogFactory(ftxn);
                zkServer.setTickTime(cfg.getTickTime());
                zkServer.setMinSessionTimeout(cfg.getMinSessionTimeout());
                zkServer.setMaxSessionTimeout(cfg.getMaxSessionTimeout());
                NIOServerCnxnFactory cnxnFactory = new NIOServerCnxnFactory();
                cnxnFactory.configure(cfg.getClientPortAddress(), cfg.getMaxClientCnxns());
                try {
                    this.debug("Starting ZooKeeper server on address %s", config.getClientPortAddress());
                    cnxnFactory.startup(zkServer);
                    LOG.debug("Started ZooKeeper server");
                }
                catch (Exception e) {
                    LOG.warn(String.format("Failed to start ZooKeeper server, reason : %s", e));
                    cnxnFactory.shutdown();
                    throw e;
                }
                this.servers.put(pid, cnxnFactory);
                this.services.put(pid, this.bundleContext.registerService(ServerStats.Provider.class.getName(), (Object)zkServer, properties));
            }
            catch (Exception e) {
                throw (ConfigurationException)new ConfigurationException(null, "Unable to parse ZooKeeper configuration: " + e.getMessage()).initCause((Throwable)e);
            }
        }
    }

    protected void doDelete(String pid) {
        this.debug("Shutting down ZK server %s", pid);
        Object obj = this.servers.remove(pid);
        ServiceRegistration reg = this.services.remove(pid);
        try {
            if (obj instanceof QuorumPeer) {
                ((QuorumPeer)obj).shutdown();
                ((QuorumPeer)obj).join();
            } else if (obj instanceof NIOServerCnxnFactory) {
                ((NIOServerCnxnFactory)obj).shutdown();
                ((NIOServerCnxnFactory)obj).join();
            }
        }
        catch (Throwable t) {
            this.debug("Caught and am ignoring exception %s while shutting down ZK server %s", t, obj);
        }
        if (reg != null) {
            try {
                reg.unregister();
            }
            catch (Throwable t) {
                this.debug("Caught and am ignoring exception %s while unregistering %s", t, pid);
            }
        }
    }
}

