/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.KeeperException;
import org.fusesource.fabric.api.Container;
import org.fusesource.fabric.api.FabricException;
import org.fusesource.fabric.api.Profile;
import org.fusesource.fabric.internal.ProfileOverlayImpl;
import org.fusesource.fabric.service.FabricServiceImpl;
import org.fusesource.fabric.zookeeper.ZkPath;
import org.fusesource.fabric.zookeeper.utils.ZooKeeperUtils;
import org.linkedin.zookeeper.client.IZKClient;

public class ProfileImpl
implements Profile {
    public static final String AGENT_PID = "org.fusesource.fabric.agent";
    private final String id;
    private final String version;
    private final FabricServiceImpl service;

    public ProfileImpl(String id, String version, FabricServiceImpl service) {
        this.id = id;
        this.version = version;
        this.service = service;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public FabricServiceImpl getService() {
        return this.service;
    }

    @Override
    public int compareTo(Profile profile) {
        return this.id.compareTo(profile.getId());
    }

    @Override
    public List<String> getBundles() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.BUNDLES);
    }

    @Override
    public List<String> getFabs() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.FABS);
    }

    @Override
    public List<String> getFeatures() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.FEATURES);
    }

    @Override
    public List<String> getRepositories() {
        return ProfileImpl.getContainerConfigList(this, ConfigListType.REPOSITORIES);
    }

    @Override
    public void setBundles(List<String> values) {
        ProfileImpl.setContainerConfigList(this, values, ConfigListType.BUNDLES);
    }

    @Override
    public void setFabs(List<String> values) {
        ProfileImpl.setContainerConfigList(this, values, ConfigListType.FABS);
    }

    @Override
    public void setFeatures(List<String> values) {
        ProfileImpl.setContainerConfigList(this, values, ConfigListType.FEATURES);
    }

    @Override
    public void setRepositories(List<String> values) {
        ProfileImpl.setContainerConfigList(this, values, ConfigListType.REPOSITORIES);
    }

    public static List<String> getContainerConfigList(Profile p, ConfigListType type) {
        try {
            Properties containerProps = ProfileImpl.getContainerProperties(p);
            ArrayList<String> rc = new ArrayList<String>();
            for (Map.Entry<Object, Object> e : containerProps.entrySet()) {
                if (!((String)e.getKey()).startsWith((Object)((Object)type) + ".")) continue;
                rc.add((String)e.getValue());
            }
            return rc;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public static void setContainerConfigList(Profile p, List<String> values, ConfigListType type) {
        Map<String, Map<String, String>> config = p.getConfigurations();
        String prefix = (Object)((Object)type) + ".";
        Map<String, String> map = config.get(AGENT_PID);
        if (map == null) {
            map = new HashMap<String, String>();
            config.put(AGENT_PID, map);
        } else {
            ArrayList<String> keys = new ArrayList<String>(map.keySet());
            for (String key : keys) {
                if (!key.startsWith(prefix)) continue;
                map.remove(key);
            }
        }
        for (String value : values) {
            map.put(prefix + value, value);
        }
        p.setConfigurations(config);
    }

    public static Properties getContainerProperties(Profile p) throws IOException {
        byte[] b = p.getFileConfigurations().get("org.fusesource.fabric.agent.properties");
        if (b != null) {
            return ProfileImpl.toProperties(b);
        }
        return new Properties();
    }

    @Override
    public Profile[] getParents() {
        try {
            String node = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, this.id});
            String str = this.service.getZooKeeper().getStringData(node);
            if (str == null || str.isEmpty()) {
                return new Profile[0];
            }
            str = str.trim();
            ArrayList<ProfileImpl> profiles = new ArrayList<ProfileImpl>();
            for (String p : str.split(" ")) {
                profiles.add(new ProfileImpl(p, this.version, this.service));
            }
            return profiles.toArray(new Profile[profiles.size()]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void setParents(Profile[] parents) {
        try {
            String str = "";
            for (Profile parent : parents) {
                if (!this.version.equals(parent.getVersion())) {
                    throw new IllegalArgumentException("Version mismatch setting parent profile " + parent + " with version " + parent.getVersion() + " expected version " + this.version);
                }
                if (!str.isEmpty()) {
                    str = str + " ";
                }
                str = str + parent.getId();
            }
            this.service.getZooKeeper().setData(ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, this.id}), str);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Container[] getAssociatedContainers() {
        try {
            Container[] containers;
            ArrayList<Container> rc = new ArrayList<Container>();
            block2: for (Container container : containers = this.service.getContainers()) {
                if (!container.getVersion().getName().equals(this.getVersion())) continue;
                for (Profile p : container.getProfiles()) {
                    if (!this.equals(p)) continue;
                    rc.add(container);
                    continue block2;
                }
            }
            return rc.toArray(new Container[0]);
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public boolean isOverlay() {
        return false;
    }

    @Override
    public Profile getOverlay() {
        return new ProfileOverlayImpl(this);
    }

    @Override
    public Map<String, byte[]> getFileConfigurations() {
        try {
            HashMap<String, byte[]> configurations = new HashMap<String, byte[]>();
            String path = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, this.id});
            List pids = this.service.getZooKeeper().getChildren(path);
            for (String pid : pids) {
                configurations.put(pid, this.getFileConfiguration(pid));
            }
            return configurations;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    public byte[] getFileConfiguration(String pid) throws InterruptedException, KeeperException {
        IZKClient zooKeeper = this.service.getZooKeeper();
        String path = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, this.id}) + "/" + pid;
        if (zooKeeper.exists(path) == null) {
            return null;
        }
        if (zooKeeper.getData(path) == null) {
            List children = zooKeeper.getChildren(path);
            StringBuffer buf = new StringBuffer();
            for (String child : children) {
                String value = zooKeeper.getStringData(path + "/" + child);
                buf.append(String.format("%s = %s\n", child, value));
            }
            return buf.toString().getBytes();
        }
        return zooKeeper.getData(path);
    }

    @Override
    public void setFileConfigurations(Map<String, byte[]> configurations) {
        try {
            IZKClient zooKeeper = this.service.getZooKeeper();
            Map<String, byte[]> oldCfgs = this.getFileConfigurations();
            String path = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, this.id});
            for (String pid : configurations.keySet()) {
                oldCfgs.remove(pid);
                byte[] newCfg = configurations.get(pid);
                String configPath = path + "/" + pid;
                if (zooKeeper.exists(configPath) != null && zooKeeper.getChildren(configPath).size() > 0) {
                    List kids = zooKeeper.getChildren(configPath);
                    ArrayList<String> saved = new ArrayList<String>();
                    for (String line : new String(newCfg).split("\n")) {
                        String[] name_value;
                        if (line.startsWith("#") || line.length() == 0 || (name_value = line.split("=", 2)).length < 2) continue;
                        String newPath = configPath + "/" + name_value[0].trim();
                        ZooKeeperUtils.set((IZKClient)zooKeeper, (String)newPath, (String)name_value[1].trim());
                        saved.add(name_value[0].trim());
                    }
                    for (String kid : kids) {
                        if (saved.contains(kid)) continue;
                        zooKeeper.deleteWithChildren(configPath + "/" + kid);
                    }
                    continue;
                }
                ZooKeeperUtils.set((IZKClient)zooKeeper, (String)configPath, (byte[])newCfg);
            }
            for (String pid : oldCfgs.keySet()) {
                zooKeeper.deleteWithChildren(path + "/" + pid);
            }
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Map<String, Map<String, String>> getConfigurations() {
        try {
            HashMap<String, Map<String, String>> configurations = new HashMap<String, Map<String, String>>();
            Map<String, byte[]> configs = this.getFileConfigurations();
            for (Map.Entry<String, byte[]> entry : configs.entrySet()) {
                if (!entry.getKey().endsWith(".properties")) continue;
                String pid = ProfileImpl.stripSuffix(entry.getKey(), ".properties");
                configurations.put(pid, this.getConfiguration(pid));
            }
            return configurations;
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public Map<String, String> getContainerConfiguration() {
        Map<String, String> map = this.getConfigurations().get(AGENT_PID);
        if (map == null) {
            map = new HashMap<String, String>();
        }
        return map;
    }

    private Map<String, String> getConfiguration(String pid) throws InterruptedException, KeeperException, IOException {
        IZKClient zooKeeper = this.service.getZooKeeper();
        String path = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, this.id}) + "/" + pid + ".properties";
        if (zooKeeper.exists(path) == null) {
            return null;
        }
        byte[] data = zooKeeper.getData(path);
        return ProfileImpl.toMap(ProfileImpl.toProperties(data));
    }

    public static byte[] toBytes(Properties source) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        source.store(baos, null);
        return baos.toByteArray();
    }

    public static Properties toProperties(byte[] source) throws IOException {
        Properties rc = new Properties();
        rc.load(new ByteArrayInputStream(source));
        return rc;
    }

    public static Map<String, String> toMap(Properties source) {
        HashMap<String, String> rc = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            rc.put((String)entry.getKey(), (String)entry.getValue());
        }
        return rc;
    }

    public static Properties toProperties(Map<String, String> source) {
        Properties rc = new Properties();
        for (Map.Entry<String, String> entry : source.entrySet()) {
            rc.put(entry.getKey(), entry.getValue());
        }
        return rc;
    }

    public static String stripSuffix(String value, String suffix) throws IOException {
        if (value.endsWith(suffix)) {
            return value.substring(0, value.length() - suffix.length());
        }
        return value;
    }

    @Override
    public void setConfigurations(Map<String, Map<String, String>> configurations) {
        try {
            IZKClient zooKeeper = this.service.getZooKeeper();
            Map<String, Map<String, String>> oldCfgs = this.getConfigurations();
            String path = ZkPath.CONFIG_VERSIONS_PROFILE.getPath(new String[]{this.version, this.id});
            for (String pid : configurations.keySet()) {
                oldCfgs.remove(pid);
                byte[] data = ProfileImpl.toBytes(ProfileImpl.toProperties(configurations.get(pid)));
                String p = path + "/" + pid + ".properties";
                ZooKeeperUtils.set((IZKClient)zooKeeper, (String)p, (byte[])data);
            }
            for (String key : oldCfgs.keySet()) {
                zooKeeper.deleteWithChildren(path + "/" + key + ".properties");
            }
        }
        catch (Exception e) {
            throw new FabricException(e);
        }
    }

    @Override
    public void delete() {
        this.service.deleteProfile(this);
    }

    @Override
    public boolean configurationEquals(Profile other) {
        Object[] parents = this.getParents();
        Object[] otherParents = other.getParents();
        Arrays.sort(parents);
        Arrays.sort(otherParents);
        if (!((Object)this.getConfigurations()).equals(other.getConfigurations())) {
            return false;
        }
        if (parents.length != otherParents.length) {
            return false;
        }
        for (int i = 0; i < parents.length; ++i) {
            if (parents[i].configurationEquals((Profile)otherParents[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "ProfileImpl[id='" + this.id + '\'' + ", version='" + this.version + '\'' + ']';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProfileImpl profile = (ProfileImpl)o;
        if (!this.id.equals(profile.id)) {
            return false;
        }
        return this.version.equals(profile.version);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    @Override
    public boolean isAbstract() {
        return this.id == null || this.id.equals("mq-base") || this.id.startsWith("fabric-ensemble-0000");
    }

    public static enum ConfigListType {
        BUNDLES("bundle"),
        FABS("fab"),
        FEATURES("feature"),
        REPOSITORIES("repository");

        private String value;

        private ConfigListType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

