/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.ConfigFileInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="info", description="Shows information about selected information.")
public class InfoFeatureCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="name", description="The name of the feature", required=true, multiValued=false)
    private String name;
    @Argument(index=1, name="version", description="The version of the feature", required=false, multiValued=false)
    private String version;
    @Option(name="-c", aliases={"--configuration"}, description="Display configuration info", required=false, multiValued=false)
    private boolean config;
    @Option(name="-d", aliases={"--dependency"}, description="Display dependencies info", required=false, multiValued=false)
    private boolean dependency;
    @Option(name="-b", aliases={"--bundle"}, description="Display bundles info", required=false, multiValued=false)
    private boolean bundle;
    @Option(name="-t", aliases={"--tree"}, description="Display feature tree", required=false, multiValued=false)
    private boolean tree;

    protected void doExecute(FeaturesService admin) throws Exception {
        Feature feature = null;
        feature = this.version != null && this.version.length() > 0 ? admin.getFeature(this.name, this.version) : admin.getFeature(this.name);
        if (feature == null) {
            System.out.println("Feature not found");
            return;
        }
        if (!(this.config || this.dependency || this.bundle)) {
            this.config = true;
            this.dependency = true;
            this.bundle = true;
        }
        System.out.println("Description of " + feature.getName() + " " + feature.getVersion() + " feature");
        System.out.println("----------------------------------------------------------------");
        if (feature.getDetails() != null && feature.getDetails().length() > 0) {
            System.out.print(feature.getDetails());
            System.out.println("----------------------------------------------------------------");
        }
        if (this.config) {
            this.displayConfigInformation(feature);
            this.displayConfigFileInformation(feature);
        }
        if (this.dependency) {
            this.displayDependencyInformation(feature);
        }
        if (this.bundle) {
            this.displayBundleInformation(feature);
        }
        if (this.tree) {
            int unresolved;
            if (this.config || this.dependency || this.bundle) {
                System.out.println("\nFeature tree");
            }
            if ((unresolved = this.displayFeatureTree(admin, feature, 0, false)) > 0) {
                System.out.println("Tree contains " + unresolved + " unresolved dependencies");
                System.out.println(" * means that node declares dependency but the dependant feature is not available.");
            }
        }
    }

    private void displayBundleInformation(Feature feature) {
        List bundleInfos = feature.getBundles();
        if (bundleInfos.isEmpty()) {
            System.out.println("Feature has no bundles.");
        } else {
            System.out.println("Feature contains followed bundles:");
            for (BundleInfo featureBundle : bundleInfos) {
                int startLevel = featureBundle.getStartLevel();
                StringBuilder sb = new StringBuilder();
                sb.append(" ").append(featureBundle.getLocation());
                if (startLevel > 0) {
                    sb.append(" start-level=").append(startLevel);
                }
                System.out.println(sb.toString());
            }
        }
    }

    private void displayDependencyInformation(Feature feature) {
        List dependencies = feature.getDependencies();
        if (dependencies.isEmpty()) {
            System.out.println("Feature has no dependencies.");
        } else {
            System.out.println("Feature depends on:");
            for (Feature featureDependency : dependencies) {
                System.out.println("  " + featureDependency.getName() + " " + featureDependency.getVersion());
            }
        }
    }

    private void displayConfigInformation(Feature feature) {
        Map configurations = feature.getConfigurations();
        if (configurations.isEmpty()) {
            System.out.println("Feature has no configuration");
        } else {
            System.out.println("Feature configuration:");
            for (String name : configurations.keySet()) {
                System.out.println("  " + name);
            }
        }
    }

    private void displayConfigFileInformation(Feature feature) {
        List configurationFiles = feature.getConfigurationFiles();
        if (configurationFiles.isEmpty()) {
            System.out.println("Feature has no configuration files");
        } else {
            System.out.println("Feature configuration files: ");
            for (ConfigFileInfo configFileInfo : configurationFiles) {
                System.out.println("  " + configFileInfo.getFinalname());
            }
        }
    }

    private int displayFeatureTree(FeaturesService admin, Feature feature, int level, boolean last) throws Exception {
        int i;
        int j;
        int unresolved = 0;
        String prefix = InfoFeatureCommand.repeat("   ", level);
        Feature resolved = this.resolveFeature(admin, feature);
        if (resolved != null) {
            System.out.println(prefix + " " + resolved.getName() + " " + resolved.getVersion());
        } else {
            System.out.println(prefix + " " + feature.getName() + " " + feature.getVersion() + " *");
            ++unresolved;
        }
        if (this.bundle) {
            List bundles = resolved != null ? resolved.getBundles() : feature.getBundles();
            j = bundles.size();
            for (i = 0; i < j; ++i) {
                System.out.println(prefix + " " + (i + 1 == j ? "\\" : "+") + " " + ((BundleInfo)bundles.get(i)).getLocation());
            }
        }
        List dependencies = resolved != null ? resolved.getDependencies() : feature.getDependencies();
        j = dependencies.size();
        for (i = 0; i < j; ++i) {
            Feature toDisplay = this.resolveFeature(admin, (Feature)dependencies.get(i));
            if (toDisplay == null) {
                toDisplay = (Feature)dependencies.get(i);
            }
            unresolved += this.displayFeatureTree(admin, toDisplay, level + 1, i + 1 == j);
        }
        return unresolved;
    }

    private Feature resolveFeature(FeaturesService admin, Feature feature) throws Exception {
        return admin.getFeature(feature.getName(), feature.getVersion());
    }

    private static String repeat(String string, int times) {
        if (times <= 0) {
            return "";
        }
        if (times % 2 == 0) {
            return InfoFeatureCommand.repeat(string + string, times / 2);
        }
        return string + InfoFeatureCommand.repeat(string + string, times / 2);
    }
}

