/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireTapProcessor
extends ServiceSupport
implements AsyncProcessor,
Traceable {
    private static final transient Logger LOG = LoggerFactory.getLogger(WireTapProcessor.class);
    private final Endpoint destination;
    private final Processor processor;
    private final ExchangePattern exchangePattern;
    private final ExecutorService executorService;
    private volatile boolean shutdownExecutorService;
    private Expression newExchangeExpression;
    private List<Processor> newExchangeProcessors;
    private boolean copy;
    private Processor onPrepare;

    public WireTapProcessor(Endpoint destination, Processor processor, ExchangePattern exchangePattern, ExecutorService executorService, boolean shutdownExecutorService) {
        this.destination = destination;
        this.processor = processor;
        this.exchangePattern = exchangePattern;
        ObjectHelper.notNull(executorService, "executorService");
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
    }

    public String toString() {
        return "WireTap[" + this.destination.getEndpointUri() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "wireTap(" + this.destination.getEndpointUri() + ")";
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (!this.isStarted()) {
            throw new IllegalStateException("WireTapProcessor has not been started: " + this);
        }
        final Exchange wireTapExchange = this.configureExchange(exchange, this.exchangePattern);
        this.executorService.submit(new Callable<Exchange>(){

            @Override
            public Exchange call() throws Exception {
                try {
                    LOG.debug(">>>> (wiretap) {} {}", (Object)WireTapProcessor.this.destination, (Object)wireTapExchange);
                    WireTapProcessor.this.processor.process(wireTapExchange);
                }
                catch (Throwable e) {
                    LOG.warn("Error occurred during processing " + wireTapExchange + " wiretap to " + WireTapProcessor.this.destination + ". This exception will be ignored.", e);
                }
                return wireTapExchange;
            }
        });
        callback.done(true);
        return true;
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern) {
        Object body;
        Exchange answer = this.copy ? this.configureCopyExchange(exchange) : this.configureNewExchange(exchange);
        answer.setProperty("CamelToEndpoint", this.destination.getEndpointUri());
        if (this.newExchangeExpression != null && (body = this.newExchangeExpression.evaluate(answer, Object.class)) != null) {
            answer.getIn().setBody(body);
        }
        if (this.newExchangeProcessors != null) {
            for (Processor processor : this.newExchangeProcessors) {
                try {
                    processor.process(answer);
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException(e);
                }
            }
        }
        if (this.onPrepare != null) {
            try {
                this.onPrepare.process(exchange);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return answer;
    }

    private Exchange configureCopyExchange(Exchange exchange) {
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
        copy.setPattern(ExchangePattern.InOnly);
        return copy;
    }

    private Exchange configureNewExchange(Exchange exchange) {
        return new DefaultExchange(exchange.getFromEndpoint(), ExchangePattern.InOnly);
    }

    public List<Processor> getNewExchangeProcessors() {
        return this.newExchangeProcessors;
    }

    public void setNewExchangeProcessors(List<Processor> newExchangeProcessors) {
        this.newExchangeProcessors = newExchangeProcessors;
    }

    public Expression getNewExchangeExpression() {
        return this.newExchangeExpression;
    }

    public void setNewExchangeExpression(Expression newExchangeExpression) {
        this.newExchangeExpression = newExchangeExpression;
    }

    public void addNewExchangeProcessor(Processor processor) {
        if (this.newExchangeProcessors == null) {
            this.newExchangeProcessors = new ArrayList<Processor>();
        }
        this.newExchangeProcessors.add(processor);
    }

    public boolean isCopy() {
        return this.copy;
    }

    public void setCopy(boolean copy) {
        this.copy = copy;
    }

    public Processor getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(Processor onPrepare) {
        this.onPrepare = onPrepare;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.processor);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.processor);
        if (this.shutdownExecutorService) {
            this.destination.getCamelContext().getExecutorServiceManager().shutdownNow(this.executorService);
        }
    }
}

