/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.camel.Exchange;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOHelper {
    private static final transient Logger LOG = LoggerFactory.getLogger(IOHelper.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    private IOHelper() {
    }

    public static String newStringFromBytes(byte[] bytes) {
        try {
            return new String(bytes, UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"UTF-8\") returns invalid name.", e);
        }
    }

    public static String newStringFromBytes(byte[] bytes, int start, int length) {
        try {
            return new String(bytes, start, length, UTF8_CHARSET.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Impossible failure: Charset.forName(\"UTF-8\") returns invalid name.", e);
        }
    }

    public static BufferedInputStream buffered(InputStream in) {
        ObjectHelper.notNull(in, "in");
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedOutputStream buffered(OutputStream out) {
        ObjectHelper.notNull(out, "out");
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static BufferedReader buffered(Reader reader) {
        ObjectHelper.notNull(reader, "reader");
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedWriter buffered(Writer writer) {
        ObjectHelper.notNull(writer, "writer");
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    @Deprecated
    public static IOException createIOException(Throwable cause) {
        return IOHelper.createIOException(cause.getMessage(), cause);
    }

    @Deprecated
    public static IOException createIOException(String message, Throwable cause) {
        IOException answer = new IOException(message);
        answer.initCause(cause);
        return answer;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return IOHelper.copy(input, output, 4096);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        int avail = input.available();
        if (avail > 262144) {
            avail = 262144;
        }
        if (avail > bufferSize) {
            bufferSize = avail;
        }
        byte[] buffer = new byte[bufferSize];
        int n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        output.flush();
        return total;
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output) throws IOException {
        IOHelper.copyAndCloseInput(input, output, 4096);
    }

    public static void copyAndCloseInput(InputStream input, OutputStream output, int bufferSize) throws IOException {
        IOHelper.copy(input, output, bufferSize);
        IOHelper.close((Closeable)input, null, LOG);
    }

    public static int copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = input.read(buffer);
        int total = 0;
        while (-1 != n) {
            output.write(buffer, 0, n);
            total += n;
            n = input.read(buffer);
        }
        output.flush();
        return total;
    }

    public static void force(FileChannel channel, String name, Logger log) {
        try {
            channel.force(true);
        }
        catch (Exception e) {
            if (log == null) {
                log = LOG;
            }
            if (name != null) {
                log.warn("Cannot force FileChannel: " + name + ". Reason: " + e.getMessage(), (Throwable)e);
            }
            log.warn("Cannot force FileChannel. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void close(Closeable closeable, String name, Logger log) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                if (log == null) {
                    log = LOG;
                }
                if (name != null) {
                    log.warn("Cannot close: " + name + ". Reason: " + e.getMessage(), (Throwable)e);
                }
                log.warn("Cannot close. Reason: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void close(Closeable closeable, String name) {
        IOHelper.close(closeable, name, LOG);
    }

    public static void close(Closeable closeable) {
        IOHelper.close(closeable, null, LOG);
    }

    public static void close(Closeable ... closeables) {
        for (Closeable closeable : closeables) {
            IOHelper.close(closeable, null, LOG);
        }
    }

    public static void validateCharset(String charset) throws UnsupportedCharsetException {
        if (charset != null && Charset.isSupported(charset)) {
            Charset.forName(charset);
            return;
        }
        throw new UnsupportedCharsetException(charset);
    }

    public static String normalizeCharset(String charset) {
        if (charset != null) {
            String answer = charset.trim();
            if (answer.startsWith("'") || answer.startsWith("\"")) {
                answer = answer.substring(1);
            }
            if (answer.endsWith("'") || answer.endsWith("\"")) {
                answer = answer.substring(0, answer.length() - 1);
            }
            return answer.trim();
        }
        return null;
    }

    public static String getCharsetName(Exchange exchange) {
        return IOHelper.getCharsetName(exchange, true);
    }

    public static String getCharsetName(Exchange exchange, boolean useDefault) {
        String charsetName;
        if (exchange != null && (charsetName = exchange.getProperty("CamelCharsetName", String.class)) != null) {
            return IOHelper.normalizeCharset(charsetName);
        }
        if (useDefault) {
            return IOHelper.getDefaultCharsetName();
        }
        return null;
    }

    private static String getDefaultCharsetName() {
        return ObjectHelper.getSystemProperty("org.apache.camel.default.charset", "UTF-8");
    }
}

