/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.fabric.dosgi.tcp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.fusesource.fabric.dosgi.io.TransportAcceptListener;
import org.fusesource.fabric.dosgi.io.TransportServer;
import org.fusesource.fabric.dosgi.tcp.TcpTransport;
import org.fusesource.fabric.dosgi.util.IOExceptionSupport;
import org.fusesource.fabric.dosgi.util.IntrospectionSupport;
import org.fusesource.hawtdispatch.Dispatch;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.DispatchSource;

public class TcpTransportServer
implements TransportServer {
    private final String bindScheme;
    private final InetSocketAddress bindAddress;
    private int backlog = 100;
    private Map<String, Object> transportOptions;
    private ServerSocketChannel channel;
    private TransportAcceptListener listener;
    private DispatchQueue dispatchQueue;
    private DispatchSource acceptSource;

    public TcpTransportServer(URI location) throws UnknownHostException {
        this.bindScheme = location.getScheme();
        String host = location.getHost();
        host = host == null || host.length() == 0 ? "::" : host;
        this.bindAddress = new InetSocketAddress(InetAddress.getByName(host), location.getPort());
    }

    @Override
    public void setAcceptListener(TransportAcceptListener listener) {
        this.listener = listener;
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
    }

    @Override
    public DispatchQueue getDispatchQueue() {
        return this.dispatchQueue;
    }

    @Override
    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        this.dispatchQueue = dispatchQueue;
    }

    @Override
    public void suspend() {
        this.acceptSource.suspend();
    }

    @Override
    public void resume() {
        this.acceptSource.resume();
    }

    @Override
    public void start() throws Exception {
        this.start(null);
    }

    @Override
    public void start(Runnable onCompleted) throws Exception {
        try {
            this.channel = ServerSocketChannel.open();
            this.channel.configureBlocking(false);
            this.channel.socket().bind(this.bindAddress, this.backlog);
        }
        catch (IOException e) {
            throw IOExceptionSupport.create("Failed to bind to server socket: " + this.bindAddress + " due to: " + e, e);
        }
        this.acceptSource = Dispatch.createSource((SelectableChannel)this.channel, (int)16, (DispatchQueue)this.dispatchQueue);
        this.acceptSource.setEventHandler(new Runnable(){

            @Override
            public void run() {
                try {
                    SocketChannel client = TcpTransportServer.this.channel.accept();
                    while (client != null) {
                        TcpTransportServer.this.handleSocket(client);
                        client = TcpTransportServer.this.channel.accept();
                    }
                }
                catch (Exception e) {
                    TcpTransportServer.this.listener.onAcceptError(TcpTransportServer.this, e);
                }
            }
        });
        this.acceptSource.setCancelHandler(new Runnable(){

            @Override
            public void run() {
                try {
                    TcpTransportServer.this.channel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.acceptSource.resume();
        if (onCompleted != null) {
            this.dispatchQueue.execute(onCompleted);
        }
    }

    @Override
    public String getBoundAddress() {
        try {
            return new URI(this.bindScheme, null, this.bindAddress.getAddress().getHostAddress(), this.channel.socket().getLocalPort(), null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getConnectAddress() {
        try {
            return new URI(this.bindScheme, null, this.resolveHostName(), this.channel.socket().getLocalPort(), null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected String resolveHostName() {
        String result;
        if (this.bindAddress.getAddress().isAnyLocalAddress()) {
            try {
                result = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                result = "localhost";
            }
        } else {
            result = this.bindAddress.getAddress().getCanonicalHostName();
        }
        return result;
    }

    @Override
    public void stop() {
        this.stop(null);
    }

    @Override
    public void stop(final Runnable onCompleted) {
        if (this.acceptSource.isCanceled()) {
            onCompleted.run();
        } else {
            this.acceptSource.setCancelHandler(new Runnable(){

                @Override
                public void run() {
                    try {
                        TcpTransportServer.this.channel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (onCompleted != null) {
                        onCompleted.run();
                    }
                }
            });
            this.acceptSource.cancel();
        }
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    protected final void handleSocket(SocketChannel socket) throws Exception {
        HashMap<String, Object> options = new HashMap<String, Object>();
        TcpTransport transport = this.createTransport(socket, options);
        this.listener.onAccept(this, transport);
    }

    protected TcpTransport createTransport(SocketChannel socketChannel, HashMap<String, Object> options) throws Exception {
        TcpTransport transport = this.createTransport();
        transport.connected(socketChannel);
        if (options != null) {
            IntrospectionSupport.setProperties(transport, options);
        }
        if (this.transportOptions != null) {
            IntrospectionSupport.setProperties(transport, this.transportOptions);
        }
        return transport;
    }

    protected TcpTransport createTransport() {
        return new TcpTransport();
    }

    public void setTransportOption(Map<String, Object> transportOptions) {
        this.transportOptions = transportOptions;
    }

    public String toString() {
        return this.getBoundAddress();
    }
}

