/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.karaf.commands;

import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Route;
import org.apache.camel.karaf.commands.CamelController;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.util.StringEscapeUtils;

@Command(scope="camel", name="context-info", description="Display detailed information about a Camel context.")
public class ContextInfo
extends OsgiCommandSupport {
    @Argument(index=0, name="name", description="The name of the Camel context", required=true, multiValued=false)
    String name;
    private CamelController camelController;

    public void setCamelController(CamelController camelController) {
        this.camelController = camelController;
    }

    public Object doExecute() throws Exception {
        CamelContext camelContext = this.camelController.getCamelContext(this.name);
        if (camelContext == null) {
            System.err.println("Camel context " + this.name + " not found.");
            return null;
        }
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1m\u001b[33mCamel Context " + this.name + "\u001b[0m"));
        System.out.println(StringEscapeUtils.unescapeJava("\tName: " + camelContext.getName()));
        System.out.println(StringEscapeUtils.unescapeJava("\tVersion: " + camelContext.getVersion()));
        System.out.println(StringEscapeUtils.unescapeJava("\tStatus: " + camelContext.getStatus()));
        System.out.println(StringEscapeUtils.unescapeJava("\tUptime: " + camelContext.getUptime()));
        MBeanServer mBeanServer = camelContext.getManagementStrategy().getManagementAgent().getMBeanServer();
        Set<ObjectName> set = mBeanServer.queryNames(new ObjectName("org.apache.camel:type=context,name=\"" + this.name + "\",*"), null);
        Iterator<ObjectName> iterator = set.iterator();
        if (iterator.hasNext()) {
            ObjectName contextMBean = iterator.next();
            String load01 = (String)mBeanServer.getAttribute(contextMBean, "Load01");
            String load05 = (String)mBeanServer.getAttribute(contextMBean, "Load05");
            String load15 = (String)mBeanServer.getAttribute(contextMBean, "Load15");
            System.out.println(StringEscapeUtils.unescapeJava("\tLoad Avg: " + load01 + ", " + load05 + ", " + load15));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mAdvanced\u001b[0m"));
        System.out.println(StringEscapeUtils.unescapeJava("\tAuto Startup: " + camelContext.isAutoStartup()));
        System.out.println(StringEscapeUtils.unescapeJava("\tStarting Routes: " + camelContext.isStartingRoutes()));
        System.out.println(StringEscapeUtils.unescapeJava("\tSuspended: " + camelContext.isSuspended()));
        System.out.println(StringEscapeUtils.unescapeJava("\tTracing: " + camelContext.isTracing()));
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mProperties\u001b[0m"));
        for (String property : camelContext.getProperties().keySet()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + property + " = " + (String)camelContext.getProperties().get(property)));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mComponents\u001b[0m"));
        for (String component : camelContext.getComponentNames()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + component));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mEndpoints\u001b[0m"));
        for (Endpoint endpoint : camelContext.getEndpoints()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + endpoint.getEndpointUri()));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mRoutes\u001b[0m"));
        for (Route route : camelContext.getRoutes()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + route.getId()));
        }
        System.out.println("");
        System.out.println(StringEscapeUtils.unescapeJava("\u001b[1mUsed Languages\u001b[0m"));
        for (String language : camelContext.getLanguageNames()) {
            System.out.println(StringEscapeUtils.unescapeJava("\t" + language));
        }
        return null;
    }
}

