/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Stack;
import org.rrd4j.core.Util;

public class XmlWriter {
    static final String INDENT_STR = "   ";
    private PrintWriter writer;
    private StringBuilder indent = new StringBuilder("");
    private Stack<String> openTags = new Stack();

    public XmlWriter(OutputStream stream) {
        this.writer = new PrintWriter(stream, true);
    }

    public void startTag(String tag) {
        this.writer.println(this.indent + "<" + tag + ">");
        this.openTags.push(tag);
        this.indent.append(INDENT_STR);
    }

    public void closeTag() {
        String tag = this.openTags.pop();
        this.indent.setLength(this.indent.length() - INDENT_STR.length());
        this.writer.println(this.indent + "</" + tag + ">");
    }

    public void writeTag(String tag, Object value) {
        if (value != null) {
            this.writer.println(this.indent + "<" + tag + ">" + XmlWriter.escape(value.toString()) + "</" + tag + ">");
        } else {
            this.writer.println(this.indent + "<" + tag + "></" + tag + ">");
        }
    }

    public void writeTag(String tag, int value) {
        this.writeTag(tag, "" + value);
    }

    public void writeTag(String tag, long value) {
        this.writeTag(tag, "" + value);
    }

    public void writeTag(String tag, double value, String nanString) {
        this.writeTag(tag, Util.formatDouble(value, nanString, true));
    }

    public void writeTag(String tag, double value) {
        this.writeTag(tag, Util.formatDouble(value, true));
    }

    public void writeTag(String tag, boolean value) {
        this.writeTag(tag, "" + value);
    }

    public void writeTag(String tag, Color value) {
        int rgb = value.getRGB() & 0xFFFFFF;
        this.writeTag(tag, "#" + Integer.toHexString(rgb).toUpperCase());
    }

    public void writeTag(String tag, Font value) {
        this.startTag(tag);
        this.writeTag("name", value.getName());
        int style = value.getStyle();
        if ((style & 1) != 0 && (style & 2) != 0) {
            this.writeTag("style", "BOLDITALIC");
        } else if ((style & 1) != 0) {
            this.writeTag("style", "BOLD");
        } else if ((style & 2) != 0) {
            this.writeTag("style", "ITALIC");
        } else {
            this.writeTag("style", "PLAIN");
        }
        this.writeTag("size", value.getSize());
        this.closeTag();
    }

    public void writeTag(String tag, File value) {
        this.writeTag(tag, value.getPath());
    }

    public void flush() {
        this.writer.flush();
    }

    protected void finalize() {
        this.writer.close();
    }

    public void writeComment(Object comment) {
        this.writer.println(this.indent + "<!-- " + XmlWriter.escape(comment.toString()) + " -->");
    }

    private static String escape(String s) {
        return s.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }
}

