/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.data;

import java.util.Calendar;
import java.util.Date;
import org.rrd4j.core.Util;
import org.rrd4j.data.Plottable;

public class LinearInterpolator
extends Plottable {
    public static final int INTERPOLATE_LEFT = 0;
    public static final int INTERPOLATE_RIGHT = 1;
    public static final int INTERPOLATE_LINEAR = 2;
    public static final int INTERPOLATE_REGRESSION = 3;
    private int lastIndexUsed = 0;
    private int interpolationMethod = 2;
    private long[] timestamps;
    private double[] values;
    double b0 = Double.NaN;
    double b1 = Double.NaN;

    public LinearInterpolator(long[] timestamps, double[] values) {
        this.timestamps = timestamps;
        this.values = values;
        this.validate();
    }

    public LinearInterpolator(Date[] dates, double[] values) {
        this.values = values;
        this.timestamps = new long[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            this.timestamps[i] = Util.getTimestamp(dates[i]);
        }
        this.validate();
    }

    public LinearInterpolator(Calendar[] dates, double[] values) {
        this.values = values;
        this.timestamps = new long[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            this.timestamps[i] = Util.getTimestamp(dates[i]);
        }
        this.validate();
    }

    private void validate() {
        boolean ok = true;
        if (this.timestamps.length != this.values.length || this.timestamps.length < 2) {
            ok = false;
        }
        for (int i = 0; i < this.timestamps.length - 1 && ok; ++i) {
            if (this.timestamps[i] < this.timestamps[i + 1]) continue;
            ok = false;
        }
        if (!ok) {
            throw new IllegalArgumentException("Invalid plottable data supplied");
        }
    }

    public void setInterpolationMethod(int interpolationMethod) {
        switch (interpolationMethod) {
            case 3: {
                this.calculateBestFitLine();
            }
            case 0: 
            case 1: 
            case 2: {
                this.interpolationMethod = interpolationMethod;
                break;
            }
            default: {
                this.interpolationMethod = 2;
            }
        }
    }

    private void calculateBestFitLine() {
        int count = this.timestamps.length;
        int validCount = 0;
        double ts = 0.0;
        double vs = 0.0;
        for (int i = 0; i < count; ++i) {
            if (Double.isNaN(this.values[i])) continue;
            ts += (double)this.timestamps[i];
            vs += this.values[i];
            ++validCount;
        }
        if (validCount <= 1) {
            this.b1 = Double.NaN;
            this.b0 = Double.NaN;
            return;
        }
        ts /= (double)validCount;
        vs /= (double)validCount;
        double s1 = 0.0;
        double s2 = 0.0;
        for (int i = 0; i < count; ++i) {
            if (Double.isNaN(this.values[i])) continue;
            double dt = (double)this.timestamps[i] - ts;
            double dv = this.values[i] - vs;
            s1 += dt * dv;
            s2 += dt * dt;
        }
        this.b1 = s1 / s2;
        this.b0 = vs - this.b1 * ts;
    }

    public double getValue(long timestamp) {
        if (this.interpolationMethod == 3) {
            return this.b0 + this.b1 * (double)timestamp;
        }
        int count = this.timestamps.length;
        if (timestamp < this.timestamps[0] || timestamp > this.timestamps[count - 1]) {
            return Double.NaN;
        }
        int startIndex = this.lastIndexUsed;
        if (timestamp < this.timestamps[this.lastIndexUsed]) {
            startIndex = 0;
        }
        for (int i = startIndex; i < count; ++i) {
            if (this.timestamps[i] == timestamp) {
                return this.values[i];
            }
            if (i >= count - 1 || this.timestamps[i] >= timestamp || timestamp >= this.timestamps[i + 1]) continue;
            this.lastIndexUsed = i;
            switch (this.interpolationMethod) {
                case 0: {
                    return this.values[i];
                }
                case 1: {
                    return this.values[i + 1];
                }
                case 2: {
                    double slope = (this.values[i + 1] - this.values[i]) / (double)(this.timestamps[i + 1] - this.timestamps[i]);
                    return this.values[i] + slope * (double)(timestamp - this.timestamps[i]);
                }
            }
            return Double.NaN;
        }
        return Double.NaN;
    }
}

