/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser;

import java.util.List;
import org.apache.lucene.queryParser.QueryParserSettings;
import org.elasticsearch.common.trove.map.hash.TObjectFloatHashMap;

public class MultiFieldQueryParserSettings
extends QueryParserSettings {
    List<String> fields = null;
    TObjectFloatHashMap<String> boosts = null;
    float tieBreaker = 0.0f;
    boolean useDisMax = true;

    public List<String> fields() {
        return this.fields;
    }

    public void fields(List<String> fields) {
        this.fields = fields;
    }

    public TObjectFloatHashMap<String> boosts() {
        return this.boosts;
    }

    public void boosts(TObjectFloatHashMap<String> boosts) {
        this.boosts = boosts;
    }

    public float tieBreaker() {
        return this.tieBreaker;
    }

    public void tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
    }

    public boolean useDisMax() {
        return this.useDisMax;
    }

    public void useDisMax(boolean useDisMax) {
        this.useDisMax = useDisMax;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.fields == null || this.fields.size() == 1) {
            return super.equals(o);
        }
        if (!super.equals(o)) {
            return false;
        }
        MultiFieldQueryParserSettings that = (MultiFieldQueryParserSettings)o;
        if (Float.compare(that.tieBreaker, this.tieBreaker) != 0) {
            return false;
        }
        if (this.useDisMax != that.useDisMax) {
            return false;
        }
        if (this.boosts != null ? !this.boosts.equals(that.boosts) : that.boosts != null) {
            return false;
        }
        return !(this.fields != null ? !((Object)this.fields).equals(that.fields) : that.fields != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.fields != null ? ((Object)this.fields).hashCode() : 0);
        result = 31 * result + (this.boosts != null ? this.boosts.hashCode() : 0);
        result = 31 * result + (this.tieBreaker != 0.0f ? Float.floatToIntBits(this.tieBreaker) : 0);
        result = 31 * result + (this.useDisMax ? 1 : 0);
        return result;
    }
}

