/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DeletionAwareConstantScoreQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilteredQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.MultiTermQueryWrapperFilter;
import org.apache.lucene.search.PublicTermsFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.elasticsearch.common.lucene.search.TermFilter;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;

public class CustomFieldQuery
extends FieldQuery {
    private static Field multiTermQueryWrapperFilterQueryField;
    public static final ThreadLocal<IndexReader> reader;
    public static final ThreadLocal<Boolean> highlightFilters;

    public CustomFieldQuery(Query query, FastVectorHighlighter highlighter) {
        this(query, highlighter.isPhraseHighlight(), highlighter.isFieldMatch());
    }

    public CustomFieldQuery(Query query, boolean phraseHighlight, boolean fieldMatch) {
        super(query, phraseHighlight, fieldMatch);
        reader.remove();
        highlightFilters.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void flatten(Query sourceQuery, Collection<Query> flatQueries) {
        if (sourceQuery instanceof DisjunctionMaxQuery) {
            DisjunctionMaxQuery dmq = (DisjunctionMaxQuery)sourceQuery;
            for (Query query : dmq) {
                this.flatten(query, flatQueries);
            }
        } else if (sourceQuery instanceof SpanTermQuery) {
            TermQuery termQuery = new TermQuery(((SpanTermQuery)sourceQuery).getTerm());
            if (!flatQueries.contains(termQuery)) {
                flatQueries.add(termQuery);
            }
        } else if (sourceQuery instanceof ConstantScoreQuery) {
            ConstantScoreQuery constantScoreQuery = (ConstantScoreQuery)sourceQuery;
            if (constantScoreQuery.getFilter() != null) {
                this.flatten(constantScoreQuery.getFilter(), flatQueries);
            } else {
                this.flatten(constantScoreQuery.getQuery(), flatQueries);
            }
        } else if (sourceQuery instanceof DeletionAwareConstantScoreQuery) {
            this.flatten(((DeletionAwareConstantScoreQuery)sourceQuery).getFilter(), flatQueries);
        } else if (sourceQuery instanceof FunctionScoreQuery) {
            this.flatten(((FunctionScoreQuery)sourceQuery).getSubQuery(), flatQueries);
        } else if (sourceQuery instanceof MultiTermQuery) {
            MultiTermQuery multiTermQuery = (MultiTermQuery)sourceQuery;
            MultiTermQuery.RewriteMethod rewriteMethod = multiTermQuery.getRewriteMethod();
            multiTermQuery.setRewriteMethod(MultiTermQuery.SCORING_BOOLEAN_QUERY_REWRITE);
            try {
                this.flatten(multiTermQuery.rewrite(reader.get()), flatQueries);
            }
            catch (IOException e) {
            }
            catch (BooleanQuery.TooManyClauses e) {
            }
            finally {
                multiTermQuery.setRewriteMethod(rewriteMethod);
            }
        } else if (sourceQuery instanceof FilteredQuery) {
            this.flatten(((FilteredQuery)sourceQuery).getQuery(), flatQueries);
            this.flatten(((FilteredQuery)sourceQuery).getFilter(), flatQueries);
        } else {
            super.flatten(sourceQuery, flatQueries);
        }
    }

    void flatten(Filter sourceFilter, Collection<Query> flatQueries) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        Boolean highlight = highlightFilters.get();
                        if (highlight == null || highlight.equals(Boolean.FALSE)) {
                            return;
                        }
                        if (!(sourceFilter instanceof TermFilter)) break block7;
                        this.flatten(new TermQuery(((TermFilter)sourceFilter).getTerm()), flatQueries);
                        break block8;
                    }
                    if (!(sourceFilter instanceof PublicTermsFilter)) break block9;
                    PublicTermsFilter termsFilter = (PublicTermsFilter)sourceFilter;
                    for (Term term : termsFilter.getTerms()) {
                        this.flatten(new TermQuery(term), flatQueries);
                    }
                    break block8;
                }
                if (!(sourceFilter instanceof MultiTermQueryWrapperFilter)) break block10;
                if (multiTermQueryWrapperFilterQueryField == null) break block8;
                try {
                    this.flatten((Query)multiTermQueryWrapperFilterQueryField.get(sourceFilter), flatQueries);
                }
                catch (IllegalAccessException e) {}
                break block8;
            }
            if (sourceFilter instanceof XBooleanFilter) {
                XBooleanFilter booleanFilter = (XBooleanFilter)sourceFilter;
                for (Filter filter : booleanFilter.getMustFilters()) {
                    this.flatten(filter, flatQueries);
                }
                for (Filter filter : booleanFilter.getNotFilters()) {
                    this.flatten(filter, flatQueries);
                }
            }
        }
    }

    static {
        try {
            multiTermQueryWrapperFilterQueryField = MultiTermQueryWrapperFilter.class.getDeclaredField("query");
            multiTermQueryWrapperFilterQueryField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        reader = new ThreadLocal();
        highlightFilters = new ThreadLocal();
    }
}

