/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.cache.clear;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class ShardClearIndicesCacheRequest
extends BroadcastShardOperationRequest {
    private boolean filterCache = false;
    private boolean fieldDataCache = false;
    private boolean idCache = false;
    private boolean bloomCache = false;

    ShardClearIndicesCacheRequest() {
    }

    public ShardClearIndicesCacheRequest(String index, int shardId, ClearIndicesCacheRequest request) {
        super(index, shardId);
        this.filterCache = request.filterCache();
        this.fieldDataCache = request.fieldDataCache();
        this.idCache = request.idCache();
        this.bloomCache = request.bloomCache();
    }

    public boolean filterCache() {
        return this.filterCache;
    }

    public boolean fieldDataCache() {
        return this.fieldDataCache;
    }

    public boolean idCache() {
        return this.idCache;
    }

    public boolean bloomCache() {
        return this.bloomCache;
    }

    public ShardClearIndicesCacheRequest waitForOperations(boolean waitForOperations) {
        this.filterCache = waitForOperations;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.filterCache = in.readBoolean();
        this.fieldDataCache = in.readBoolean();
        this.idCache = in.readBoolean();
        this.bloomCache = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.filterCache);
        out.writeBoolean(this.fieldDataCache);
        out.writeBoolean(this.idCache);
        out.writeBoolean(this.bloomCache);
    }
}

