/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.inject;

import java.util.Collection;
import org.elasticsearch.common.inject.internal.Errors;
import org.elasticsearch.common.inject.internal.ImmutableSet;
import org.elasticsearch.common.inject.internal.Preconditions;
import org.elasticsearch.common.inject.spi.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfigurationException
extends RuntimeException {
    private final ImmutableSet<Message> messages;
    private Object partialValue = null;
    private static final long serialVersionUID = 0L;

    public ConfigurationException(Iterable<Message> messages) {
        this.messages = ImmutableSet.copyOf(messages);
        this.initCause(Errors.getOnlyCause(this.messages));
    }

    public ConfigurationException withPartialValue(Object partialValue) {
        Preconditions.checkState(this.partialValue == null, "Can't clobber existing partial value %s with %s", this.partialValue, partialValue);
        ConfigurationException result = new ConfigurationException(this.messages);
        result.partialValue = partialValue;
        return result;
    }

    public Collection<Message> getErrorMessages() {
        return this.messages;
    }

    public <E> E getPartialValue() {
        return (E)this.partialValue;
    }

    @Override
    public String getMessage() {
        return Errors.format("Guice configuration errors", this.messages);
    }
}

