/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.EOFException;
import java.io.IOException;
import org.elasticsearch.common.compress.lzf.BufferRecycler;
import org.elasticsearch.common.compress.lzf.LZFDecoder;
import org.elasticsearch.common.io.stream.StreamInput;

public class LZFStreamInput
extends StreamInput {
    private final BufferRecycler _recycler;
    protected StreamInput inputStream;
    protected boolean cfgFullReads = true;
    private byte[] _inputBuffer;
    private byte[] _decodedBytes;
    private int bufferPosition = 0;
    private int bufferLength = 0;
    private final boolean cached;

    public LZFStreamInput(StreamInput in, boolean cached) {
        this.cached = cached;
        this._recycler = cached ? new BufferRecycler() : BufferRecycler.instance();
        this.inputStream = in;
        this._inputBuffer = this._recycler.allocInputBuffer(65535);
        this._decodedBytes = this._recycler.allocDecodeBuffer(65535);
    }

    @Override
    public int read() throws IOException {
        this.readyBuffer();
        if (this.bufferPosition < this.bufferLength) {
            return this._decodedBytes[this.bufferPosition++] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 1) {
            return 0;
        }
        this.readyBuffer();
        if (this.bufferLength < 0) {
            return -1;
        }
        int chunkLength = Math.min(this.bufferLength - this.bufferPosition, length);
        System.arraycopy(this._decodedBytes, this.bufferPosition, buffer, offset, chunkLength);
        this.bufferPosition += chunkLength;
        if (chunkLength == length || !this.cfgFullReads) {
            return chunkLength;
        }
        int totalRead = chunkLength;
        do {
            offset += chunkLength;
            this.readyBuffer();
            if (this.bufferLength == -1) break;
            chunkLength = Math.min(this.bufferLength - this.bufferPosition, length - totalRead);
            System.arraycopy(this._decodedBytes, this.bufferPosition, buffer, offset, chunkLength);
            this.bufferPosition += chunkLength;
        } while ((totalRead += chunkLength) < length);
        return totalRead;
    }

    @Override
    public byte readByte() throws IOException {
        this.readyBuffer();
        if (this.bufferPosition < this.bufferLength) {
            return this._decodedBytes[this.bufferPosition++];
        }
        throw new EOFException();
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int result = this.read(b, offset, len);
        if (result < len) {
            throw new EOFException();
        }
    }

    @Override
    public void reset() throws IOException {
        this.bufferPosition = 0;
        this.bufferLength = 0;
        this.inputStream.reset();
    }

    public void reset(StreamInput in) throws IOException {
        this.inputStream = in;
        this.bufferPosition = 0;
        this.bufferLength = 0;
    }

    public void resetToBufferStart() {
        this.bufferPosition = 0;
    }

    @Override
    public void close() throws IOException {
        if (this.cached) {
            this.reset();
            return;
        }
        this.bufferLength = 0;
        this.bufferPosition = 0;
        byte[] buf = this._inputBuffer;
        if (buf != null) {
            this._inputBuffer = null;
            this._recycler.releaseInputBuffer(buf);
        }
        if ((buf = this._decodedBytes) != null) {
            this._decodedBytes = null;
            this._recycler.releaseDecodeBuffer(buf);
        }
        this.inputStream.close();
    }

    private void readyBuffer() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.bufferLength = LZFDecoder.decompressChunk(this.inputStream, this._inputBuffer, this._decodedBytes);
            this.bufferPosition = 0;
        }
    }
}

