/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.jsr166y;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.common.util.concurrent.jsr166y.ForkJoinTask;
import org.elasticsearch.common.util.concurrent.jsr166y.ForkJoinWorkerThread;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;
import org.elasticsearch.common.util.concurrent.jsr166y.Phaser;
import org.elasticsearch.common.util.concurrent.jsr166y.RecursiveAction;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory = new DefaultForkJoinWorkerThreadFactory();
    private static final RuntimePermission modifyThreadPermission = new RuntimePermission("modifyThread");
    private static final AtomicInteger poolNumberGenerator = new AtomicInteger();
    private static final long JOIN_TIMEOUT_MILLIS = 250L;
    private static final long SHRINK_RATE_NANOS = 30000000000L;
    private static final int MAX_WORKERS = Short.MAX_VALUE;
    volatile ForkJoinWorkerThread[] workers;
    private final LinkedTransferQueue<ForkJoinTask<?>> submissionQueue;
    private final ReentrantLock workerLock;
    private final Phaser termination;
    private final ForkJoinWorkerThreadFactory factory;
    private volatile long stealCount;
    private volatile long eventWaiters;
    private static final int EVENT_COUNT_SHIFT = 32;
    private static final int WAITER_ID_MASK = 65535;
    private volatile int eventCount;
    private volatile int spareWaiters;
    private static final int SPARE_COUNT_SHIFT = 16;
    private static final int SPARE_ID_MASK = 65535;
    volatile int runState;
    private static final int RUNLEVEL_SHIFT = 16;
    private static final int SHUTDOWN = 65536;
    private static final int TERMINATING = 131072;
    private static final int TERMINATED = 262144;
    private static final int ACTIVE_COUNT_MASK = 65535;
    private volatile int workerCounts;
    private static final int TOTAL_COUNT_SHIFT = 16;
    private static final int RUNNING_COUNT_MASK = 65535;
    private static final int ONE_RUNNING = 1;
    private static final int ONE_TOTAL = 65536;
    final int parallelism;
    final boolean locallyFifo;
    private final Thread.UncaughtExceptionHandler ueh;
    private final int poolNumber;
    private static final Unsafe UNSAFE = ForkJoinPool.getUnsafe();
    private static final long workerCountsOffset = ForkJoinPool.objectFieldOffset("workerCounts", ForkJoinPool.class);
    private static final long runStateOffset = ForkJoinPool.objectFieldOffset("runState", ForkJoinPool.class);
    private static final long eventCountOffset = ForkJoinPool.objectFieldOffset("eventCount", ForkJoinPool.class);
    private static final long eventWaitersOffset = ForkJoinPool.objectFieldOffset("eventWaiters", ForkJoinPool.class);
    private static final long stealCountOffset = ForkJoinPool.objectFieldOffset("stealCount", ForkJoinPool.class);
    private static final long spareWaitersOffset = ForkJoinPool.objectFieldOffset("spareWaiters", ForkJoinPool.class);

    private static void checkPermission() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(modifyThreadPermission);
        }
    }

    final void incrementRunningCount() {
        int c;
        while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, c = this.workerCounts, c + 1)) {
        }
    }

    final boolean tryIncrementRunningCount() {
        int c = this.workerCounts;
        return UNSAFE.compareAndSwapInt(this, workerCountsOffset, c, c + 1);
    }

    final boolean tryDecrementRunningCount() {
        int wc = this.workerCounts;
        if ((wc & 0xFFFF) == 0) {
            return false;
        }
        return UNSAFE.compareAndSwapInt(this, workerCountsOffset, wc, wc - 1);
    }

    private void decrementWorkerCounts(int dr, int dt) {
        int wc;
        do {
            if (((wc = this.workerCounts) & 0xFFFF) - dr >= 0 && (wc >>> 16) - dt >= 0) continue;
            if ((this.runState & 0x40000) != 0) {
                return;
            }
            Thread.yield();
        } while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, wc, wc - (dr + dt)));
    }

    final boolean tryDecrementActiveCount() {
        int c = this.runState;
        return UNSAFE.compareAndSwapInt(this, runStateOffset, c, c - 1);
    }

    private boolean advanceRunLevel(int level) {
        int s;
        do {
            if (((s = this.runState) & level) == 0) continue;
            return false;
        } while (!UNSAFE.compareAndSwapInt(this, runStateOffset, s, s | level));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int recordWorker(ForkJoinWorkerThread w) {
        int k = (this.workerCounts >>> 16) - 1;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            int n = ws.length;
            if (k < 0 || k >= n || ws[k] != null) {
                for (k = 0; k < n && ws[k] != null; ++k) {
                }
                if (k == n) {
                    ws = this.workers = Arrays.copyOf(ws, n << 1);
                }
            }
            ws[k] = w;
            int c = this.eventCount;
            UNSAFE.compareAndSwapInt(this, eventCountOffset, c, c + 1);
        }
        finally {
            lock.unlock();
        }
        return k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forgetWorker(ForkJoinWorkerThread w) {
        int idx = w.poolIndex;
        ReentrantLock lock = this.workerLock;
        lock.lock();
        try {
            ForkJoinWorkerThread[] ws = this.workers;
            if (idx >= 0 && idx < ws.length && ws[idx] == w) {
                ws[idx] = null;
            }
        }
        finally {
            lock.unlock();
        }
    }

    final void workerTerminated(ForkJoinWorkerThread w) {
        this.forgetWorker(w);
        this.decrementWorkerCounts(w.isTrimmed() ? 0 : 1, 65536);
        while (w.stealCount != 0) {
            this.tryAccumulateStealCount(w);
        }
        this.tryTerminate(false);
    }

    private void releaseEventWaiters() {
        ForkJoinWorkerThread w;
        int id;
        ForkJoinWorkerThread[] ws = this.workers;
        int n = ws.length;
        long h = this.eventWaiters;
        int ec = this.eventCount;
        int releases = 4;
        while ((id = ((int)h & 0xFFFF) - 1) >= 0 && (int)(h >>> 32) != ec && id < n && (w = ws[id]) != null) {
            if (UNSAFE.compareAndSwapLong(this, eventWaitersOffset, h, w.nextWaiter)) {
                LockSupport.unpark(w);
                if (--releases == 0) break;
            }
            if (this.eventCount != ec) break;
            h = this.eventWaiters;
        }
    }

    final void signalWork() {
        int c = this.eventCount;
        UNSAFE.compareAndSwapInt(this, eventCountOffset, c, c + 1);
        if (this.eventWaiters != 0L) {
            this.releaseEventWaiters();
        }
    }

    private void eventSync(ForkJoinWorkerThread w, int ec) {
        long h;
        long nh = (long)ec << 32 | (long)(w.poolIndex + 1);
        while (!(this.runState >= 65536 && this.tryTerminate(false) || ((int)(h = this.eventWaiters) & 0xFFFF) != 0 && (int)(h >>> 32) != ec || this.eventCount != ec)) {
            w.nextWaiter = h;
            if (!UNSAFE.compareAndSwapLong(this, eventWaitersOffset, w.nextWaiter, nh)) continue;
            this.awaitEvent(w, ec);
            break;
        }
    }

    private void awaitEvent(ForkJoinWorkerThread w, int ec) {
        while (this.eventCount == ec) {
            if (!this.tryAccumulateStealCount(w)) continue;
            boolean untimed = w.nextWaiter != 0L || (this.workerCounts & 0xFFFF) <= 1;
            long startTime = untimed ? 0L : System.nanoTime();
            Thread.interrupted();
            if (w.isTerminating() || this.eventCount != ec) break;
            if (untimed) {
                LockSupport.park(w);
                continue;
            }
            LockSupport.parkNanos(w, 30000000000L);
            if (this.eventCount != ec || w.isTerminating()) break;
            if (System.nanoTime() - startTime < 30000000000L) continue;
            this.tryShutdownUnusedWorker(ec);
        }
    }

    final void pushSpare(ForkJoinWorkerThread w) {
        int ns = ++w.spareCount << 16 | w.poolIndex + 1;
        while (!UNSAFE.compareAndSwapInt(this, spareWaitersOffset, w.nextSpare = this.spareWaiters, ns)) {
        }
    }

    private void tryResumeSpare() {
        ForkJoinWorkerThread w;
        int id;
        ForkJoinWorkerThread[] ws = this.workers;
        int n = ws.length;
        int sw = this.spareWaiters;
        if (sw != 0 && (id = (sw & 0xFFFF) - 1) >= 0 && id < n && (w = ws[id]) != null && (this.runState >= 131072 || (this.workerCounts & 0xFFFF) < this.parallelism) && this.spareWaiters == sw && UNSAFE.compareAndSwapInt(this, spareWaitersOffset, sw, w.nextSpare)) {
            int c;
            while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, c = this.workerCounts, c + 1)) {
            }
            if (w.tryUnsuspend()) {
                LockSupport.unpark(w);
            } else {
                this.decrementWorkerCounts(1, 0);
            }
        }
    }

    private void helpMaintainParallelism() {
        int rs;
        int wc;
        int pc = this.parallelism;
        while (((wc = this.workerCounts) & 0xFFFF) < pc && (rs = this.runState) < 131072) {
            if (this.spareWaiters != 0) {
                this.tryResumeSpare();
                continue;
            }
            int tc = wc >>> 16;
            if (tc >= Short.MAX_VALUE || tc >= pc && (rs & 0xFFFF) != tc) break;
            if (this.runState != rs || this.workerCounts != wc || !UNSAFE.compareAndSwapInt(this, workerCountsOffset, wc, wc + 65537)) continue;
            ForkJoinWorkerThread w = null;
            Throwable fail = null;
            try {
                w = this.factory.newThread(this);
            }
            catch (Throwable ex) {
                fail = ex;
            }
            if (w == null) {
                this.decrementWorkerCounts(1, 65536);
                this.tryTerminate(false);
                if (fail == null || this.runState >= 131072 || Thread.currentThread() instanceof ForkJoinWorkerThread) break;
                UNSAFE.throwException(fail);
                break;
            }
            w.start(this.recordWorker(w), this.ueh);
            if (this.workerCounts >>> 16 < pc) continue;
            break;
        }
        if (this.eventWaiters != 0L) {
            this.releaseEventWaiters();
        }
    }

    private void tryShutdownUnusedWorker(int ec) {
        if (this.runState == 0 && this.eventCount == ec) {
            ForkJoinWorkerThread[] ws = this.workers;
            int n = ws.length;
            ForkJoinWorkerThread w = null;
            boolean shutdown = false;
            int sw = this.spareWaiters;
            if (sw != 0) {
                int id = (sw & 0xFFFF) - 1;
                if (id >= 0 && id < n && (w = ws[id]) != null && UNSAFE.compareAndSwapInt(this, spareWaitersOffset, sw, w.nextSpare)) {
                    shutdown = true;
                }
            } else {
                long nh;
                int id;
                long h = this.eventWaiters;
                if (h != 0L && (id = ((int)h & 0xFFFF) - 1) >= 0 && id < n && (w = ws[id]) != null && (nh = w.nextWaiter) != 0L && UNSAFE.compareAndSwapLong(this, eventWaitersOffset, h, nh)) {
                    shutdown = true;
                }
            }
            if (w != null && shutdown) {
                w.shutdown();
                LockSupport.unpark(w);
            }
        }
        this.releaseEventWaiters();
    }

    final void preStep(ForkJoinWorkerThread w, boolean ran) {
        int wec = w.lastEventCount;
        boolean active = w.active;
        boolean inactivate = false;
        int pc = this.parallelism;
        while (w.runState == 0) {
            int wc;
            int rs = this.runState;
            if (rs >= 131072) {
                w.shutdown();
                break;
            }
            if ((inactivate || active && (rs & 0xFFFF) >= pc) && UNSAFE.compareAndSwapInt(this, runStateOffset, rs--, rs)) {
                w.active = false;
                active = false;
                inactivate = false;
                if (rs == 65536) {
                    this.tryTerminate(false);
                    continue;
                }
            }
            if (((wc = this.workerCounts) & 0xFFFF) > pc) {
                if ((inactivate |= active) || this.workerCounts != wc || !UNSAFE.compareAndSwapInt(this, workerCountsOffset, wc, wc - 1)) continue;
                w.suspendAsSpare();
                continue;
            }
            if (wc >>> 16 < pc) {
                this.helpMaintainParallelism();
                continue;
            }
            if (ran) break;
            long h = this.eventWaiters;
            int ec = this.eventCount;
            if (h != 0L && (int)(h >>> 32) != ec) {
                this.releaseEventWaiters();
                continue;
            }
            if (ec != wec) {
                w.lastEventCount = ec;
                break;
            }
            if (inactivate |= active) continue;
            this.eventSync(w, wec);
        }
    }

    final void awaitJoin(ForkJoinTask<?> joinMe, ForkJoinWorkerThread worker, boolean timed, long nanos) {
        long startTime = timed ? System.nanoTime() : 0L;
        int retries = 2 + (this.parallelism >> 2);
        boolean running = true;
        while (joinMe.status >= 0) {
            if (this.runState >= 131072) {
                joinMe.cancelIgnoringExceptions();
                break;
            }
            running = worker.helpJoinTask(joinMe, running);
            if (joinMe.status < 0) break;
            if (retries > 0) {
                --retries;
                continue;
            }
            int wc = this.workerCounts;
            if ((wc & 0xFFFF) != 0) {
                long h;
                if (running) {
                    if (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, wc, wc - 1)) continue;
                    running = false;
                }
                if ((h = this.eventWaiters) != 0L && (int)(h >>> 32) != this.eventCount) {
                    this.releaseEventWaiters();
                }
                if ((this.workerCounts & 0xFFFF) != 0) {
                    int ns;
                    long ms;
                    if (!timed) {
                        ms = 250L;
                        ns = 0;
                    } else {
                        long nt = nanos - (System.nanoTime() - startTime);
                        if (nt <= 0L) break;
                        ms = nt / 1000000L;
                        if (ms > 250L) {
                            ms = 250L;
                            ns = 0;
                        } else {
                            ns = (int)(nt % 1000000L);
                        }
                    }
                    joinMe.internalAwaitDone(ms, ns);
                }
                if (joinMe.status < 0) break;
            }
            this.helpMaintainParallelism();
        }
        if (!running) {
            int c;
            while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, c = this.workerCounts, c + 1)) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void awaitBlocker(ManagedBlocker blocker) throws InterruptedException {
        block3: while (!blocker.isReleasable()) {
            int wc = this.workerCounts;
            if ((wc & 0xFFFF) == 0) {
                this.helpMaintainParallelism();
                continue;
            }
            if (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, wc, wc - 1)) continue;
            try {
                while (!blocker.isReleasable()) {
                    long h = this.eventWaiters;
                    if (h != 0L && (int)(h >>> 32) != this.eventCount) {
                        this.releaseEventWaiters();
                        continue;
                    }
                    if ((this.workerCounts & 0xFFFF) == 0 && this.runState < 131072) {
                        this.helpMaintainParallelism();
                        continue;
                    }
                    if (!blocker.block()) continue;
                    break block3;
                }
                break;
            }
            finally {
                int c;
                while (!UNSAFE.compareAndSwapInt(this, workerCountsOffset, c = this.workerCounts, c + 1)) {
                }
            }
        }
    }

    private boolean tryTerminate(boolean now) {
        if (now) {
            this.advanceRunLevel(65536);
        } else if (this.runState < 65536 || !this.submissionQueue.isEmpty() || (this.runState & 0xFFFF) != 0) {
            return false;
        }
        if (this.advanceRunLevel(131072)) {
            this.startTerminating();
        }
        if (this.workerCounts >>> 16 == 0) {
            this.advanceRunLevel(262144);
            this.termination.forceTermination();
        }
        return true;
    }

    private void startTerminating() {
        this.cancelSubmissions();
        for (int passes = 0; passes < 4 && this.workerCounts != 0; ++passes) {
            int c = this.eventCount;
            UNSAFE.compareAndSwapInt(this, eventCountOffset, c, c + 1);
            this.eventWaiters = 0L;
            this.spareWaiters = 0;
            for (ForkJoinWorkerThread w : this.workers) {
                if (w == null) continue;
                w.shutdown();
                if (passes <= 0 || w.isTerminated()) continue;
                w.cancelTasks();
                LockSupport.unpark(w);
                if (passes <= 1 || w.isInterrupted()) continue;
                try {
                    w.interrupt();
                }
                catch (SecurityException ignore) {
                    // empty catch block
                }
            }
        }
    }

    private void cancelSubmissions() {
        ForkJoinTask<?> task;
        while ((task = this.submissionQueue.poll()) != null) {
            try {
                task.cancel(false);
            }
            catch (Throwable throwable) {}
        }
    }

    final int getPoolNumber() {
        return this.poolNumber;
    }

    final boolean tryAccumulateStealCount(ForkJoinWorkerThread w) {
        long c = this.stealCount;
        int sc = w.stealCount;
        if (UNSAFE.compareAndSwapLong(this, stealCountOffset, c, c + (long)sc)) {
            if (sc != 0) {
                w.stealCount = 0;
            }
            return true;
        }
        return sc == 0;
    }

    final int idlePerActive() {
        int pc = this.parallelism;
        int ac = this.runState;
        return pc <= ac ? 0 : (pc >>> 1 <= ac ? 1 : (pc >>> 2 <= ac ? 3 : pc >>> 3));
    }

    public ForkJoinPool() {
        this(Runtime.getRuntime().availableProcessors(), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism) {
        this(parallelism, defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int parallelism, ForkJoinWorkerThreadFactory factory, Thread.UncaughtExceptionHandler handler, boolean asyncMode) {
        ForkJoinPool.checkPermission();
        if (factory == null) {
            throw new NullPointerException();
        }
        if (parallelism <= 0 || parallelism > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.parallelism = parallelism;
        this.factory = factory;
        this.ueh = handler;
        this.locallyFifo = asyncMode;
        int arraySize = ForkJoinPool.initialArraySizeFor(parallelism);
        this.workers = new ForkJoinWorkerThread[arraySize];
        this.submissionQueue = new LinkedTransferQueue();
        this.workerLock = new ReentrantLock();
        this.termination = new Phaser(1);
        this.poolNumber = poolNumberGenerator.incrementAndGet();
    }

    private static int initialArraySizeFor(int pc) {
        int size = pc < Short.MAX_VALUE ? pc + 1 : Short.MAX_VALUE;
        size |= size >>> 1;
        size |= size >>> 2;
        size |= size >>> 4;
        size |= size >>> 8;
        return size + 1;
    }

    private <T> void doSubmit(ForkJoinTask<T> task) {
        this.submissionQueue.offer(task);
        int c = this.eventCount;
        UNSAFE.compareAndSwapInt(this, eventCountOffset, c, c + 1);
        this.helpMaintainParallelism();
    }

    public <T> T invoke(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        if (this.runState >= 65536) {
            throw new RejectedExecutionException();
        }
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)t).pool == this) {
            return task.invoke();
        }
        this.doSubmit(task);
        return task.join();
    }

    private <T> void forkOrSubmit(ForkJoinTask<T> task) {
        if (this.runState >= 65536) {
            throw new RejectedExecutionException();
        }
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread && ((ForkJoinWorkerThread)t).pool == this) {
            task.fork();
        } else {
            this.doSubmit(task);
        }
    }

    public void execute(ForkJoinTask<?> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.forkOrSubmit(task);
    }

    @Override
    public void execute(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<Object> job = task instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)task) : ForkJoinTask.adapt(task, null);
        this.forkOrSubmit(job);
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        this.forkOrSubmit(task);
        return task;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<T> job = ForkJoinTask.adapt(task);
        this.forkOrSubmit(job);
        return job;
    }

    public <T> ForkJoinTask<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<T> job = ForkJoinTask.adapt(task, result);
        this.forkOrSubmit(job);
        return job;
    }

    public ForkJoinTask<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        ForkJoinTask<Object> job = task instanceof ForkJoinTask ? (ForkJoinTask<Object>)((Object)task) : ForkJoinTask.adapt(task, null);
        this.forkOrSubmit(job);
        return job;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> forkJoinTasks = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> task : tasks) {
            forkJoinTasks.add(ForkJoinTask.adapt(task));
        }
        this.invoke(new InvokeAll(forkJoinTasks));
        ArrayList<Future<T>> futures = forkJoinTasks;
        return futures;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return this.factory;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.ueh;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public int getPoolSize() {
        return this.workerCounts >>> 16;
    }

    public boolean getAsyncMode() {
        return this.locallyFifo;
    }

    public int getRunningThreadCount() {
        return this.workerCounts & 0xFFFF;
    }

    public int getActiveThreadCount() {
        return this.runState & 0xFFFF;
    }

    public boolean isQuiescent() {
        return (this.runState & 0xFFFF) == 0;
    }

    public long getStealCount() {
        return this.stealCount;
    }

    public long getQueuedTaskCount() {
        long count = 0L;
        for (ForkJoinWorkerThread w : this.workers) {
            if (w == null) continue;
            count += (long)w.getQueueSize();
        }
        return count;
    }

    public int getQueuedSubmissionCount() {
        return this.submissionQueue.size();
    }

    public boolean hasQueuedSubmissions() {
        return !this.submissionQueue.isEmpty();
    }

    protected ForkJoinTask<?> pollSubmission() {
        return this.submissionQueue.poll();
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> c) {
        int count = this.submissionQueue.drainTo(c);
        for (ForkJoinWorkerThread w : this.workers) {
            if (w == null) continue;
            count += w.drainTasksTo(c);
        }
        return count;
    }

    public String toString() {
        long st = this.getStealCount();
        long qt = this.getQueuedTaskCount();
        long qs = this.getQueuedSubmissionCount();
        int wc = this.workerCounts;
        int tc = wc >>> 16;
        int rc = wc & 0xFFFF;
        int pc = this.parallelism;
        int rs = this.runState;
        int ac = rs & 0xFFFF;
        return super.toString() + "[" + ForkJoinPool.runLevelToString(rs) + ", parallelism = " + pc + ", size = " + tc + ", active = " + ac + ", running = " + rc + ", steals = " + st + ", tasks = " + qt + ", submissions = " + qs + "]";
    }

    private static String runLevelToString(int s) {
        return (s & 0x40000) != 0 ? "Terminated" : ((s & 0x20000) != 0 ? "Terminating" : ((s & 0x10000) != 0 ? "Shutting down" : "Running"));
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.advanceRunLevel(65536);
        this.tryTerminate(false);
    }

    @Override
    public List<Runnable> shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        return this.runState >= 262144;
    }

    public boolean isTerminating() {
        return (this.runState & 0x60000) == 131072;
    }

    final boolean isAtLeastTerminating() {
        return this.runState >= 131072;
    }

    @Override
    public boolean isShutdown() {
        return this.runState >= 65536;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.termination.awaitAdvanceInterruptibly(0, timeout, unit);
        }
        catch (TimeoutException ex) {
            return false;
        }
        return true;
    }

    public static void managedBlock(ManagedBlocker blocker) throws InterruptedException {
        Thread t = Thread.currentThread();
        if (t instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread w = (ForkJoinWorkerThread)t;
            w.pool.awaitBlocker(blocker);
        } else {
            while (!blocker.isReleasable() && !blocker.block()) {
            }
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(runnable, value));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return (RunnableFuture)((Object)ForkJoinTask.adapt(callable));
    }

    private static long objectFieldOffset(String field, Class<?> klazz) {
        try {
            return UNSAFE.objectFieldOffset(klazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldError error = new NoSuchFieldError(field);
            error.initCause(e);
            throw error;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class InvokeAll<T>
    extends RecursiveAction {
        final ArrayList<ForkJoinTask<T>> tasks;
        private static final long serialVersionUID = -7914297376763021607L;

        InvokeAll(ArrayList<ForkJoinTask<T>> tasks) {
            this.tasks = tasks;
        }

        @Override
        public void compute() {
            try {
                InvokeAll.invokeAll(this.tasks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            return new ForkJoinWorkerThread(pool);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

