/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent.resource;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicStampedReference;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.resource.AcquirableResource;

public class NonBlockingAcquirableResource<T extends Releasable>
implements AcquirableResource<T> {
    private final T resource;
    private AtomicStampedReference<Boolean> counter = new AtomicStampedReference<Boolean>(false, 0);
    private final AtomicBoolean closed = new AtomicBoolean();

    public NonBlockingAcquirableResource(T resource) {
        this.resource = resource;
    }

    @Override
    public T resource() {
        return this.resource;
    }

    @Override
    public boolean acquire() {
        do {
            int stamp = this.counter.getStamp();
            boolean result = this.counter.compareAndSet(false, false, stamp, stamp + 1);
            if (!result) continue;
            return true;
        } while (!this.counter.getReference().booleanValue());
        return false;
    }

    @Override
    public void release() {
        int stamp;
        boolean currentReference;
        boolean result;
        do {
            currentReference = this.counter.getReference();
            stamp = this.counter.getStamp();
        } while (!(result = this.counter.compareAndSet(currentReference, currentReference, stamp, stamp - 1)));
        if (currentReference && stamp <= 1) {
            this.close();
        }
    }

    @Override
    public void markForClose() {
        do {
            int stamp = this.counter.getStamp();
            boolean result = this.counter.compareAndSet(false, true, stamp, stamp);
            if (!result) continue;
            if (stamp <= 0) {
                this.close();
            }
            return;
        } while (!this.counter.getReference().booleanValue());
    }

    @Override
    public void forceClose() {
        this.close();
    }

    private void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.resource.release();
        }
    }
}

