/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.support;

import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.common.collect.MapEvictionListener;
import org.elasticsearch.common.collect.MapMaker;
import org.elasticsearch.common.lab.LongsLAB;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.docset.OpenBitDocSet;
import org.elasticsearch.common.lucene.docset.SlicedOpenBitSet;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.cache.filter.FilterCache;
import org.elasticsearch.index.settings.IndexSettings;

public abstract class AbstractConcurrentMapFilterCache
extends AbstractIndexComponent
implements FilterCache {
    final ConcurrentMap<Object, ReaderValue> cache = this.buildCache();
    final boolean labEnabled = this.componentSettings.getAsBoolean("lab", false);
    final ByteSizeValue labMaxAlloc = this.componentSettings.getAsBytesSize("lab.max_alloc", new ByteSizeValue(128L, ByteSizeUnit.KB));
    final ByteSizeValue labChunkSize = this.componentSettings.getAsBytesSize("lab.chunk_size", new ByteSizeValue(1L, ByteSizeUnit.MB));
    final int labMaxAllocBytes = (int)(this.labMaxAlloc.bytes() / 8L);
    final int labChunkSizeBytes = (int)(this.labChunkSize.bytes() / 8L);

    protected AbstractConcurrentMapFilterCache(Index index, @IndexSettings Settings indexSettings) {
        super(index, indexSettings);
    }

    protected ConcurrentMap<Object, ReaderValue> buildCache() {
        return new MapMaker().weakKeys().makeMap();
    }

    protected ConcurrentMap<Filter, DocSet> buildFilterMap() {
        return ConcurrentCollections.newConcurrentMap();
    }

    @Override
    public void close() {
        this.cache.clear();
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void clear(IndexReader reader) {
        ReaderValue readerValue = (ReaderValue)this.cache.remove(reader.getCoreCacheKey());
        if (readerValue != null) {
            readerValue.filters().clear();
        }
    }

    @Override
    public long sizeInBytes() {
        long sizeInBytes = 0L;
        for (ReaderValue readerValue : this.cache.values()) {
            for (DocSet docSet : readerValue.filters().values()) {
                sizeInBytes += docSet.sizeInBytes();
            }
        }
        return sizeInBytes;
    }

    @Override
    public long count() {
        long entries = 0L;
        for (ReaderValue readerValue : this.cache.values()) {
            entries += (long)readerValue.filters().size();
        }
        return entries;
    }

    @Override
    public Filter cache(Filter filterToCache) {
        if (this.isCached(filterToCache)) {
            return filterToCache;
        }
        return new FilterCacheFilterWrapper(filterToCache, this);
    }

    @Override
    public boolean isCached(Filter filter) {
        return filter instanceof FilterCacheFilterWrapper;
    }

    public static class CacheMapEvictionListener
    implements MapEvictionListener<Object, ReaderValue> {
        private final AtomicLong evictions;

        public CacheMapEvictionListener(AtomicLong evictions) {
            this.evictions = evictions;
        }

        @Override
        public void onEviction(Object o, ReaderValue readerValue) {
            this.evictions.incrementAndGet();
            if (readerValue != null) {
                readerValue.filters().clear();
            }
        }
    }

    public static class ReaderValue {
        private final ConcurrentMap<Filter, DocSet> filters;
        private final LongsLAB longsLAB;

        public ReaderValue(ConcurrentMap<Filter, DocSet> filters, LongsLAB longsLAB) {
            this.filters = filters;
            this.longsLAB = longsLAB;
        }

        public ConcurrentMap<Filter, DocSet> filters() {
            return this.filters;
        }

        public LongsLAB longsLAB() {
            return this.longsLAB;
        }
    }

    static class FilterCacheFilterWrapper
    extends Filter {
        private final Filter filter;
        private final AbstractConcurrentMapFilterCache cache;

        FilterCacheFilterWrapper(Filter filter, AbstractConcurrentMapFilterCache cache) {
            this.filter = filter;
            this.cache = cache;
        }

        @Override
        public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
            DocSet docSet;
            ReaderValue readerValue = (ReaderValue)this.cache.cache.get(reader.getCoreCacheKey());
            if (readerValue == null) {
                LongsLAB longsLAB = null;
                if (this.cache.labEnabled) {
                    longsLAB = new LongsLAB(this.cache.labChunkSizeBytes, this.cache.labMaxAllocBytes);
                }
                readerValue = new ReaderValue(this.cache.buildFilterMap(), longsLAB);
                ReaderValue prev = this.cache.cache.putIfAbsent(reader.getCoreCacheKey(), readerValue);
                if (prev != null) {
                    readerValue = prev;
                }
            }
            if ((docSet = (DocSet)readerValue.filters().get(this.filter)) != null) {
                return docSet;
            }
            DocIdSet docIdSet = this.filter.getDocIdSet(reader);
            docSet = this.cacheable(reader, readerValue, docIdSet);
            DocSet prev = readerValue.filters().putIfAbsent(this.filter, docSet);
            if (prev != null) {
                docSet = prev;
            }
            return docSet;
        }

        public String toString() {
            return "FilterCacheFilterWrapper(" + this.filter + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof FilterCacheFilterWrapper)) {
                return false;
            }
            return this.filter.equals(((FilterCacheFilterWrapper)o).filter);
        }

        public int hashCode() {
            return this.filter.hashCode() ^ 0x1117BF25;
        }

        private DocSet cacheable(IndexReader reader, ReaderValue readerValue, DocIdSet set) throws IOException {
            if (set == null) {
                return DocSet.EMPTY_DOC_SET;
            }
            if (set == DocIdSet.EMPTY_DOCIDSET) {
                return DocSet.EMPTY_DOC_SET;
            }
            DocIdSetIterator it = set.iterator();
            if (it == null) {
                return DocSet.EMPTY_DOC_SET;
            }
            int doc = it.nextDoc();
            if (doc == Integer.MAX_VALUE) {
                return DocSet.EMPTY_DOC_SET;
            }
            if (readerValue.longsLAB() == null) {
                return DocSets.cacheable(reader, set);
            }
            int numOfWords = OpenBitSet.bits2words(reader.maxDoc());
            LongsLAB.Allocation allocation = readerValue.longsLAB().allocateLongs(numOfWords);
            if (allocation == null) {
                return DocSets.cacheable(reader, set);
            }
            if (set instanceof OpenBitSet) {
                return new SlicedOpenBitSet(allocation.getData(), allocation.getOffset(), (OpenBitSet)set);
            }
            if (set instanceof OpenBitDocSet) {
                return new SlicedOpenBitSet(allocation.getData(), allocation.getOffset(), ((OpenBitDocSet)set).set());
            }
            SlicedOpenBitSet slicedSet = new SlicedOpenBitSet(allocation.getData(), numOfWords, allocation.getOffset());
            slicedSet.fastSet(doc);
            while ((doc = it.nextDoc()) != Integer.MAX_VALUE) {
                slicedSet.fastSet(doc);
            }
            return slicedSet;
        }
    }
}

